/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.action.bulk;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.graylog.shaded.opensearch2.org.opensearch.action.ActionListener;
import org.graylog.shaded.opensearch2.org.opensearch.action.bulk.BackoffPolicy;
import org.graylog.shaded.opensearch2.org.opensearch.action.bulk.BulkItemResponse;
import org.graylog.shaded.opensearch2.org.opensearch.action.bulk.BulkRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.bulk.BulkResponse;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.PlainActionFuture;
import org.graylog.shaded.opensearch2.org.opensearch.common.unit.TimeValue;
import org.graylog.shaded.opensearch2.org.opensearch.rest.RestStatus;
import org.graylog.shaded.opensearch2.org.opensearch.threadpool.Scheduler;
import org.graylog.shaded.opensearch2.org.opensearch.transport.RemoteTransportException;

public class Retry {
    private final BackoffPolicy backoffPolicy;
    private final Scheduler scheduler;

    public Retry(BackoffPolicy backoffPolicy, Scheduler scheduler) {
        this.backoffPolicy = backoffPolicy;
        this.scheduler = scheduler;
    }

    public void withBackoff(BiConsumer<BulkRequest, ActionListener<BulkResponse>> consumer, BulkRequest bulkRequest, ActionListener<BulkResponse> listener) {
        RetryHandler r = new RetryHandler(this.backoffPolicy, consumer, listener, this.scheduler);
        r.execute(bulkRequest);
    }

    public PlainActionFuture<BulkResponse> withBackoff(BiConsumer<BulkRequest, ActionListener<BulkResponse>> consumer, BulkRequest bulkRequest) {
        PlainActionFuture<BulkResponse> future = PlainActionFuture.newFuture();
        this.withBackoff(consumer, bulkRequest, future);
        return future;
    }

    static class RetryHandler
    implements ActionListener<BulkResponse> {
        private static final RestStatus RETRY_STATUS = RestStatus.TOO_MANY_REQUESTS;
        private static final Logger logger = LogManager.getLogger(RetryHandler.class);
        private final Scheduler scheduler;
        private final BiConsumer<BulkRequest, ActionListener<BulkResponse>> consumer;
        private final ActionListener<BulkResponse> listener;
        private final Iterator<TimeValue> backoff;
        private final List<BulkItemResponse> responses = new ArrayList<BulkItemResponse>();
        private final long startTimestampNanos;
        private volatile BulkRequest currentBulkRequest;
        private volatile Scheduler.Cancellable retryCancellable;

        RetryHandler(BackoffPolicy backoffPolicy, BiConsumer<BulkRequest, ActionListener<BulkResponse>> consumer, ActionListener<BulkResponse> listener, Scheduler scheduler) {
            this.backoff = backoffPolicy.iterator();
            this.consumer = consumer;
            this.listener = listener;
            this.scheduler = scheduler;
            this.startTimestampNanos = System.nanoTime();
        }

        @Override
        public void onResponse(BulkResponse bulkItemResponses) {
            if (!bulkItemResponses.hasFailures()) {
                this.addResponses(bulkItemResponses, r -> true);
                this.finishHim();
            } else if (this.canRetry(bulkItemResponses)) {
                this.addResponses(bulkItemResponses, r -> !r.isFailed());
                this.retry(this.createBulkRequestForRetry(bulkItemResponses));
            } else {
                this.addResponses(bulkItemResponses, r -> true);
                this.finishHim();
            }
        }

        @Override
        public void onFailure(Exception e) {
            if (e instanceof RemoteTransportException && ((RemoteTransportException)e).status() == RETRY_STATUS && this.backoff.hasNext()) {
                this.retry(this.currentBulkRequest);
            } else {
                try {
                    this.listener.onFailure(e);
                }
                finally {
                    if (this.retryCancellable != null) {
                        this.retryCancellable.cancel();
                    }
                }
            }
        }

        private void retry(BulkRequest bulkRequestForRetry) {
            assert (this.backoff.hasNext());
            TimeValue next = this.backoff.next();
            logger.trace("Retry of bulk request scheduled in {} ms.", (Object)next.millis());
            this.retryCancellable = this.scheduler.schedule(() -> this.execute(bulkRequestForRetry), next, "same");
        }

        private BulkRequest createBulkRequestForRetry(BulkResponse bulkItemResponses) {
            BulkRequest requestToReissue = new BulkRequest();
            int index = 0;
            for (BulkItemResponse bulkItemResponse : bulkItemResponses.getItems()) {
                if (bulkItemResponse.isFailed()) {
                    requestToReissue.add(this.currentBulkRequest.requests().get(index));
                }
                ++index;
            }
            return requestToReissue;
        }

        private boolean canRetry(BulkResponse bulkItemResponses) {
            if (!this.backoff.hasNext()) {
                return false;
            }
            for (BulkItemResponse bulkItemResponse : bulkItemResponses) {
                RestStatus status;
                if (!bulkItemResponse.isFailed() || (status = bulkItemResponse.status()) == RETRY_STATUS) continue;
                return false;
            }
            return true;
        }

        private void finishHim() {
            try {
                this.listener.onResponse(this.getAccumulatedResponse());
            }
            finally {
                if (this.retryCancellable != null) {
                    this.retryCancellable.cancel();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addResponses(BulkResponse response, Predicate<BulkItemResponse> filter) {
            for (BulkItemResponse bulkItemResponse : response) {
                if (!filter.test(bulkItemResponse)) continue;
                List<BulkItemResponse> list = this.responses;
                synchronized (list) {
                    this.responses.add(bulkItemResponse);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private BulkResponse getAccumulatedResponse() {
            BulkItemResponse[] itemResponses;
            List<BulkItemResponse> list = this.responses;
            synchronized (list) {
                itemResponses = this.responses.toArray(new BulkItemResponse[1]);
            }
            long stopTimestamp = System.nanoTime();
            long totalLatencyMs = TimeValue.timeValueNanos(stopTimestamp - this.startTimestampNanos).millis();
            return new BulkResponse(itemResponses, totalLatencyMs);
        }

        public void execute(BulkRequest bulkRequest) {
            this.currentBulkRequest = bulkRequest;
            this.consumer.accept(bulkRequest, this);
        }
    }
}

