/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.action.admin.indices.shards;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.graylog.shaded.opensearch2.com.carrotsearch.hppc.cursors.IntObjectCursor;
import org.graylog.shaded.opensearch2.com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import org.graylog.shaded.opensearch2.org.opensearch.LegacyESVersion;
import org.graylog.shaded.opensearch2.org.opensearch.OpenSearchException;
import org.graylog.shaded.opensearch2.org.opensearch.action.ActionResponse;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.DefaultShardOperationFailedException;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.node.DiscoveryNode;
import org.graylog.shaded.opensearch2.org.opensearch.common.collect.ImmutableOpenIntMap;
import org.graylog.shaded.opensearch2.org.opensearch.common.collect.ImmutableOpenMap;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.Writeable;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.ToXContent;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.ToXContentFragment;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.XContentBuilder;

public class IndicesShardStoresResponse
extends ActionResponse
implements ToXContentFragment {
    private final ImmutableOpenMap<String, ImmutableOpenIntMap<List<StoreStatus>>> storeStatuses;
    private final List<Failure> failures;

    public IndicesShardStoresResponse(ImmutableOpenMap<String, ImmutableOpenIntMap<List<StoreStatus>>> storeStatuses, List<Failure> failures) {
        this.storeStatuses = storeStatuses;
        this.failures = failures;
    }

    IndicesShardStoresResponse() {
        this(ImmutableOpenMap.of(), Collections.emptyList());
    }

    public IndicesShardStoresResponse(StreamInput in) throws IOException {
        super(in);
        this.storeStatuses = in.readImmutableMap(StreamInput::readString, i -> {
            int indexEntries = i.readVInt();
            ImmutableOpenIntMap.Builder<List<StoreStatus>> shardEntries = ImmutableOpenIntMap.builder();
            for (int shardCount = 0; shardCount < indexEntries; ++shardCount) {
                shardEntries.put(i.readInt(), i.readList(StoreStatus::new));
            }
            return shardEntries.build();
        });
        this.failures = Collections.unmodifiableList(in.readList(Failure::readFailure));
    }

    public ImmutableOpenMap<String, ImmutableOpenIntMap<List<StoreStatus>>> getStoreStatuses() {
        return this.storeStatuses;
    }

    public List<Failure> getFailures() {
        return this.failures;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeMap(this.storeStatuses, StreamOutput::writeString, (o, v) -> {
            o.writeVInt(v.size());
            for (IntObjectCursor shardStatusesEntry : v) {
                o.writeInt(shardStatusesEntry.key);
                o.writeCollection((Collection)shardStatusesEntry.value);
            }
        });
        out.writeList(this.failures);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.failures.size() > 0) {
            builder.startArray("failures");
            for (Failure failure : this.failures) {
                failure.toXContent(builder, params);
            }
            builder.endArray();
        }
        builder.startObject("indices");
        for (ObjectObjectCursor objectObjectCursor : this.storeStatuses) {
            builder.startObject((String)objectObjectCursor.key);
            builder.startObject("shards");
            for (IntObjectCursor shardStatusesEntry : (ImmutableOpenIntMap)objectObjectCursor.value) {
                builder.startObject(String.valueOf(shardStatusesEntry.key));
                builder.startArray("stores");
                for (StoreStatus storeStatus : (List)shardStatusesEntry.value) {
                    builder.startObject();
                    storeStatus.toXContent(builder, params);
                    builder.endObject();
                }
                builder.endArray();
                builder.endObject();
            }
            builder.endObject();
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    static final class Fields {
        static final String INDICES = "indices";
        static final String SHARDS = "shards";
        static final String FAILURES = "failures";
        static final String STORES = "stores";
        static final String ALLOCATION_ID = "allocation_id";
        static final String STORE_EXCEPTION = "store_exception";
        static final String ALLOCATED = "allocation";

        Fields() {
        }
    }

    public static class Failure
    extends DefaultShardOperationFailedException {
        private String nodeId;

        public Failure(String nodeId, String index, int shardId, Throwable reason) {
            super(index, shardId, reason);
            this.nodeId = nodeId;
        }

        private Failure(StreamInput in) throws IOException {
            if (in.getVersion().before(LegacyESVersion.V_7_4_0)) {
                this.nodeId = in.readString();
            }
            Failure.readFrom(in, this);
            if (in.getVersion().onOrAfter(LegacyESVersion.V_7_4_0)) {
                this.nodeId = in.readString();
            }
        }

        public String nodeId() {
            return this.nodeId;
        }

        static Failure readFailure(StreamInput in) throws IOException {
            return new Failure(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            if (out.getVersion().before(LegacyESVersion.V_7_4_0)) {
                out.writeString(this.nodeId);
            }
            super.writeTo(out);
            if (out.getVersion().onOrAfter(LegacyESVersion.V_7_4_0)) {
                out.writeString(this.nodeId);
            }
        }

        @Override
        public XContentBuilder innerToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field("node", this.nodeId());
            return super.innerToXContent(builder, params);
        }
    }

    public static class StoreStatus
    implements Writeable,
    ToXContentFragment,
    Comparable<StoreStatus> {
        private final DiscoveryNode node;
        private final String allocationId;
        private Exception storeException;
        private final AllocationStatus allocationStatus;

        public StoreStatus(StreamInput in) throws IOException {
            this.node = new DiscoveryNode(in);
            this.allocationId = in.readOptionalString();
            this.allocationStatus = AllocationStatus.readFrom(in);
            if (in.readBoolean()) {
                this.storeException = in.readException();
            }
        }

        public StoreStatus(DiscoveryNode node, String allocationId, AllocationStatus allocationStatus, Exception storeException) {
            this.node = node;
            this.allocationId = allocationId;
            this.allocationStatus = allocationStatus;
            this.storeException = storeException;
        }

        public DiscoveryNode getNode() {
            return this.node;
        }

        public String getAllocationId() {
            return this.allocationId;
        }

        public Exception getStoreException() {
            return this.storeException;
        }

        public AllocationStatus getAllocationStatus() {
            return this.allocationStatus;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            this.node.writeTo(out);
            out.writeOptionalString(this.allocationId);
            this.allocationStatus.writeTo(out);
            if (this.storeException != null) {
                out.writeBoolean(true);
                out.writeException(this.storeException);
            } else {
                out.writeBoolean(false);
            }
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            this.node.toXContent(builder, params);
            if (this.allocationId != null) {
                builder.field("allocation_id", this.allocationId);
            }
            builder.field("allocation", this.allocationStatus.value());
            if (this.storeException != null) {
                builder.startObject("store_exception");
                OpenSearchException.generateThrowableXContent(builder, params, this.storeException);
                builder.endObject();
            }
            return builder;
        }

        @Override
        public int compareTo(StoreStatus other) {
            if (this.storeException != null && other.storeException == null) {
                return 1;
            }
            if (other.storeException != null && this.storeException == null) {
                return -1;
            }
            if (this.allocationId != null && other.allocationId == null) {
                return -1;
            }
            if (this.allocationId == null && other.allocationId != null) {
                return 1;
            }
            if (this.allocationId == null && other.allocationId == null) {
                return Integer.compare(this.allocationStatus.id, other.allocationStatus.id);
            }
            int compare = Integer.compare(this.allocationStatus.id, other.allocationStatus.id);
            if (compare == 0) {
                return this.allocationId.compareTo(other.allocationId);
            }
            return compare;
        }

        public static enum AllocationStatus {
            PRIMARY(0),
            REPLICA(1),
            UNUSED(2);

            private final byte id;

            private AllocationStatus(byte id) {
                this.id = id;
            }

            private static AllocationStatus fromId(byte id) {
                switch (id) {
                    case 0: {
                        return PRIMARY;
                    }
                    case 1: {
                        return REPLICA;
                    }
                    case 2: {
                        return UNUSED;
                    }
                }
                throw new IllegalArgumentException("unknown id for allocation status [" + id + "]");
            }

            public String value() {
                switch (this.id) {
                    case 0: {
                        return "primary";
                    }
                    case 1: {
                        return "replica";
                    }
                    case 2: {
                        return "unused";
                    }
                }
                throw new IllegalArgumentException("unknown id for allocation status [" + this.id + "]");
            }

            private static AllocationStatus readFrom(StreamInput in) throws IOException {
                return AllocationStatus.fromId(in.readByte());
            }

            private void writeTo(StreamOutput out) throws IOException {
                out.writeByte(this.id);
            }
        }
    }
}

