/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.action.admin.cluster.stats;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.cluster.stats.IndexFeatureStats;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.cluster.stats.MappingVisitor;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.ClusterState;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.IndexMetadata;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.MappingMetadata;
import org.graylog.shaded.opensearch2.org.opensearch.common.Strings;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.Writeable;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.ToXContent;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.ToXContentFragment;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.XContentBuilder;

public final class MappingStats
implements ToXContentFragment,
Writeable {
    private final Set<IndexFeatureStats> fieldTypeStats;

    public static MappingStats of(ClusterState state) {
        HashMap fieldTypes = new HashMap();
        for (IndexMetadata indexMetadata : state.metadata()) {
            HashSet indexFieldTypes = new HashSet();
            MappingMetadata mappingMetadata = indexMetadata.mapping();
            if (mappingMetadata == null) continue;
            MappingVisitor.visitMapping(mappingMetadata.getSourceAsMap(), fieldMapping -> {
                String type = null;
                Object typeO = fieldMapping.get("type");
                if (typeO != null) {
                    type = typeO.toString();
                } else if (fieldMapping.containsKey("properties")) {
                    type = "object";
                }
                if (type != null) {
                    IndexFeatureStats stats = fieldTypes.computeIfAbsent(type, IndexFeatureStats::new);
                    ++stats.count;
                    if (indexFieldTypes.add(type)) {
                        ++stats.indexCount;
                    }
                }
            });
        }
        return new MappingStats(fieldTypes.values());
    }

    MappingStats(Collection<IndexFeatureStats> fieldTypeStats) {
        ArrayList<IndexFeatureStats> stats = new ArrayList<IndexFeatureStats>(fieldTypeStats);
        stats.sort(Comparator.comparing(IndexFeatureStats::getName));
        this.fieldTypeStats = Collections.unmodifiableSet(new LinkedHashSet<IndexFeatureStats>(stats));
    }

    MappingStats(StreamInput in) throws IOException {
        this.fieldTypeStats = Collections.unmodifiableSet(new LinkedHashSet<IndexFeatureStats>(in.readList(IndexFeatureStats::new)));
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeCollection(this.fieldTypeStats);
    }

    public Set<IndexFeatureStats> getFieldTypeStats() {
        return this.fieldTypeStats;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("mappings");
        builder.startArray("field_types");
        for (IndexFeatureStats st : this.fieldTypeStats) {
            st.toXContent(builder, params);
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    public String toString() {
        return Strings.toString(this, true, true);
    }

    public boolean equals(Object o) {
        if (!(o instanceof MappingStats)) {
            return false;
        }
        MappingStats that = (MappingStats)o;
        return this.fieldTypeStats.equals(that.fieldTypeStats);
    }

    public int hashCode() {
        return this.fieldTypeStats.hashCode();
    }
}

