/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.action.admin.cluster.snapshots.status;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.graylog.shaded.opensearch2.org.opensearch.LegacyESVersion;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.cluster.snapshots.status.SnapshotIndexShardStatus;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.cluster.snapshots.status.SnapshotIndexStatus;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.cluster.snapshots.status.SnapshotShardsStats;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.cluster.snapshots.status.SnapshotStats;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.SnapshotsInProgress;
import org.graylog.shaded.opensearch2.org.opensearch.common.Nullable;
import org.graylog.shaded.opensearch2.org.opensearch.common.ParseField;
import org.graylog.shaded.opensearch2.org.opensearch.common.Strings;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.Writeable;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.ConstructingObjectParser;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.ObjectParser;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.ToXContent;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.ToXContentObject;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.XContentBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.XContentParser;
import org.graylog.shaded.opensearch2.org.opensearch.snapshots.Snapshot;
import org.graylog.shaded.opensearch2.org.opensearch.snapshots.SnapshotId;

public class SnapshotStatus
implements ToXContentObject,
Writeable {
    private final Snapshot snapshot;
    private final SnapshotsInProgress.State state;
    private final List<SnapshotIndexShardStatus> shards;
    private Map<String, SnapshotIndexStatus> indicesStatus;
    private SnapshotShardsStats shardsStats;
    private SnapshotStats stats;
    @Nullable
    private final Boolean includeGlobalState;
    private static final String SNAPSHOT = "snapshot";
    private static final String REPOSITORY = "repository";
    private static final String UUID = "uuid";
    private static final String STATE = "state";
    private static final String INDICES = "indices";
    private static final String INCLUDE_GLOBAL_STATE = "include_global_state";
    static final ConstructingObjectParser<SnapshotStatus, Void> PARSER = new ConstructingObjectParser("snapshot_status", true, parsedObjects -> {
        List<SnapshotIndexShardStatus> shards;
        Map<String, SnapshotIndexStatus> indicesStatus;
        int i = 0;
        String name = (String)parsedObjects[i++];
        String repository = (String)parsedObjects[i++];
        String uuid = (String)parsedObjects[i++];
        String rawState = (String)parsedObjects[i++];
        Boolean includeGlobalState = (Boolean)parsedObjects[i++];
        SnapshotStats stats = (SnapshotStats)parsedObjects[i++];
        SnapshotShardsStats shardsStats = (SnapshotShardsStats)parsedObjects[i++];
        List indices = (List)parsedObjects[i];
        Snapshot snapshot = new Snapshot(repository, new SnapshotId(name, uuid));
        SnapshotsInProgress.State state = SnapshotsInProgress.State.valueOf(rawState);
        if (indices == null || indices.isEmpty()) {
            indicesStatus = Collections.emptyMap();
            shards = Collections.emptyList();
        } else {
            indicesStatus = new HashMap(indices.size());
            shards = new ArrayList();
            for (SnapshotIndexStatus index : indices) {
                indicesStatus.put(index.getIndex(), index);
                shards.addAll(index.getShards().values());
            }
        }
        return new SnapshotStatus(snapshot, state, shards, indicesStatus, shardsStats, stats, includeGlobalState);
    });

    SnapshotStatus(StreamInput in) throws IOException {
        long time;
        long startTime;
        this.snapshot = new Snapshot(in);
        this.state = SnapshotsInProgress.State.fromValue(in.readByte());
        this.shards = Collections.unmodifiableList(in.readList(SnapshotIndexShardStatus::new));
        this.includeGlobalState = in.readOptionalBoolean();
        if (in.getVersion().onOrAfter(LegacyESVersion.V_7_4_0)) {
            startTime = in.readLong();
            time = in.readLong();
        } else {
            startTime = 0L;
            time = 0L;
        }
        this.updateShardStats(startTime, time);
    }

    SnapshotStatus(Snapshot snapshot, SnapshotsInProgress.State state, List<SnapshotIndexShardStatus> shards, Boolean includeGlobalState, long startTime, long time) {
        this.snapshot = Objects.requireNonNull(snapshot);
        this.state = Objects.requireNonNull(state);
        this.shards = Objects.requireNonNull(shards);
        this.includeGlobalState = includeGlobalState;
        this.shardsStats = new SnapshotShardsStats(shards);
        assert (time >= 0L) : "time must be >= 0 but received [" + time + "]";
        this.updateShardStats(startTime, time);
    }

    private SnapshotStatus(Snapshot snapshot, SnapshotsInProgress.State state, List<SnapshotIndexShardStatus> shards, Map<String, SnapshotIndexStatus> indicesStatus, SnapshotShardsStats shardsStats, SnapshotStats stats, Boolean includeGlobalState) {
        this.snapshot = snapshot;
        this.state = state;
        this.shards = shards;
        this.indicesStatus = indicesStatus;
        this.shardsStats = shardsStats;
        this.stats = stats;
        this.includeGlobalState = includeGlobalState;
    }

    public Snapshot getSnapshot() {
        return this.snapshot;
    }

    public SnapshotsInProgress.State getState() {
        return this.state;
    }

    public Boolean includeGlobalState() {
        return this.includeGlobalState;
    }

    public List<SnapshotIndexShardStatus> getShards() {
        return this.shards;
    }

    public SnapshotShardsStats getShardsStats() {
        return this.shardsStats;
    }

    public Map<String, SnapshotIndexStatus> getIndices() {
        if (this.indicesStatus != null) {
            return this.indicesStatus;
        }
        HashMap<String, SnapshotIndexStatus> indicesStatus = new HashMap<String, SnapshotIndexStatus>();
        HashSet<String> indices = new HashSet<String>();
        for (SnapshotIndexShardStatus shard : this.shards) {
            indices.add(shard.getIndex());
        }
        for (String index : indices) {
            ArrayList<SnapshotIndexShardStatus> shards = new ArrayList<SnapshotIndexShardStatus>();
            for (SnapshotIndexShardStatus shard : this.shards) {
                if (!shard.getIndex().equals(index)) continue;
                shards.add(shard);
            }
            indicesStatus.put(index, new SnapshotIndexStatus(index, shards));
        }
        this.indicesStatus = Collections.unmodifiableMap(indicesStatus);
        return this.indicesStatus;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.snapshot.writeTo(out);
        out.writeByte(this.state.value());
        out.writeList(this.shards);
        out.writeOptionalBoolean(this.includeGlobalState);
        if (out.getVersion().onOrAfter(LegacyESVersion.V_7_4_0)) {
            out.writeLong(this.stats.getStartTime());
            out.writeLong(this.stats.getTime());
        }
    }

    public String toString() {
        return Strings.toString(this, true, false);
    }

    public SnapshotStats getStats() {
        return this.stats;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(SNAPSHOT, this.snapshot.getSnapshotId().getName());
        builder.field(REPOSITORY, this.snapshot.getRepository());
        builder.field(UUID, this.snapshot.getSnapshotId().getUUID());
        builder.field(STATE, this.state.name());
        if (this.includeGlobalState != null) {
            builder.field(INCLUDE_GLOBAL_STATE, this.includeGlobalState);
        }
        builder.field("shards_stats", this.shardsStats, params);
        builder.field("stats", this.stats, params);
        builder.startObject(INDICES);
        for (SnapshotIndexStatus indexStatus : this.getIndices().values()) {
            indexStatus.toXContent(builder, params);
        }
        builder.endObject();
        builder.endObject();
        return builder;
    }

    public static SnapshotStatus fromXContent(XContentParser parser) throws IOException {
        return PARSER.parse(parser, null);
    }

    private void updateShardStats(long startTime, long time) {
        this.stats = new SnapshotStats(startTime, time, 0, 0, 0, 0L, 0L, 0L);
        this.shardsStats = new SnapshotShardsStats(this.shards);
        for (SnapshotIndexShardStatus shard : this.shards) {
            this.stats.add(shard.getStats(), startTime == 0L);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SnapshotStatus that = (SnapshotStatus)o;
        return Objects.equals(this.snapshot, that.snapshot) && this.state == that.state && Objects.equals(this.indicesStatus, that.indicesStatus) && Objects.equals(this.shardsStats, that.shardsStats) && Objects.equals(this.stats, that.stats) && Objects.equals(this.includeGlobalState, that.includeGlobalState);
    }

    public int hashCode() {
        int result = this.snapshot != null ? this.snapshot.hashCode() : 0;
        result = 31 * result + (this.state != null ? this.state.hashCode() : 0);
        result = 31 * result + (this.indicesStatus != null ? this.indicesStatus.hashCode() : 0);
        result = 31 * result + (this.shardsStats != null ? this.shardsStats.hashCode() : 0);
        result = 31 * result + (this.stats != null ? this.stats.hashCode() : 0);
        result = 31 * result + (this.includeGlobalState != null ? this.includeGlobalState.hashCode() : 0);
        return result;
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField(SNAPSHOT, new String[0]));
        PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField(REPOSITORY, new String[0]));
        PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField(UUID, new String[0]));
        PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField(STATE, new String[0]));
        PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), new ParseField(INCLUDE_GLOBAL_STATE, new String[0]));
        PARSER.declareField(ConstructingObjectParser.constructorArg(), SnapshotStats::fromXContent, new ParseField("stats", new String[0]), ObjectParser.ValueType.OBJECT);
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), SnapshotShardsStats.PARSER, new ParseField("shards_stats", new String[0]));
        PARSER.declareNamedObjects(ConstructingObjectParser.constructorArg(), SnapshotIndexStatus.PARSER, new ParseField(INDICES, new String[0]));
    }
}

