/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.action.admin.cluster.node.reload;

import java.io.IOException;
import java.util.Arrays;
import org.graylog.shaded.opensearch2.org.opensearch.LegacyESVersion;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.nodes.BaseNodesRequest;
import org.graylog.shaded.opensearch2.org.opensearch.common.CharArrays;
import org.graylog.shaded.opensearch2.org.opensearch.common.Nullable;
import org.graylog.shaded.opensearch2.org.opensearch.common.bytes.BytesArray;
import org.graylog.shaded.opensearch2.org.opensearch.common.bytes.BytesReference;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.SecureString;

public class NodesReloadSecureSettingsRequest
extends BaseNodesRequest<NodesReloadSecureSettingsRequest> {
    @Nullable
    private SecureString secureSettingsPassword;

    public NodesReloadSecureSettingsRequest() {
        super((String[])null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodesReloadSecureSettingsRequest(StreamInput in) throws IOException {
        super(in);
        if (in.getVersion().onOrAfter(LegacyESVersion.V_7_7_0)) {
            BytesReference bytesRef = in.readOptionalBytesReference();
            if (bytesRef != null) {
                byte[] bytes = BytesReference.toBytes(bytesRef);
                try {
                    this.secureSettingsPassword = new SecureString(CharArrays.utf8BytesToChars(bytes));
                }
                finally {
                    Arrays.fill(bytes, (byte)0);
                }
            } else {
                this.secureSettingsPassword = null;
            }
        }
    }

    public NodesReloadSecureSettingsRequest(String ... nodesIds) {
        super(nodesIds);
    }

    @Nullable
    public SecureString getSecureSettingsPassword() {
        return this.secureSettingsPassword;
    }

    public void setSecureStorePassword(SecureString secureStorePassword) {
        this.secureSettingsPassword = secureStorePassword;
    }

    public void closePassword() {
        if (this.secureSettingsPassword != null) {
            this.secureSettingsPassword.close();
        }
    }

    boolean hasPassword() {
        return this.secureSettingsPassword != null && this.secureSettingsPassword.length() > 0;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (out.getVersion().onOrAfter(LegacyESVersion.V_7_4_0)) {
            if (this.secureSettingsPassword == null) {
                out.writeOptionalBytesReference(null);
            } else {
                byte[] passwordBytes = CharArrays.toUtf8Bytes(this.secureSettingsPassword.getChars());
                try {
                    out.writeOptionalBytesReference(new BytesArray(passwordBytes));
                }
                finally {
                    Arrays.fill(passwordBytes, (byte)0);
                }
            }
        }
    }
}

