/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.action.admin.cluster.node.info;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.ToXContent;
import org.graylog.shaded.opensearch2.org.opensearch.common.xcontent.XContentBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.node.ReportingService;
import org.graylog.shaded.opensearch2.org.opensearch.plugins.PluginInfo;

public class PluginsAndModules
implements ReportingService.Info {
    private final List<PluginInfo> plugins;
    private final List<PluginInfo> modules;

    public PluginsAndModules(List<PluginInfo> plugins, List<PluginInfo> modules) {
        this.plugins = Collections.unmodifiableList(plugins);
        this.modules = Collections.unmodifiableList(modules);
    }

    public PluginsAndModules(StreamInput in) throws IOException {
        this.plugins = Collections.unmodifiableList(in.readList(PluginInfo::new));
        this.modules = Collections.unmodifiableList(in.readList(PluginInfo::new));
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeList(this.plugins);
        out.writeList(this.modules);
    }

    public List<PluginInfo> getPluginInfos() {
        ArrayList<PluginInfo> plugins = new ArrayList<PluginInfo>(this.plugins);
        Collections.sort(plugins, Comparator.comparing(PluginInfo::getName));
        return plugins;
    }

    public List<PluginInfo> getModuleInfos() {
        ArrayList<PluginInfo> modules = new ArrayList<PluginInfo>(this.modules);
        Collections.sort(modules, Comparator.comparing(PluginInfo::getName));
        return modules;
    }

    public void addPlugin(PluginInfo info) {
        this.plugins.add(info);
    }

    public void addModule(PluginInfo info) {
        this.modules.add(info);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startArray("plugins");
        for (PluginInfo pluginInfo : this.getPluginInfos()) {
            pluginInfo.toXContent(builder, params);
        }
        builder.endArray();
        builder.startArray("modules");
        for (PluginInfo moduleInfo : this.getModuleInfos()) {
            moduleInfo.toXContent(builder, params);
        }
        builder.endArray();
        return builder;
    }
}

