/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.action.admin.cluster.node.info;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.graylog.shaded.opensearch2.org.opensearch.LegacyESVersion;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.nodes.BaseNodesRequest;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamOutput;

public class NodesInfoRequest
extends BaseNodesRequest<NodesInfoRequest> {
    private Set<String> requestedMetrics = Metric.allMetrics();

    public NodesInfoRequest(StreamInput in) throws IOException {
        super(in);
        this.requestedMetrics.clear();
        if (in.getVersion().before(LegacyESVersion.V_7_7_0)) {
            this.optionallyAddMetric(in.readBoolean(), Metric.SETTINGS.metricName());
            this.optionallyAddMetric(in.readBoolean(), Metric.OS.metricName());
            this.optionallyAddMetric(in.readBoolean(), Metric.PROCESS.metricName());
            this.optionallyAddMetric(in.readBoolean(), Metric.JVM.metricName());
            this.optionallyAddMetric(in.readBoolean(), Metric.THREAD_POOL.metricName());
            this.optionallyAddMetric(in.readBoolean(), Metric.TRANSPORT.metricName());
            this.optionallyAddMetric(in.readBoolean(), Metric.HTTP.metricName());
            this.optionallyAddMetric(in.readBoolean(), Metric.PLUGINS.metricName());
            this.optionallyAddMetric(in.readBoolean(), Metric.INGEST.metricName());
            this.optionallyAddMetric(in.readBoolean(), Metric.INDICES.metricName());
        } else {
            this.requestedMetrics.addAll(Arrays.asList(in.readStringArray()));
        }
    }

    public NodesInfoRequest(String ... nodesIds) {
        super(nodesIds);
        this.all();
    }

    public NodesInfoRequest clear() {
        this.requestedMetrics.clear();
        return this;
    }

    public NodesInfoRequest all() {
        this.requestedMetrics.addAll(Metric.allMetrics());
        return this;
    }

    public Set<String> requestedMetrics() {
        return new HashSet<String>(this.requestedMetrics);
    }

    public NodesInfoRequest addMetric(String metric) {
        if (!Metric.allMetrics().contains(metric)) {
            throw new IllegalStateException("Used an illegal metric: " + metric);
        }
        this.requestedMetrics.add(metric);
        return this;
    }

    public NodesInfoRequest addMetrics(String ... metrics) {
        TreeSet<String> metricsSet = new TreeSet<String>(Arrays.asList(metrics));
        if (!Metric.allMetrics().containsAll(metricsSet)) {
            metricsSet.removeAll(Metric.allMetrics());
            String plural = metricsSet.size() == 1 ? "" : "s";
            throw new IllegalStateException("Used illegal metric" + plural + ": " + metricsSet);
        }
        this.requestedMetrics.addAll(metricsSet);
        return this;
    }

    public NodesInfoRequest removeMetric(String metric) {
        if (!Metric.allMetrics().contains(metric)) {
            throw new IllegalStateException("Used an illegal metric: " + metric);
        }
        this.requestedMetrics.remove(metric);
        return this;
    }

    private void optionallyAddMetric(boolean addMetric, String metricName) {
        if (addMetric) {
            this.requestedMetrics.add(metricName);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (out.getVersion().before(LegacyESVersion.V_7_7_0)) {
            out.writeBoolean(Metric.SETTINGS.containedIn(this.requestedMetrics));
            out.writeBoolean(Metric.OS.containedIn(this.requestedMetrics));
            out.writeBoolean(Metric.PROCESS.containedIn(this.requestedMetrics));
            out.writeBoolean(Metric.JVM.containedIn(this.requestedMetrics));
            out.writeBoolean(Metric.THREAD_POOL.containedIn(this.requestedMetrics));
            out.writeBoolean(Metric.TRANSPORT.containedIn(this.requestedMetrics));
            out.writeBoolean(Metric.HTTP.containedIn(this.requestedMetrics));
            out.writeBoolean(Metric.PLUGINS.containedIn(this.requestedMetrics));
            out.writeBoolean(Metric.INGEST.containedIn(this.requestedMetrics));
            out.writeBoolean(Metric.INDICES.containedIn(this.requestedMetrics));
        } else {
            out.writeStringArray(this.requestedMetrics.toArray(new String[0]));
        }
    }

    public static enum Metric {
        SETTINGS("settings"),
        OS("os"),
        PROCESS("process"),
        JVM("jvm"),
        THREAD_POOL("thread_pool"),
        TRANSPORT("transport"),
        HTTP("http"),
        PLUGINS("plugins"),
        INGEST("ingest"),
        AGGREGATIONS("aggregations"),
        INDICES("indices");

        private String metricName;

        private Metric(String name) {
            this.metricName = name;
        }

        public String metricName() {
            return this.metricName;
        }

        boolean containedIn(Set<String> metricNames) {
            return metricNames.contains(this.metricName());
        }

        public static Set<String> allMetrics() {
            return Arrays.stream(Metric.values()).map(Metric::metricName).collect(Collectors.toSet());
        }
    }
}

