/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.action.admin.cluster.node.info;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.graylog.shaded.opensearch2.org.opensearch.Build;
import org.graylog.shaded.opensearch2.org.opensearch.LegacyESVersion;
import org.graylog.shaded.opensearch2.org.opensearch.Version;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.cluster.node.info.PluginsAndModules;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.nodes.BaseNodeResponse;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.node.DiscoveryNode;
import org.graylog.shaded.opensearch2.org.opensearch.common.Nullable;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.Settings;
import org.graylog.shaded.opensearch2.org.opensearch.common.unit.ByteSizeValue;
import org.graylog.shaded.opensearch2.org.opensearch.http.HttpInfo;
import org.graylog.shaded.opensearch2.org.opensearch.ingest.IngestInfo;
import org.graylog.shaded.opensearch2.org.opensearch.monitor.jvm.JvmInfo;
import org.graylog.shaded.opensearch2.org.opensearch.monitor.os.OsInfo;
import org.graylog.shaded.opensearch2.org.opensearch.monitor.process.ProcessInfo;
import org.graylog.shaded.opensearch2.org.opensearch.node.ReportingService;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.support.AggregationInfo;
import org.graylog.shaded.opensearch2.org.opensearch.threadpool.ThreadPoolInfo;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportInfo;

public class NodeInfo
extends BaseNodeResponse {
    private Version version;
    private Build build;
    @Nullable
    private Settings settings;
    private Map<Class<? extends ReportingService.Info>, ReportingService.Info> infoMap = new HashMap<Class<? extends ReportingService.Info>, ReportingService.Info>();
    @Nullable
    private ByteSizeValue totalIndexingBuffer;

    public NodeInfo(StreamInput in) throws IOException {
        super(in);
        this.version = Version.readVersion(in);
        this.build = Build.readBuild(in);
        this.totalIndexingBuffer = in.readBoolean() ? new ByteSizeValue(in.readLong()) : null;
        if (in.readBoolean()) {
            this.settings = Settings.readSettingsFromStream(in);
        }
        this.addInfoIfNonNull(OsInfo.class, in.readOptionalWriteable(OsInfo::new));
        this.addInfoIfNonNull(ProcessInfo.class, in.readOptionalWriteable(ProcessInfo::new));
        this.addInfoIfNonNull(JvmInfo.class, in.readOptionalWriteable(JvmInfo::new));
        this.addInfoIfNonNull(ThreadPoolInfo.class, in.readOptionalWriteable(ThreadPoolInfo::new));
        this.addInfoIfNonNull(TransportInfo.class, in.readOptionalWriteable(TransportInfo::new));
        this.addInfoIfNonNull(HttpInfo.class, in.readOptionalWriteable(HttpInfo::new));
        this.addInfoIfNonNull(PluginsAndModules.class, in.readOptionalWriteable(PluginsAndModules::new));
        this.addInfoIfNonNull(IngestInfo.class, in.readOptionalWriteable(IngestInfo::new));
        if (in.getVersion().onOrAfter(LegacyESVersion.V_7_10_0)) {
            this.addInfoIfNonNull(AggregationInfo.class, in.readOptionalWriteable(AggregationInfo::new));
        }
    }

    public NodeInfo(Version version, Build build, DiscoveryNode node, @Nullable Settings settings, @Nullable OsInfo os, @Nullable ProcessInfo process, @Nullable JvmInfo jvm, @Nullable ThreadPoolInfo threadPool, @Nullable TransportInfo transport, @Nullable HttpInfo http, @Nullable PluginsAndModules plugins, @Nullable IngestInfo ingest, @Nullable AggregationInfo aggsInfo, @Nullable ByteSizeValue totalIndexingBuffer) {
        super(node);
        this.version = version;
        this.build = build;
        this.settings = settings;
        this.addInfoIfNonNull(OsInfo.class, os);
        this.addInfoIfNonNull(ProcessInfo.class, process);
        this.addInfoIfNonNull(JvmInfo.class, jvm);
        this.addInfoIfNonNull(ThreadPoolInfo.class, threadPool);
        this.addInfoIfNonNull(TransportInfo.class, transport);
        this.addInfoIfNonNull(HttpInfo.class, http);
        this.addInfoIfNonNull(PluginsAndModules.class, plugins);
        this.addInfoIfNonNull(IngestInfo.class, ingest);
        this.addInfoIfNonNull(AggregationInfo.class, aggsInfo);
        this.totalIndexingBuffer = totalIndexingBuffer;
    }

    @Nullable
    public String getHostname() {
        return this.getNode().getHostName();
    }

    public Version getVersion() {
        return this.version;
    }

    public Build getBuild() {
        return this.build;
    }

    @Nullable
    public Settings getSettings() {
        return this.settings;
    }

    public <T extends ReportingService.Info> T getInfo(Class<T> clazz) {
        return (T)((ReportingService.Info)clazz.cast(this.infoMap.get(clazz)));
    }

    @Nullable
    public ByteSizeValue getTotalIndexingBuffer() {
        return this.totalIndexingBuffer;
    }

    private <T extends ReportingService.Info> void addInfoIfNonNull(Class<T> clazz, T info) {
        if (info != null) {
            this.infoMap.put(clazz, info);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (out.getVersion().before(Version.V_1_0_0)) {
            out.writeVInt(LegacyESVersion.V_7_10_2.id);
        } else {
            out.writeVInt(this.version.id);
        }
        Build.writeBuild(this.build, out);
        if (this.totalIndexingBuffer == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeLong(this.totalIndexingBuffer.getBytes());
        }
        if (this.settings == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            Settings.writeSettingsToStream(this.settings, out);
        }
        out.writeOptionalWriteable(this.getInfo(OsInfo.class));
        out.writeOptionalWriteable(this.getInfo(ProcessInfo.class));
        out.writeOptionalWriteable(this.getInfo(JvmInfo.class));
        out.writeOptionalWriteable(this.getInfo(ThreadPoolInfo.class));
        out.writeOptionalWriteable(this.getInfo(TransportInfo.class));
        out.writeOptionalWriteable(this.getInfo(HttpInfo.class));
        out.writeOptionalWriteable(this.getInfo(PluginsAndModules.class));
        out.writeOptionalWriteable(this.getInfo(IngestInfo.class));
        if (out.getVersion().onOrAfter(LegacyESVersion.V_7_10_0)) {
            out.writeOptionalWriteable(this.getInfo(AggregationInfo.class));
        }
    }
}

