/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.util.hnsw;

public abstract class BoundsChecker {
    float bound;

    public abstract void update(float var1);

    public void set(float sample) {
        this.bound = sample;
    }

    public abstract boolean check(float var1);

    public static BoundsChecker create(boolean reversed) {
        if (reversed) {
            return new Min();
        }
        return new Max();
    }

    public static class Min
    extends BoundsChecker {
        Min() {
            this.bound = Float.POSITIVE_INFINITY;
        }

        @Override
        public void update(float sample) {
            if (sample < this.bound) {
                this.bound = sample;
            }
        }

        @Override
        public boolean check(float sample) {
            return sample > this.bound;
        }
    }

    public static class Max
    extends BoundsChecker {
        Max() {
            this.bound = Float.NEGATIVE_INFINITY;
        }

        @Override
        public void update(float sample) {
            if (sample > this.bound) {
                this.bound = sample;
            }
        }

        @Override
        public boolean check(float sample) {
            return sample < this.bound;
        }
    }
}

