/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.util;

import java.util.SplittableRandom;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.MathUtil;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.Selector;

public abstract class IntroSelector
extends Selector {
    private SplittableRandom random;

    @Override
    public final void select(int from, int to, int k) {
        this.checkArgs(from, to, k);
        this.select(from, to, k, 2 * MathUtil.log(to - from, 2));
    }

    void select(int from, int to, int k, int maxDepth) {
        int size;
        while ((size = to - from) > 3) {
            int pivot;
            int range;
            if (--maxDepth == -1) {
                this.shuffle(from, to);
            }
            int last = to - 1;
            int mid = from + last >>> 1;
            if (size <= 40) {
                range = size >> 2;
                pivot = this.median(mid - range, mid, mid + range);
            } else {
                range = size >> 3;
                int doubleRange = range << 1;
                int medianFirst = this.median(from, from + range, from + doubleRange);
                int medianMiddle = this.median(mid - range, mid, mid + range);
                int medianLast = this.median(last - doubleRange, last - range, last);
                pivot = k - from < range ? this.min(medianFirst, medianMiddle, medianLast) : (to - k <= range ? this.max(medianFirst, medianMiddle, medianLast) : this.median(medianFirst, medianMiddle, medianLast));
            }
            this.setPivot(pivot);
            this.swap(from, pivot);
            int i = from;
            int j = to;
            int p = from + 1;
            int q = last;
            while (true) {
                int rightCmp;
                int leftCmp;
                if ((leftCmp = this.comparePivot(++i)) > 0) {
                    continue;
                }
                while ((rightCmp = this.comparePivot(--j)) < 0) {
                }
                if (i >= j) {
                    if (i != j || rightCmp != 0) break;
                    this.swap(i, p);
                    break;
                }
                this.swap(i, j);
                if (rightCmp == 0) {
                    this.swap(i, p++);
                }
                if (leftCmp != 0) continue;
                this.swap(j, q--);
            }
            i = j + 1;
            int l = from;
            while (l < p) {
                this.swap(l++, j--);
            }
            l = last;
            while (l > q) {
                this.swap(l--, i++);
            }
            if (k <= j) {
                to = j + 1;
                continue;
            }
            if (k >= i) {
                from = i;
                continue;
            }
            return;
        }
        switch (size) {
            case 2: {
                if (this.compare(from, from + 1) <= 0) break;
                this.swap(from, from + 1);
                break;
            }
            case 3: {
                this.sort3(from);
            }
        }
    }

    private int min(int i, int j, int k) {
        if (this.compare(i, j) <= 0) {
            return this.compare(i, k) <= 0 ? i : k;
        }
        return this.compare(j, k) <= 0 ? j : k;
    }

    private int max(int i, int j, int k) {
        if (this.compare(i, j) <= 0) {
            return this.compare(j, k) < 0 ? k : j;
        }
        return this.compare(i, k) < 0 ? k : i;
    }

    private int median(int i, int j, int k) {
        if (this.compare(i, j) < 0) {
            if (this.compare(j, k) <= 0) {
                return j;
            }
            return this.compare(i, k) < 0 ? k : i;
        }
        if (this.compare(j, k) >= 0) {
            return j;
        }
        return this.compare(i, k) < 0 ? i : k;
    }

    private void sort3(int from) {
        int mid = from + 1;
        int last = from + 2;
        if (this.compare(from, mid) <= 0) {
            if (this.compare(mid, last) > 0) {
                this.swap(mid, last);
                if (this.compare(from, mid) > 0) {
                    this.swap(from, mid);
                }
            }
        } else if (this.compare(mid, last) >= 0) {
            this.swap(from, last);
        } else {
            this.swap(from, mid);
            if (this.compare(mid, last) > 0) {
                this.swap(mid, last);
            }
        }
    }

    private void shuffle(int from, int to) {
        if (this.random == null) {
            this.random = new SplittableRandom();
        }
        SplittableRandom random = this.random;
        for (int i = to - 1; i > from; --i) {
            this.swap(i, random.nextInt(from, i + 1));
        }
    }

    protected abstract void setPivot(int var1);

    protected abstract int comparePivot(int var1);

    protected int compare(int i, int j) {
        this.setPivot(i);
        return this.comparePivot(j);
    }
}

