/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom;

import org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom.Membership;
import org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom.Plane;
import org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom.PlanetModel;
import org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom.Vector;

public class SidedPlane
extends Plane
implements Membership {
    public final double sigNum;

    public SidedPlane(SidedPlane sidedPlane) {
        super((Vector)sidedPlane, sidedPlane.D);
        this.sigNum = -sidedPlane.sigNum;
    }

    public SidedPlane(double pX, double pY, double pZ, Vector A, Vector B) {
        super(A, B);
        this.sigNum = Math.signum(this.evaluate(pX, pY, pZ));
        if (this.sigNum == 0.0) {
            throw new IllegalArgumentException("Cannot determine sidedness because check point is on plane.");
        }
    }

    public SidedPlane(Vector p, Vector A, Vector B) {
        super(A, B);
        this.sigNum = Math.signum(this.evaluate(p));
        if (this.sigNum == 0.0) {
            throw new IllegalArgumentException("Cannot determine sidedness because check point is on plane.");
        }
    }

    public SidedPlane(Vector A, Vector B) {
        super(A, B);
        this.sigNum = 1.0;
    }

    public SidedPlane(Vector p, Vector A, double BX, double BY, double BZ) {
        super(A, BX, BY, BZ);
        this.sigNum = Math.signum(this.evaluate(p));
        if (this.sigNum == 0.0) {
            throw new IllegalArgumentException("Cannot determine sidedness because check point is on plane.");
        }
    }

    public SidedPlane(Vector p, boolean onSide, Vector A, Vector B) {
        super(A, B);
        double d = this.sigNum = onSide ? Math.signum(this.evaluate(p)) : -Math.signum(this.evaluate(p));
        if (this.sigNum == 0.0) {
            throw new IllegalArgumentException("Cannot determine sidedness because check point is on plane.");
        }
    }

    public SidedPlane(Vector p, PlanetModel planetModel, double sinLat) {
        super(planetModel, sinLat);
        this.sigNum = Math.signum(this.evaluate(p));
        if (this.sigNum == 0.0) {
            throw new IllegalArgumentException("Cannot determine sidedness because check point is on plane.");
        }
    }

    public SidedPlane(Vector p, double x, double y) {
        super(x, y);
        this.sigNum = Math.signum(this.evaluate(p));
        if (this.sigNum == 0.0) {
            throw new IllegalArgumentException("Cannot determine sidedness because check point is on plane.");
        }
    }

    public SidedPlane(Vector p, double vX, double vY, double vZ, double D) {
        super(vX, vY, vZ, D);
        this.sigNum = Math.signum(this.evaluate(p));
        if (this.sigNum == 0.0) {
            throw new IllegalArgumentException("Cannot determine sidedness because check point is on plane.");
        }
    }

    public SidedPlane(Vector p, Vector v, double D) {
        super(v, D);
        this.sigNum = Math.signum(this.evaluate(p));
        if (this.sigNum == 0.0) {
            throw new IllegalArgumentException("Cannot determine sidedness because check point is on plane.");
        }
    }

    public SidedPlane(double pX, double pY, double pZ, Vector v, double D) {
        super(v, D);
        this.sigNum = Math.signum(this.evaluate(pX, pY, pZ));
        if (this.sigNum == 0.0) {
            throw new IllegalArgumentException("Cannot determine sidedness because check point is on plane.");
        }
    }

    public static SidedPlane constructNormalizedPerpendicularSidedPlane(Vector insidePoint, Vector normalVector, Vector point1, Vector point2) {
        Vector pointsVector = new Vector(point1.x - point2.x, point1.y - point2.y, point1.z - point2.z);
        Vector newNormalVector = new Vector(normalVector, pointsVector);
        try {
            return new SidedPlane(insidePoint, newNormalVector, -newNormalVector.dotProduct(point1));
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static SidedPlane constructNormalizedThreePointSidedPlane(Vector insidePoint, Vector point1, Vector point2, Vector point3) {
        Vector planeNormal2;
        SidedPlane rval = null;
        try {
            planeNormal2 = new Vector(point1.x - point2.x, point1.y - point2.y, point1.z - point2.z, point2.x - point3.x, point2.y - point3.y, point2.z - point3.z);
            rval = new SidedPlane(insidePoint, planeNormal2, -planeNormal2.dotProduct(point2));
        }
        catch (IllegalArgumentException planeNormal2) {
            // empty catch block
        }
        if (rval == null) {
            try {
                planeNormal2 = new Vector(point1.x - point3.x, point1.y - point3.y, point1.z - point3.z, point3.x - point2.x, point3.y - point2.y, point3.z - point2.z);
                rval = new SidedPlane(insidePoint, planeNormal2, -planeNormal2.dotProduct(point3));
            }
            catch (IllegalArgumentException planeNormal3) {
                // empty catch block
            }
        }
        if (rval == null) {
            try {
                planeNormal2 = new Vector(point3.x - point1.x, point3.y - point1.y, point3.z - point1.z, point1.x - point2.x, point1.y - point2.y, point1.z - point2.z);
                rval = new SidedPlane(insidePoint, planeNormal2, -planeNormal2.dotProduct(point1));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return rval;
    }

    @Override
    public boolean isWithin(double x, double y, double z) {
        double evalResult = this.evaluate(x, y, z);
        if (Math.abs(evalResult) < 1.0E-12) {
            return true;
        }
        double sigNum = Math.signum(evalResult);
        return sigNum == this.sigNum;
    }

    public boolean strictlyWithin(Vector v) {
        double evalResult = this.evaluate(v.x, v.y, v.z);
        double sigNum = Math.signum(evalResult);
        return sigNum == 0.0 || sigNum == this.sigNum;
    }

    public boolean strictlyWithin(double x, double y, double z) {
        double evalResult = this.evaluate(x, y, z);
        double sigNum = Math.signum(evalResult);
        return sigNum == 0.0 || sigNum == this.sigNum;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SidedPlane)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SidedPlane that = (SidedPlane)o;
        return Double.compare(that.sigNum, this.sigNum) == 0;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        long temp = Double.doubleToLongBits(this.sigNum);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    @Override
    public String toString() {
        return "[A=" + this.x + ", B=" + this.y + ", C=" + this.z + ", D=" + this.D + ", side=" + this.sigNum + "]";
    }
}

