/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom;

import org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom.Bounds;
import org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom.GeoPoint;
import org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom.Membership;
import org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom.Plane;
import org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom.PlanetModel;

public class LatLonBounds
implements Bounds {
    private boolean noLongitudeBound = false;
    private boolean noTopLatitudeBound = false;
    private boolean noBottomLatitudeBound = false;
    private Double minLatitude = null;
    private Double maxLatitude = null;
    private Double leftLongitude = null;
    private Double rightLongitude = null;

    public Double getMaxLatitude() {
        return this.maxLatitude;
    }

    public Double getMinLatitude() {
        return this.minLatitude;
    }

    public Double getLeftLongitude() {
        return this.leftLongitude;
    }

    public Double getRightLongitude() {
        return this.rightLongitude;
    }

    public boolean checkNoLongitudeBound() {
        return this.noLongitudeBound;
    }

    public boolean checkNoTopLatitudeBound() {
        return this.noTopLatitudeBound;
    }

    public boolean checkNoBottomLatitudeBound() {
        return this.noBottomLatitudeBound;
    }

    @Override
    public Bounds addPlane(PlanetModel planetModel, Plane plane, Membership ... bounds) {
        plane.recordBounds(planetModel, this, bounds);
        return this;
    }

    @Override
    public Bounds addHorizontalPlane(PlanetModel planetModel, double latitude, Plane horizontalPlane, Membership ... bounds) {
        if (!this.noTopLatitudeBound || !this.noBottomLatitudeBound) {
            this.addLatitudeBound(latitude);
        }
        return this;
    }

    @Override
    public Bounds addVerticalPlane(PlanetModel planetModel, double longitude, Plane verticalPlane, Membership ... bounds) {
        if (!this.noLongitudeBound) {
            this.addLongitudeBound(longitude);
        }
        return this;
    }

    @Override
    public Bounds isWide() {
        return this.noLongitudeBound();
    }

    @Override
    public Bounds addXValue(GeoPoint point) {
        if (!this.noLongitudeBound) {
            this.addLongitudeBound(point.getLongitude());
        }
        return this;
    }

    @Override
    public Bounds addYValue(GeoPoint point) {
        if (!this.noLongitudeBound) {
            this.addLongitudeBound(point.getLongitude());
        }
        return this;
    }

    @Override
    public Bounds addZValue(GeoPoint point) {
        if (!this.noTopLatitudeBound || !this.noBottomLatitudeBound) {
            double latitude = point.getLatitude();
            this.addLatitudeBound(latitude);
        }
        return this;
    }

    @Override
    public Bounds addIntersection(PlanetModel planetModel, Plane plane1, Plane plane2, Membership ... bounds) {
        plane1.recordBounds(planetModel, this, plane2, bounds);
        return this;
    }

    @Override
    public Bounds addPoint(GeoPoint point) {
        if (!this.noLongitudeBound) {
            this.addLongitudeBound(point.getLongitude());
        }
        if (!this.noTopLatitudeBound || !this.noBottomLatitudeBound) {
            this.addLatitudeBound(point.getLatitude());
        }
        return this;
    }

    @Override
    public Bounds noLongitudeBound() {
        this.noLongitudeBound = true;
        this.leftLongitude = null;
        this.rightLongitude = null;
        return this;
    }

    @Override
    public Bounds noTopLatitudeBound() {
        this.noTopLatitudeBound = true;
        this.maxLatitude = null;
        return this;
    }

    @Override
    public Bounds noBottomLatitudeBound() {
        this.noBottomLatitudeBound = true;
        this.minLatitude = null;
        return this;
    }

    @Override
    public Bounds noBound(PlanetModel planetModel) {
        return this.noLongitudeBound().noTopLatitudeBound().noBottomLatitudeBound();
    }

    private void addLatitudeBound(double latitude) {
        if (!this.noTopLatitudeBound && (this.maxLatitude == null || latitude > this.maxLatitude)) {
            this.maxLatitude = latitude;
        }
        if (!this.noBottomLatitudeBound && (this.minLatitude == null || latitude < this.minLatitude)) {
            this.minLatitude = latitude;
        }
    }

    private void addLongitudeBound(double longitude) {
        if (this.leftLongitude == null && this.rightLongitude == null) {
            this.leftLongitude = longitude;
            this.rightLongitude = longitude;
        } else {
            double currentLeftLongitude = this.leftLongitude;
            double currentRightLongitude = this.rightLongitude;
            if (currentRightLongitude < currentLeftLongitude) {
                currentRightLongitude += Math.PI * 2;
            }
            if (longitude < currentLeftLongitude) {
                longitude += Math.PI * 2;
            }
            if (longitude < currentLeftLongitude || longitude > currentRightLongitude) {
                double rightExtensionAmt;
                double leftExtensionAmt = longitude < currentLeftLongitude ? currentLeftLongitude - longitude : currentLeftLongitude + Math.PI * 2 - longitude;
                if (leftExtensionAmt < (rightExtensionAmt = longitude > currentRightLongitude ? longitude - currentRightLongitude : longitude + Math.PI * 2 - currentRightLongitude)) {
                    for (currentLeftLongitude = this.leftLongitude - leftExtensionAmt; currentLeftLongitude <= -Math.PI; currentLeftLongitude += Math.PI * 2) {
                    }
                    this.leftLongitude = currentLeftLongitude;
                } else {
                    for (currentRightLongitude = this.rightLongitude + rightExtensionAmt; currentRightLongitude > Math.PI; currentRightLongitude -= Math.PI * 2) {
                    }
                    this.rightLongitude = currentRightLongitude;
                }
            }
        }
        double testRightLongitude = this.rightLongitude;
        if (testRightLongitude < this.leftLongitude) {
            testRightLongitude += Math.PI * 2;
        }
        if (testRightLongitude - this.leftLongitude >= Math.PI) {
            this.noLongitudeBound = true;
            this.leftLongitude = null;
            this.rightLongitude = null;
        }
    }
}

