/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom;

import java.io.IOException;
import java.io.InputStream;
import org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom.Bounds;
import org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom.DistanceStyle;
import org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom.GeoBBox;
import org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom.GeoBBoxFactory;
import org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom.GeoPoint;
import org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom.GeoPointShape;
import org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom.GeoShape;
import org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom.Membership;
import org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom.Plane;
import org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom.PlanetModel;
import org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom.Vector;

class GeoDegeneratePoint
extends GeoPoint
implements GeoPointShape {
    protected final PlanetModel planetModel;
    protected final GeoPoint[] edgePoints;

    public GeoDegeneratePoint(PlanetModel planetModel, double lat, double lon) {
        super(planetModel, lat, lon);
        this.planetModel = planetModel;
        this.edgePoints = new GeoPoint[]{this};
    }

    public GeoDegeneratePoint(PlanetModel planetModel, InputStream inputStream) throws IOException {
        super(planetModel, inputStream);
        this.planetModel = planetModel;
        this.edgePoints = new GeoPoint[]{this};
    }

    @Override
    public PlanetModel getPlanetModel() {
        return this.planetModel;
    }

    @Override
    public GeoBBox expand(double angle) {
        double newTopLat = this.latitude + angle;
        double newBottomLat = this.latitude - angle;
        double newLeftLon = this.longitude - angle;
        double newRightLon = this.longitude + angle;
        return GeoBBoxFactory.makeGeoBBox(this.planetModel, newTopLat, newBottomLat, newLeftLon, newRightLon);
    }

    @Override
    public GeoPoint[] getEdgePoints() {
        return this.edgePoints;
    }

    @Override
    public boolean intersects(Plane plane, GeoPoint[] notablePoints, Membership ... bounds) {
        if (!plane.evaluateIsZero(this)) {
            return false;
        }
        for (Membership m : bounds) {
            if (m.isWithin(this)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean intersects(GeoShape geoShape) {
        return geoShape.isWithin(this);
    }

    @Override
    public void getBounds(Bounds bounds) {
        bounds.addPoint(this);
    }

    @Override
    public double computeOutsideDistance(DistanceStyle distanceStyle, GeoPoint point) {
        return distanceStyle.computeDistance(this, point);
    }

    @Override
    public double computeOutsideDistance(DistanceStyle distanceStyle, double x, double y, double z) {
        return distanceStyle.computeDistance(this, x, y, z);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof GeoDegeneratePoint)) {
            return false;
        }
        GeoDegeneratePoint other = (GeoDegeneratePoint)o;
        return super.equals(other) && other.latitude == this.latitude && other.longitude == this.longitude;
    }

    @Override
    public String toString() {
        return "GeoDegeneratePoint: {planetmodel=" + this.planetModel + ", lat=" + this.latitude + "(" + this.latitude * 180.0 / Math.PI + "), lon=" + this.longitude + "(" + this.longitude * 180.0 / Math.PI + ")}";
    }

    @Override
    public boolean isWithin(Vector point) {
        return this.isWithin(point.x, point.y, point.z);
    }

    @Override
    public boolean isWithin(double x, double y, double z) {
        return this.isIdentical(x, y, z);
    }

    @Override
    public double getRadius() {
        return 0.0;
    }

    @Override
    public GeoPoint getCenter() {
        return this;
    }

    @Override
    public int getRelationship(GeoShape shape) {
        if (shape.isWithin(this)) {
            return 0;
        }
        return 3;
    }

    @Override
    public double computeDistance(DistanceStyle distanceStyle, double x, double y, double z) {
        if (this.isWithin(x, y, z)) {
            return 0.0;
        }
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public void getDistanceBounds(Bounds bounds, DistanceStyle distanceStyle, double distanceValue) {
        this.getBounds(bounds);
    }
}

