/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom.Bounds;
import org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom.DistanceStyle;
import org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom.GeoBasePath;
import org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom.GeoPoint;
import org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom.GeoShape;
import org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom.Membership;
import org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom.Plane;
import org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom.PlanetModel;
import org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom.SerializableObject;
import org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom.SidedPlane;
import org.graylog.shaded.opensearch2.org.apache.lucene.spatial3d.geom.Vector;

class GeoDegeneratePath
extends GeoBasePath {
    protected final List<GeoPoint> points = new ArrayList<GeoPoint>();
    protected List<SegmentEndpoint> endPoints;
    protected List<PathSegment> segments;
    protected GeoPoint[] edgePoints;
    protected boolean isDone = false;

    public GeoDegeneratePath(PlanetModel planetModel, GeoPoint[] pathPoints) {
        this(planetModel);
        Collections.addAll(this.points, pathPoints);
        this.done();
    }

    public GeoDegeneratePath(PlanetModel planetModel) {
        super(planetModel);
    }

    public void addPoint(double lat, double lon) {
        if (this.isDone) {
            throw new IllegalStateException("Can't call addPoint() if done() already called");
        }
        this.points.add(new GeoPoint(this.planetModel, lat, lon));
    }

    public void done() {
        if (this.isDone) {
            throw new IllegalStateException("Can't call done() twice");
        }
        if (this.points.size() == 0) {
            throw new IllegalArgumentException("Path must have at least one point");
        }
        this.isDone = true;
        this.endPoints = new ArrayList<SegmentEndpoint>(this.points.size());
        this.segments = new ArrayList<PathSegment>(this.points.size());
        GeoPoint lastPoint = null;
        for (GeoPoint end : this.points) {
            if (lastPoint != null) {
                Plane normalizedConnectingPlane = new Plane((Vector)lastPoint, end);
                this.segments.add(new PathSegment(this.planetModel, lastPoint, end, normalizedConnectingPlane));
            }
            lastPoint = end;
        }
        if (this.segments.size() == 0) {
            GeoPoint point = this.points.get(0);
            SegmentEndpoint onlyEndpoint = new SegmentEndpoint(point);
            this.endPoints.add(onlyEndpoint);
            this.edgePoints = new GeoPoint[]{point};
            return;
        }
        for (int i = 0; i < this.segments.size(); ++i) {
            PathSegment currentSegment = this.segments.get(i);
            if (i == 0) {
                SegmentEndpoint startEndpoint = new SegmentEndpoint(currentSegment.start, currentSegment.startCutoffPlane);
                this.endPoints.add(startEndpoint);
                this.edgePoints = new GeoPoint[]{currentSegment.start};
                continue;
            }
            this.endPoints.add(new SegmentEndpoint(currentSegment.start, this.segments.get((int)(i - 1)).endCutoffPlane, currentSegment.startCutoffPlane));
        }
        PathSegment lastSegment = this.segments.get(this.segments.size() - 1);
        this.endPoints.add(new SegmentEndpoint(lastSegment.end, lastSegment.endCutoffPlane));
    }

    public GeoDegeneratePath(PlanetModel planetModel, InputStream inputStream) throws IOException {
        this(planetModel, SerializableObject.readPointArray(planetModel, inputStream));
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        SerializableObject.writePointArray(outputStream, this.points);
    }

    @Override
    public double computePathCenterDistance(DistanceStyle distanceStyle, double x, double y, double z) {
        double closestDistance = Double.POSITIVE_INFINITY;
        for (PathSegment segment : this.segments) {
            double segmentDistance = segment.pathCenterDistance(this.planetModel, distanceStyle, x, y, z);
            if (!(segmentDistance < closestDistance)) continue;
            closestDistance = segmentDistance;
        }
        for (SegmentEndpoint endpoint : this.endPoints) {
            double endpointDistance = endpoint.pathCenterDistance(distanceStyle, x, y, z);
            if (!(endpointDistance < closestDistance)) continue;
            closestDistance = endpointDistance;
        }
        return closestDistance;
    }

    @Override
    public double computeNearestDistance(DistanceStyle distanceStyle, double x, double y, double z) {
        double currentDistance = 0.0;
        double minPathCenterDistance = Double.POSITIVE_INFINITY;
        double bestDistance = Double.POSITIVE_INFINITY;
        int segmentIndex = 0;
        for (SegmentEndpoint endpoint : this.endPoints) {
            double endpointPathCenterDistance = endpoint.pathCenterDistance(distanceStyle, x, y, z);
            if (endpointPathCenterDistance < minPathCenterDistance) {
                minPathCenterDistance = endpointPathCenterDistance;
                bestDistance = currentDistance;
            }
            if (segmentIndex >= this.segments.size()) continue;
            int n = segmentIndex++;
            PathSegment segment = this.segments.get(n);
            double segmentPathCenterDistance = segment.pathCenterDistance(this.planetModel, distanceStyle, x, y, z);
            if (segmentPathCenterDistance < minPathCenterDistance) {
                minPathCenterDistance = segmentPathCenterDistance;
                bestDistance = distanceStyle.aggregateDistances(currentDistance, segment.nearestPathDistance(this.planetModel, distanceStyle, x, y, z));
            }
            currentDistance = distanceStyle.aggregateDistances(currentDistance, segment.fullPathDistance(distanceStyle));
        }
        return bestDistance;
    }

    @Override
    protected double distance(DistanceStyle distanceStyle, double x, double y, double z) {
        double currentDistance = 0.0;
        for (PathSegment segment : this.segments) {
            double distance = segment.pathDistance(this.planetModel, distanceStyle, x, y, z);
            if (distance != Double.POSITIVE_INFINITY) {
                return distanceStyle.fromAggregationForm(distanceStyle.aggregateDistances(currentDistance, distance));
            }
            currentDistance = distanceStyle.aggregateDistances(currentDistance, segment.fullPathDistance(distanceStyle));
        }
        int segmentIndex = 0;
        currentDistance = 0.0;
        for (SegmentEndpoint endpoint : this.endPoints) {
            double distance = endpoint.pathDistance(distanceStyle, x, y, z);
            if (distance != Double.POSITIVE_INFINITY) {
                return distanceStyle.fromAggregationForm(distanceStyle.aggregateDistances(currentDistance, distance));
            }
            if (segmentIndex >= this.segments.size()) continue;
            currentDistance = distanceStyle.aggregateDistances(currentDistance, this.segments.get(segmentIndex++).fullPathDistance(distanceStyle));
        }
        return Double.POSITIVE_INFINITY;
    }

    @Override
    protected double deltaDistance(DistanceStyle distanceStyle, double x, double y, double z) {
        return 0.0;
    }

    @Override
    protected void distanceBounds(Bounds bounds, DistanceStyle distanceStyle, double distanceValue) {
        this.getBounds(bounds);
    }

    @Override
    protected double outsideDistance(DistanceStyle distanceStyle, double x, double y, double z) {
        double newDistance;
        double minDistance = Double.POSITIVE_INFINITY;
        for (SegmentEndpoint endpoint : this.endPoints) {
            newDistance = endpoint.outsideDistance(distanceStyle, x, y, z);
            if (!(newDistance < minDistance)) continue;
            minDistance = newDistance;
        }
        for (PathSegment segment : this.segments) {
            newDistance = segment.outsideDistance(this.planetModel, distanceStyle, x, y, z);
            if (!(newDistance < minDistance)) continue;
            minDistance = newDistance;
        }
        return minDistance;
    }

    @Override
    public boolean isWithin(double x, double y, double z) {
        for (SegmentEndpoint pathPoint : this.endPoints) {
            if (!pathPoint.isWithin(x, y, z)) continue;
            return true;
        }
        for (PathSegment pathSegment : this.segments) {
            if (!pathSegment.isWithin(x, y, z)) continue;
            return true;
        }
        return false;
    }

    @Override
    public GeoPoint[] getEdgePoints() {
        return this.edgePoints;
    }

    @Override
    public boolean intersects(Plane plane, GeoPoint[] notablePoints, Membership ... bounds) {
        if (this.endPoints.size() == 1) {
            return this.endPoints.get(0).intersects(this.planetModel, plane, notablePoints, bounds);
        }
        for (PathSegment pathSegment : this.segments) {
            if (!pathSegment.intersects(this.planetModel, plane, notablePoints, bounds)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean intersects(GeoShape geoShape) {
        if (this.endPoints.size() == 1) {
            return this.endPoints.get(0).intersects(geoShape);
        }
        for (PathSegment pathSegment : this.segments) {
            if (!pathSegment.intersects(geoShape)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void getBounds(Bounds bounds) {
        super.getBounds(bounds);
        for (PathSegment pathSegment : this.segments) {
            pathSegment.getBounds(this.planetModel, bounds);
        }
        if (this.endPoints.size() == 1) {
            this.endPoints.get(0).getBounds(this.planetModel, bounds);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof GeoDegeneratePath)) {
            return false;
        }
        GeoDegeneratePath p = (GeoDegeneratePath)o;
        if (!super.equals(p)) {
            return false;
        }
        return this.points.equals(p.points);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.points.hashCode();
        return result;
    }

    public String toString() {
        return "GeoDegeneratePath: {planetmodel=" + this.planetModel + ", points={" + this.points + "}}";
    }

    private static class PathSegment {
        public final GeoPoint start;
        public final GeoPoint end;
        public final Map<DistanceStyle, Double> fullDistanceCache = new HashMap<DistanceStyle, Double>();
        public final Plane normalizedConnectingPlane;
        public final SidedPlane startCutoffPlane;
        public final SidedPlane endCutoffPlane;
        public final GeoPoint[] connectingPlanePoints;

        public PathSegment(PlanetModel planetModel, GeoPoint start, GeoPoint end, Plane normalizedConnectingPlane) {
            this.start = start;
            this.end = end;
            this.normalizedConnectingPlane = normalizedConnectingPlane;
            this.startCutoffPlane = new SidedPlane((Vector)end, (Vector)normalizedConnectingPlane, start);
            this.endCutoffPlane = new SidedPlane((Vector)start, (Vector)normalizedConnectingPlane, end);
            this.connectingPlanePoints = new GeoPoint[]{start, end};
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public double fullPathDistance(DistanceStyle distanceStyle) {
            Map<DistanceStyle, Double> map = this.fullDistanceCache;
            synchronized (map) {
                Double dist = this.fullDistanceCache.get(distanceStyle);
                if (dist == null) {
                    dist = distanceStyle.toAggregationForm(distanceStyle.computeDistance(this.start, this.end.x, this.end.y, this.end.z));
                    this.fullDistanceCache.put(distanceStyle, dist);
                }
                return dist;
            }
        }

        public boolean isWithin(double x, double y, double z) {
            return this.startCutoffPlane.isWithin(x, y, z) && this.endCutoffPlane.isWithin(x, y, z) && this.normalizedConnectingPlane.evaluateIsZero(x, y, z);
        }

        public double pathCenterDistance(PlanetModel planetModel, DistanceStyle distanceStyle, double x, double y, double z) {
            GeoPoint thePoint;
            if (!this.startCutoffPlane.isWithin(x, y, z) || !this.endCutoffPlane.isWithin(x, y, z)) {
                return Double.POSITIVE_INFINITY;
            }
            double perpX = this.normalizedConnectingPlane.y * z - this.normalizedConnectingPlane.z * y;
            double perpY = this.normalizedConnectingPlane.z * x - this.normalizedConnectingPlane.x * z;
            double perpZ = this.normalizedConnectingPlane.x * y - this.normalizedConnectingPlane.y * x;
            double magnitude = Math.sqrt(perpX * perpX + perpY * perpY + perpZ * perpZ);
            if (Math.abs(magnitude) < 1.0E-12) {
                return distanceStyle.computeDistance(this.start, x, y, z);
            }
            double normFactor = 1.0 / magnitude;
            Plane normalizedPerpPlane = new Plane(perpX * normFactor, perpY * normFactor, perpZ * normFactor, 0.0);
            GeoPoint[] intersectionPoints = this.normalizedConnectingPlane.findIntersections(planetModel, normalizedPerpPlane, new Membership[0]);
            if (intersectionPoints.length == 0) {
                throw new RuntimeException("Can't find world intersection for point x=" + x + " y=" + y + " z=" + z);
            }
            if (intersectionPoints.length == 1) {
                thePoint = intersectionPoints[0];
            } else if (this.startCutoffPlane.isWithin(intersectionPoints[0]) && this.endCutoffPlane.isWithin(intersectionPoints[0])) {
                thePoint = intersectionPoints[0];
            } else if (this.startCutoffPlane.isWithin(intersectionPoints[1]) && this.endCutoffPlane.isWithin(intersectionPoints[1])) {
                thePoint = intersectionPoints[1];
            } else {
                throw new RuntimeException("Can't find world intersection for point x=" + x + " y=" + y + " z=" + z);
            }
            return distanceStyle.computeDistance(thePoint, x, y, z);
        }

        public double nearestPathDistance(PlanetModel planetModel, DistanceStyle distanceStyle, double x, double y, double z) {
            GeoPoint thePoint;
            if (!this.startCutoffPlane.isWithin(x, y, z) || !this.endCutoffPlane.isWithin(x, y, z)) {
                return Double.POSITIVE_INFINITY;
            }
            double perpX = this.normalizedConnectingPlane.y * z - this.normalizedConnectingPlane.z * y;
            double perpY = this.normalizedConnectingPlane.z * x - this.normalizedConnectingPlane.x * z;
            double perpZ = this.normalizedConnectingPlane.x * y - this.normalizedConnectingPlane.y * x;
            double magnitude = Math.sqrt(perpX * perpX + perpY * perpY + perpZ * perpZ);
            if (Math.abs(magnitude) < 1.0E-12) {
                return distanceStyle.toAggregationForm(0.0);
            }
            double normFactor = 1.0 / magnitude;
            Plane normalizedPerpPlane = new Plane(perpX * normFactor, perpY * normFactor, perpZ * normFactor, 0.0);
            GeoPoint[] intersectionPoints = this.normalizedConnectingPlane.findIntersections(planetModel, normalizedPerpPlane, new Membership[0]);
            if (intersectionPoints.length == 0) {
                throw new RuntimeException("Can't find world intersection for point x=" + x + " y=" + y + " z=" + z);
            }
            if (intersectionPoints.length == 1) {
                thePoint = intersectionPoints[0];
            } else if (this.startCutoffPlane.isWithin(intersectionPoints[0]) && this.endCutoffPlane.isWithin(intersectionPoints[0])) {
                thePoint = intersectionPoints[0];
            } else if (this.startCutoffPlane.isWithin(intersectionPoints[1]) && this.endCutoffPlane.isWithin(intersectionPoints[1])) {
                thePoint = intersectionPoints[1];
            } else {
                throw new RuntimeException("Can't find world intersection for point x=" + x + " y=" + y + " z=" + z);
            }
            return distanceStyle.toAggregationForm(distanceStyle.computeDistance(this.start, thePoint.x, thePoint.y, thePoint.z));
        }

        public double pathDistance(PlanetModel planetModel, DistanceStyle distanceStyle, double x, double y, double z) {
            GeoPoint thePoint;
            if (!this.isWithin(x, y, z)) {
                return Double.POSITIVE_INFINITY;
            }
            double perpX = this.normalizedConnectingPlane.y * z - this.normalizedConnectingPlane.z * y;
            double perpY = this.normalizedConnectingPlane.z * x - this.normalizedConnectingPlane.x * z;
            double perpZ = this.normalizedConnectingPlane.x * y - this.normalizedConnectingPlane.y * x;
            double magnitude = Math.sqrt(perpX * perpX + perpY * perpY + perpZ * perpZ);
            if (Math.abs(magnitude) < 1.0E-12) {
                return distanceStyle.toAggregationForm(distanceStyle.computeDistance(this.start, x, y, z));
            }
            double normFactor = 1.0 / magnitude;
            Plane normalizedPerpPlane = new Plane(perpX * normFactor, perpY * normFactor, perpZ * normFactor, 0.0);
            GeoPoint[] intersectionPoints = this.normalizedConnectingPlane.findIntersections(planetModel, normalizedPerpPlane, new Membership[0]);
            if (intersectionPoints.length == 0) {
                throw new RuntimeException("Can't find world intersection for point x=" + x + " y=" + y + " z=" + z);
            }
            if (intersectionPoints.length == 1) {
                thePoint = intersectionPoints[0];
            } else if (this.startCutoffPlane.isWithin(intersectionPoints[0]) && this.endCutoffPlane.isWithin(intersectionPoints[0])) {
                thePoint = intersectionPoints[0];
            } else if (this.startCutoffPlane.isWithin(intersectionPoints[1]) && this.endCutoffPlane.isWithin(intersectionPoints[1])) {
                thePoint = intersectionPoints[1];
            } else {
                throw new RuntimeException("Can't find world intersection for point x=" + x + " y=" + y + " z=" + z);
            }
            return distanceStyle.aggregateDistances(distanceStyle.toAggregationForm(distanceStyle.computeDistance(thePoint, x, y, z)), distanceStyle.toAggregationForm(distanceStyle.computeDistance(this.start, thePoint.x, thePoint.y, thePoint.z)));
        }

        public double outsideDistance(PlanetModel planetModel, DistanceStyle distanceStyle, double x, double y, double z) {
            double distance = distanceStyle.computeDistance(planetModel, this.normalizedConnectingPlane, x, y, z, this.startCutoffPlane, this.endCutoffPlane);
            double startDistance = distanceStyle.computeDistance(this.start, x, y, z);
            double endDistance = distanceStyle.computeDistance(this.end, x, y, z);
            return Math.min(Math.min(startDistance, endDistance), distance);
        }

        public boolean intersects(PlanetModel planetModel, Plane p, GeoPoint[] notablePoints, Membership[] bounds) {
            return this.normalizedConnectingPlane.intersects(planetModel, p, this.connectingPlanePoints, notablePoints, bounds, this.startCutoffPlane, this.endCutoffPlane);
        }

        public boolean intersects(GeoShape geoShape) {
            return geoShape.intersects(this.normalizedConnectingPlane, this.connectingPlanePoints, this.startCutoffPlane, this.endCutoffPlane);
        }

        public void getBounds(PlanetModel planetModel, Bounds bounds) {
            bounds.addPoint(this.start).addPoint(this.end).addPlane(planetModel, this.normalizedConnectingPlane, this.startCutoffPlane, this.endCutoffPlane);
        }
    }

    private static class SegmentEndpoint {
        public final GeoPoint point;
        public final Membership[] cutoffPlanes;
        public static final Membership[] NO_MEMBERSHIP = new Membership[0];

        public SegmentEndpoint(GeoPoint point) {
            this.point = point;
            this.cutoffPlanes = NO_MEMBERSHIP;
        }

        public SegmentEndpoint(GeoPoint point, SidedPlane cutoffPlane) {
            this.point = point;
            this.cutoffPlanes = new Membership[]{new SidedPlane(cutoffPlane)};
        }

        public SegmentEndpoint(GeoPoint point, SidedPlane cutoffPlane1, SidedPlane cutoffPlane2) {
            this.point = point;
            this.cutoffPlanes = new Membership[]{new SidedPlane(cutoffPlane1), new SidedPlane(cutoffPlane2)};
        }

        public boolean isWithin(double x, double y, double z) {
            return this.point.isIdentical(x, y, z);
        }

        public double pathDistance(DistanceStyle distanceStyle, double x, double y, double z) {
            if (!this.isWithin(x, y, z)) {
                return Double.POSITIVE_INFINITY;
            }
            return distanceStyle.toAggregationForm(distanceStyle.computeDistance(this.point, x, y, z));
        }

        public double pathCenterDistance(DistanceStyle distanceStyle, double x, double y, double z) {
            for (Membership m : this.cutoffPlanes) {
                if (m.isWithin(x, y, z)) continue;
                return Double.POSITIVE_INFINITY;
            }
            return distanceStyle.computeDistance(this.point, x, y, z);
        }

        public double outsideDistance(DistanceStyle distanceStyle, double x, double y, double z) {
            return distanceStyle.computeDistance(this.point, x, y, z);
        }

        public boolean intersects(PlanetModel planetModel, Plane p, GeoPoint[] notablePoints, Membership[] bounds) {
            if (!p.evaluateIsZero(this.point)) {
                return false;
            }
            for (Membership m : bounds) {
                if (m.isWithin(this.point)) continue;
                return false;
            }
            return true;
        }

        public boolean intersects(GeoShape geoShape) {
            return geoShape.isWithin(this.point);
        }

        public void getBounds(PlanetModel planetModel, Bounds bounds) {
            bounds.addPoint(this.point);
        }

        public boolean equals(Object o) {
            if (!(o instanceof SegmentEndpoint)) {
                return false;
            }
            SegmentEndpoint other = (SegmentEndpoint)o;
            return this.point.equals(other.point);
        }

        public int hashCode() {
            return this.point.hashCode();
        }

        public String toString() {
            return this.point.toString();
        }
    }
}

