/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.spatial.util;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.DoubleValues;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.DoubleValuesSource;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.Explanation;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.IndexSearcher;

public class CachingDoubleValueSource
extends DoubleValuesSource {
    final DoubleValuesSource source;
    final Map<Integer, Double> cache;

    public CachingDoubleValueSource(DoubleValuesSource source) {
        this.source = source;
        this.cache = new HashMap<Integer, Double>();
    }

    @Override
    public String toString() {
        return "Cached[" + this.source.toString() + "]";
    }

    @Override
    public DoubleValues getValues(LeafReaderContext readerContext, DoubleValues scores) throws IOException {
        final int base = readerContext.docBase;
        final DoubleValues vals = this.source.getValues(readerContext, scores);
        return new DoubleValues(){
            int doc = -1;

            @Override
            public double doubleValue() throws IOException {
                int key = base + this.doc;
                Double v = CachingDoubleValueSource.this.cache.get(key);
                if (v == null) {
                    v = vals.doubleValue();
                    CachingDoubleValueSource.this.cache.put(key, v);
                }
                return v;
            }

            @Override
            public boolean advanceExact(int doc) throws IOException {
                this.doc = doc;
                return vals.advanceExact(doc);
            }
        };
    }

    @Override
    public boolean needsScores() {
        return false;
    }

    @Override
    public boolean isCacheable(LeafReaderContext ctx) {
        return this.source.isCacheable(ctx);
    }

    @Override
    public Explanation explain(LeafReaderContext ctx, int docId, Explanation scoreExplanation) throws IOException {
        return this.source.explain(ctx, docId, scoreExplanation);
    }

    @Override
    public DoubleValuesSource rewrite(IndexSearcher searcher) throws IOException {
        return new CachingDoubleValueSource(this.source.rewrite(searcher));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CachingDoubleValueSource that = (CachingDoubleValueSource)o;
        return !(this.source != null ? !this.source.equals(that.source) : that.source != null);
    }

    @Override
    public int hashCode() {
        return this.source != null ? this.source.hashCode() : 0;
    }
}

