/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.spatial.prefix.tree;

import org.graylog.shaded.opensearch2.org.apache.lucene.spatial.prefix.tree.Cell;
import org.graylog.shaded.opensearch2.org.apache.lucene.spatial.prefix.tree.CellIterator;
import org.locationtech.spatial4j.shape.Point;
import org.locationtech.spatial4j.shape.Shape;

class TreeCellIterator
extends CellIterator {
    private final Shape shapeFilter;
    private final CellIterator[] iterStack;
    private int stackIdx;
    private boolean descend;

    public TreeCellIterator(Shape shapeFilter, int detailLevel, Cell parentCell) {
        this.shapeFilter = shapeFilter;
        assert (parentCell.getLevel() == 0);
        this.iterStack = new CellIterator[detailLevel];
        this.iterStack[0] = parentCell.getNextLevelCells(shapeFilter);
        this.stackIdx = 0;
        this.descend = false;
    }

    @Override
    public boolean hasNext() {
        if (this.nextCell != null) {
            return true;
        }
        while (true) {
            if (this.stackIdx == -1) {
                return false;
            }
            if (this.descend && this.stackIdx != this.iterStack.length - 1 && !this.iterStack[this.stackIdx].thisCell().isLeaf()) {
                CellIterator nextIter = this.iterStack[this.stackIdx].thisCell().getNextLevelCells(this.shapeFilter);
                this.iterStack[++this.stackIdx] = nextIter;
            }
            if (this.iterStack[this.stackIdx].hasNext()) {
                this.nextCell = this.iterStack[this.stackIdx].next();
                if (this.stackIdx != this.iterStack.length - 1 || this.shapeFilter instanceof Point) break;
                this.nextCell.setLeaf();
                break;
            }
            this.iterStack[this.stackIdx--] = null;
            this.descend = false;
        }
        assert (this.nextCell != null);
        this.descend = true;
        return true;
    }

    @Override
    public void remove() {
        assert (this.thisCell() != null && this.nextCell == null);
        this.descend = false;
    }
}

