/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.search.spell;

import java.io.IOException;
import java.util.Comparator;
import java.util.PriorityQueue;
import java.util.Queue;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.IndexReader;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.Term;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.spell.CombineSuggestion;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.spell.SuggestMode;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.spell.SuggestWord;

public class WordBreakSpellChecker {
    private int minSuggestionFrequency = 1;
    private int minBreakWordLength = 1;
    private int maxCombineWordLength = 20;
    private int maxChanges = 1;
    private int maxEvaluations = 1000;
    public static final Term SEPARATOR_TERM = new Term("", "");

    public SuggestWord[][] suggestWordBreaks(Term term, int maxSuggestions, IndexReader ir, SuggestMode suggestMode, BreakSuggestionSortMethod sortMethod) throws IOException {
        if (maxSuggestions < 1) {
            return new SuggestWord[0][0];
        }
        if (suggestMode == null) {
            suggestMode = SuggestMode.SUGGEST_WHEN_NOT_IN_INDEX;
        }
        if (sortMethod == null) {
            sortMethod = BreakSuggestionSortMethod.NUM_CHANGES_THEN_MAX_FREQUENCY;
        }
        int queueInitialCapacity = maxSuggestions > 10 ? 10 : maxSuggestions;
        Comparator<SuggestWordArrayWrapper> queueComparator = sortMethod == BreakSuggestionSortMethod.NUM_CHANGES_THEN_MAX_FREQUENCY ? new LengthThenMaxFreqComparator() : new LengthThenSumFreqComparator();
        PriorityQueue<SuggestWordArrayWrapper> suggestions = new PriorityQueue<SuggestWordArrayWrapper>(queueInitialCapacity, queueComparator);
        int origFreq = ir.docFreq(term);
        if (origFreq > 0 && suggestMode == SuggestMode.SUGGEST_WHEN_NOT_IN_INDEX) {
            return new SuggestWord[0][];
        }
        int useMinSuggestionFrequency = this.minSuggestionFrequency;
        if (suggestMode == SuggestMode.SUGGEST_MORE_POPULAR) {
            useMinSuggestionFrequency = origFreq == 0 ? 1 : origFreq;
        }
        this.generateBreakUpSuggestions(term, ir, 1, maxSuggestions, useMinSuggestionFrequency, new SuggestWord[0], suggestions, 0, sortMethod);
        SuggestWord[][] suggestionArray = new SuggestWord[suggestions.size()][];
        for (int i = suggestions.size() - 1; i >= 0; --i) {
            suggestionArray[i] = ((SuggestWordArrayWrapper)suggestions.remove()).suggestWords;
        }
        return suggestionArray;
    }

    public CombineSuggestion[] suggestWordCombinations(Term[] terms, int maxSuggestions, IndexReader ir, SuggestMode suggestMode) throws IOException {
        if (maxSuggestions < 1) {
            return new CombineSuggestion[0];
        }
        int[] origFreqs = null;
        if (suggestMode != SuggestMode.SUGGEST_ALWAYS) {
            origFreqs = new int[terms.length];
            for (int i = 0; i < terms.length; ++i) {
                origFreqs[i] = ir.docFreq(terms[i]);
            }
        }
        int queueInitialCapacity = maxSuggestions > 10 ? 10 : maxSuggestions;
        CombinationsThenFreqComparator queueComparator = new CombinationsThenFreqComparator();
        PriorityQueue<CombineSuggestionWrapper> suggestions = new PriorityQueue<CombineSuggestionWrapper>(queueInitialCapacity, queueComparator);
        int thisTimeEvaluations = 0;
        block1: for (int i = 0; i < terms.length - 1; ++i) {
            String leftTermText;
            int leftTermLength;
            if (terms[i].equals(SEPARATOR_TERM) || (leftTermLength = (leftTermText = terms[i].text()).codePointCount(0, leftTermText.length())) > this.maxCombineWordLength) continue;
            int maxFreq = 0;
            int minFreq = Integer.MAX_VALUE;
            if (origFreqs != null) {
                maxFreq = origFreqs[i];
                minFreq = origFreqs[i];
            }
            Object combinedTermText = leftTermText;
            int combinedLength = leftTermLength;
            for (int j = i + 1; j < terms.length && j - i <= this.maxChanges && !terms[j].equals(SEPARATOR_TERM); ++j) {
                String rightTermText = terms[j].text();
                int rightTermLength = rightTermText.codePointCount(0, rightTermText.length());
                combinedTermText = (String)combinedTermText + rightTermText;
                if ((combinedLength += rightTermLength) > this.maxCombineWordLength) continue block1;
                if (origFreqs != null) {
                    maxFreq = Math.max(maxFreq, origFreqs[j]);
                    minFreq = Math.min(minFreq, origFreqs[j]);
                }
                Term combinedTerm = new Term(terms[0].field(), (String)combinedTermText);
                int combinedTermFreq = ir.docFreq(combinedTerm);
                if (!(suggestMode == SuggestMode.SUGGEST_MORE_POPULAR && combinedTermFreq < maxFreq || suggestMode == SuggestMode.SUGGEST_WHEN_NOT_IN_INDEX && minFreq != 0 || combinedTermFreq < this.minSuggestionFrequency)) {
                    int[] origIndexes = new int[j - i + 1];
                    origIndexes[0] = i;
                    for (int k = 1; k < origIndexes.length; ++k) {
                        origIndexes[k] = i + k;
                    }
                    SuggestWord word = new SuggestWord();
                    word.freq = combinedTermFreq;
                    word.score = origIndexes.length - 1;
                    word.string = combinedTerm.text();
                    CombineSuggestionWrapper suggestion = new CombineSuggestionWrapper(new CombineSuggestion(word, origIndexes), origIndexes.length - 1);
                    suggestions.offer(suggestion);
                    if (suggestions.size() > maxSuggestions) {
                        suggestions.poll();
                    }
                }
                if (++thisTimeEvaluations == this.maxEvaluations) continue block1;
            }
        }
        CombineSuggestion[] combineSuggestions = new CombineSuggestion[suggestions.size()];
        for (int i = suggestions.size() - 1; i >= 0; --i) {
            combineSuggestions[i] = ((CombineSuggestionWrapper)suggestions.remove()).combineSuggestion;
        }
        return combineSuggestions;
    }

    private int generateBreakUpSuggestions(Term term, IndexReader ir, int numberBreaks, int maxSuggestions, int useMinSuggestionFrequency, SuggestWord[] prefix, Queue<SuggestWordArrayWrapper> suggestions, int totalEvaluations, BreakSuggestionSortMethod sortMethod) throws IOException {
        String termText = term.text();
        int termLength = termText.codePointCount(0, termText.length());
        int useMinBreakWordLength = this.minBreakWordLength;
        if (useMinBreakWordLength < 1) {
            useMinBreakWordLength = 1;
        }
        if (termLength < useMinBreakWordLength * 2) {
            return 0;
        }
        int thisTimeEvaluations = 0;
        for (int i = useMinBreakWordLength; i <= termLength - useMinBreakWordLength; ++i) {
            int end = termText.offsetByCodePoints(0, i);
            String leftText = termText.substring(0, end);
            String rightText = termText.substring(end);
            SuggestWord leftWord = this.generateSuggestWord(ir, term.field(), leftText);
            if (leftWord.freq >= useMinSuggestionFrequency) {
                int newNumberBreaks;
                SuggestWord rightWord = this.generateSuggestWord(ir, term.field(), rightText);
                if (rightWord.freq >= useMinSuggestionFrequency) {
                    SuggestWordArrayWrapper suggestion = new SuggestWordArrayWrapper(this.newSuggestion(prefix, leftWord, rightWord));
                    suggestions.offer(suggestion);
                    if (suggestions.size() > maxSuggestions) {
                        suggestions.poll();
                    }
                }
                if ((newNumberBreaks = numberBreaks + 1) <= this.maxChanges) {
                    int evaluations = this.generateBreakUpSuggestions(new Term(term.field(), rightWord.string), ir, newNumberBreaks, maxSuggestions, useMinSuggestionFrequency, this.newPrefix(prefix, leftWord), suggestions, totalEvaluations, sortMethod);
                    totalEvaluations += evaluations;
                }
            }
            ++thisTimeEvaluations;
            if (++totalEvaluations >= this.maxEvaluations) break;
        }
        return thisTimeEvaluations;
    }

    private SuggestWord[] newPrefix(SuggestWord[] oldPrefix, SuggestWord append) {
        SuggestWord[] newPrefix = new SuggestWord[oldPrefix.length + 1];
        System.arraycopy(oldPrefix, 0, newPrefix, 0, oldPrefix.length);
        newPrefix[newPrefix.length - 1] = append;
        return newPrefix;
    }

    private SuggestWord[] newSuggestion(SuggestWord[] prefix, SuggestWord append1, SuggestWord append2) {
        SuggestWord[] newSuggestion = new SuggestWord[prefix.length + 2];
        int score = prefix.length + 1;
        for (int i = 0; i < prefix.length; ++i) {
            SuggestWord word = new SuggestWord();
            word.string = prefix[i].string;
            word.freq = prefix[i].freq;
            word.score = score;
            newSuggestion[i] = word;
        }
        append1.score = score;
        append2.score = score;
        newSuggestion[newSuggestion.length - 2] = append1;
        newSuggestion[newSuggestion.length - 1] = append2;
        return newSuggestion;
    }

    private SuggestWord generateSuggestWord(IndexReader ir, String fieldname, String text) throws IOException {
        Term term = new Term(fieldname, text);
        int freq = ir.docFreq(term);
        SuggestWord word = new SuggestWord();
        word.freq = freq;
        word.score = 1.0f;
        word.string = text;
        return word;
    }

    public int getMinSuggestionFrequency() {
        return this.minSuggestionFrequency;
    }

    public int getMaxCombineWordLength() {
        return this.maxCombineWordLength;
    }

    public int getMinBreakWordLength() {
        return this.minBreakWordLength;
    }

    public int getMaxChanges() {
        return this.maxChanges;
    }

    public int getMaxEvaluations() {
        return this.maxEvaluations;
    }

    public void setMinSuggestionFrequency(int minSuggestionFrequency) {
        this.minSuggestionFrequency = minSuggestionFrequency;
    }

    public void setMaxCombineWordLength(int maxCombineWordLength) {
        this.maxCombineWordLength = maxCombineWordLength;
    }

    public void setMinBreakWordLength(int minBreakWordLength) {
        this.minBreakWordLength = minBreakWordLength;
    }

    public void setMaxChanges(int maxChanges) {
        this.maxChanges = maxChanges;
    }

    public void setMaxEvaluations(int maxEvaluations) {
        this.maxEvaluations = maxEvaluations;
    }

    private static class CombineSuggestionWrapper {
        final CombineSuggestion combineSuggestion;
        final int numCombinations;

        CombineSuggestionWrapper(CombineSuggestion combineSuggestion, int numCombinations) {
            this.combineSuggestion = combineSuggestion;
            this.numCombinations = numCombinations;
        }
    }

    private static class SuggestWordArrayWrapper {
        final SuggestWord[] suggestWords;
        final int freqMax;
        final int freqSum;

        SuggestWordArrayWrapper(SuggestWord[] suggestWords) {
            this.suggestWords = suggestWords;
            int aFreqSum = 0;
            int aFreqMax = 0;
            for (SuggestWord sw : suggestWords) {
                aFreqSum += sw.freq;
                aFreqMax = Math.max(aFreqMax, sw.freq);
            }
            this.freqSum = aFreqSum;
            this.freqMax = aFreqMax;
        }
    }

    private static class CombinationsThenFreqComparator
    implements Comparator<CombineSuggestionWrapper> {
        private CombinationsThenFreqComparator() {
        }

        @Override
        public int compare(CombineSuggestionWrapper o1, CombineSuggestionWrapper o2) {
            if (o1.numCombinations != o2.numCombinations) {
                return o2.numCombinations - o1.numCombinations;
            }
            if (o1.combineSuggestion.suggestion.freq != o2.combineSuggestion.suggestion.freq) {
                return o1.combineSuggestion.suggestion.freq - o2.combineSuggestion.suggestion.freq;
            }
            return 0;
        }
    }

    private static class LengthThenSumFreqComparator
    implements Comparator<SuggestWordArrayWrapper> {
        private LengthThenSumFreqComparator() {
        }

        @Override
        public int compare(SuggestWordArrayWrapper o1, SuggestWordArrayWrapper o2) {
            if (o1.suggestWords.length != o2.suggestWords.length) {
                return o2.suggestWords.length - o1.suggestWords.length;
            }
            if (o1.freqSum != o2.freqSum) {
                return o1.freqSum - o2.freqSum;
            }
            return 0;
        }
    }

    private static class LengthThenMaxFreqComparator
    implements Comparator<SuggestWordArrayWrapper> {
        private LengthThenMaxFreqComparator() {
        }

        @Override
        public int compare(SuggestWordArrayWrapper o1, SuggestWordArrayWrapper o2) {
            if (o1.suggestWords.length != o2.suggestWords.length) {
                return o2.suggestWords.length - o1.suggestWords.length;
            }
            if (o1.freqMax != o2.freqMax) {
                return o1.freqMax - o2.freqMax;
            }
            return 0;
        }
    }

    public static enum BreakSuggestionSortMethod {
        NUM_CHANGES_THEN_SUMMED_FREQUENCY,
        NUM_CHANGES_THEN_MAX_FREQUENCY;

    }
}

