/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.search.join;

import java.io.IOException;
import java.util.Arrays;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.NumericDocValues;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.SortedDocValues;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.ConjunctionUtils;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.DocIdSetIterator;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.join.BlockJoinSelector;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.BitSet;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.BytesRef;

class ToParentDocValues
extends DocIdSetIterator {
    private final BitSet parents;
    private int docID = -1;
    private final Accumulator collector;
    boolean seen = false;
    private DocIdSetIterator childWithValues;

    private ToParentDocValues(DocIdSetIterator values, BitSet parents, DocIdSetIterator children, Accumulator collect) {
        this.parents = parents;
        this.childWithValues = ConjunctionUtils.intersectIterators(Arrays.asList(children, values));
        this.collector = collect;
    }

    @Override
    public int docID() {
        return this.docID;
    }

    @Override
    public int nextDoc() throws IOException {
        assert (this.docID != Integer.MAX_VALUE);
        assert (this.childWithValues.docID() != this.docID || this.docID == -1);
        if (this.childWithValues.docID() < this.docID || this.docID == -1) {
            this.childWithValues.nextDoc();
        }
        if (this.childWithValues.docID() == Integer.MAX_VALUE) {
            this.docID = Integer.MAX_VALUE;
            return this.docID;
        }
        assert (!this.parents.get(this.childWithValues.docID()));
        int nextParentDocID = this.parents.nextSetBit(this.childWithValues.docID());
        this.collector.reset();
        this.seen = true;
        while (true) {
            int childDocID = this.childWithValues.nextDoc();
            assert (childDocID != nextParentDocID);
            if (childDocID > nextParentDocID) break;
            this.collector.increment();
        }
        this.docID = nextParentDocID;
        return this.docID;
    }

    @Override
    public int advance(int target) throws IOException {
        if (target >= this.parents.length()) {
            this.docID = Integer.MAX_VALUE;
            return this.docID;
        }
        if (target == 0) {
            assert (this.docID() == -1);
            return this.nextDoc();
        }
        int prevParentDocID = this.parents.prevSetBit(target - 1);
        if (this.childWithValues.docID() <= prevParentDocID) {
            this.childWithValues.advance(prevParentDocID + 1);
        }
        return this.nextDoc();
    }

    public boolean advanceExact(int targetParentDocID) throws IOException {
        if (targetParentDocID < this.docID) {
            throw new IllegalArgumentException("target must be after the current document: current=" + this.docID + " target=" + targetParentDocID);
        }
        int previousDocId = this.docID;
        this.docID = targetParentDocID;
        if (targetParentDocID == previousDocId) {
            return this.seen;
        }
        this.docID = targetParentDocID;
        this.seen = false;
        if (!this.parents.get(targetParentDocID)) {
            return false;
        }
        int prevParentDocId = this.docID == 0 ? -1 : this.parents.prevSetBit(this.docID - 1);
        int childDoc = this.childWithValues.docID();
        if (childDoc <= prevParentDocId) {
            childDoc = this.childWithValues.advance(prevParentDocId + 1);
        }
        if (childDoc >= this.docID) {
            return false;
        }
        if (this.childWithValues.docID() < this.docID) {
            this.collector.reset();
            this.seen = true;
            this.childWithValues.nextDoc();
        }
        if (!this.seen) {
            return false;
        }
        int doc = this.childWithValues.docID();
        while (doc < this.docID) {
            this.collector.increment();
            doc = this.childWithValues.nextDoc();
        }
        return true;
    }

    @Override
    public long cost() {
        return 0L;
    }

    static NumericDocValues wrap(NumericDocValues values, BlockJoinSelector.Type selection, BitSet parents2, DocIdSetIterator children) {
        return new NumDV(values, selection, parents2, children);
    }

    static SortedDocValues wrap(SortedDocValues values, BlockJoinSelector.Type selection, BitSet parents2, DocIdSetIterator children) {
        return new SortedDVs(values, selection, parents2, children);
    }

    private static final class NumDV
    extends NumericDocValues
    implements Accumulator {
        private final NumericDocValues values;
        private long value;
        private final BlockJoinSelector.Type selection;
        private final ToParentDocValues iter;

        private NumDV(NumericDocValues values, BlockJoinSelector.Type selection, BitSet parents, DocIdSetIterator children) {
            this.values = values;
            this.selection = selection;
            this.iter = new ToParentDocValues(values, parents, children, this);
        }

        @Override
        public void reset() throws IOException {
            this.value = this.values.longValue();
        }

        @Override
        public void increment() throws IOException {
            switch (this.selection) {
                case MIN: {
                    this.value = Math.min(this.value, this.values.longValue());
                    break;
                }
                case MAX: {
                    this.value = Math.max(this.value, this.values.longValue());
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }

        @Override
        public int nextDoc() throws IOException {
            return this.iter.nextDoc();
        }

        @Override
        public int advance(int targetParentDocID) throws IOException {
            return this.iter.advance(targetParentDocID);
        }

        @Override
        public boolean advanceExact(int targetParentDocID) throws IOException {
            return this.iter.advanceExact(targetParentDocID);
        }

        @Override
        public long longValue() {
            return this.value;
        }

        @Override
        public int docID() {
            return this.iter.docID();
        }

        @Override
        public long cost() {
            return this.values.cost();
        }
    }

    private static final class SortedDVs
    extends SortedDocValues
    implements Accumulator {
        private final SortedDocValues values;
        private final BlockJoinSelector.Type selection;
        private int ord = -1;
        private final ToParentDocValues iter;

        private SortedDVs(SortedDocValues values, BlockJoinSelector.Type selection, BitSet parents, DocIdSetIterator children) {
            this.values = values;
            this.selection = selection;
            this.iter = new ToParentDocValues(values, parents, children, this);
        }

        @Override
        public int docID() {
            return this.iter.docID();
        }

        @Override
        public void reset() throws IOException {
            this.ord = this.values.ordValue();
        }

        @Override
        public void increment() throws IOException {
            if (this.selection == BlockJoinSelector.Type.MIN) {
                this.ord = Math.min(this.ord, this.values.ordValue());
            } else if (this.selection == BlockJoinSelector.Type.MAX) {
                this.ord = Math.max(this.ord, this.values.ordValue());
            } else {
                throw new AssertionError();
            }
        }

        @Override
        public int nextDoc() throws IOException {
            return this.iter.nextDoc();
        }

        @Override
        public int advance(int target) throws IOException {
            return this.iter.advance(target);
        }

        @Override
        public boolean advanceExact(int targetParentDocID) throws IOException {
            return this.iter.advanceExact(targetParentDocID);
        }

        @Override
        public int ordValue() {
            return this.ord;
        }

        @Override
        public BytesRef lookupOrd(int ord) throws IOException {
            return this.values.lookupOrd(ord);
        }

        @Override
        public int getValueCount() {
            return this.values.getValueCount();
        }

        @Override
        public long cost() {
            return this.values.cost();
        }
    }

    static interface Accumulator {
        public void reset() throws IOException;

        public void increment() throws IOException;
    }
}

