/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.search;

import java.io.IOException;
import java.util.Objects;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.VectorValues;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.ConstantScoreScorer;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.ConstantScoreWeight;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.IndexSearcher;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.Query;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.QueryVisitor;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.ScoreMode;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.Scorer;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.Weight;

public class KnnVectorFieldExistsQuery
extends Query {
    private final String field;

    public KnnVectorFieldExistsQuery(String field) {
        this.field = Objects.requireNonNull(field);
    }

    public String getField() {
        return this.field;
    }

    @Override
    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.field.equals(((KnnVectorFieldExistsQuery)other).field);
    }

    @Override
    public int hashCode() {
        return 31 * this.classHash() + this.field.hashCode();
    }

    @Override
    public String toString(String field) {
        return "KnnVectorFieldExistsQuery [field=" + this.field + "]";
    }

    @Override
    public void visit(QueryVisitor visitor) {
        if (visitor.acceptField(this.field)) {
            visitor.visitLeaf(this);
        }
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, final ScoreMode scoreMode, float boost) {
        return new ConstantScoreWeight(this, boost){

            @Override
            public Scorer scorer(LeafReaderContext context) throws IOException {
                VectorValues iterator = context.reader().getVectorValues(KnnVectorFieldExistsQuery.this.field);
                if (iterator == null) {
                    return null;
                }
                return new ConstantScoreScorer((Weight)this, this.score(), scoreMode, iterator);
            }

            @Override
            public boolean isCacheable(LeafReaderContext ctx) {
                return true;
            }
        };
    }
}

