/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.search;

import java.io.IOException;
import java.util.List;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.DisiPriorityQueue;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.DisiWrapper;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.DisjunctionDISIApproximation;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.DocIdSetIterator;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.IndriScorer;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.ScoreMode;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.Scorer;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.Weight;

public abstract class IndriDisjunctionScorer
extends IndriScorer {
    private final List<Scorer> subScorersList;
    private final DisiPriorityQueue subScorers;
    private final DocIdSetIterator approximation;

    protected IndriDisjunctionScorer(Weight weight, List<Scorer> subScorersList, ScoreMode scoreMode, float boost) {
        super(weight, boost);
        this.subScorersList = subScorersList;
        this.subScorers = new DisiPriorityQueue(subScorersList.size());
        for (Scorer scorer : subScorersList) {
            DisiWrapper w = new DisiWrapper(scorer);
            this.subScorers.add(w);
        }
        this.approximation = new DisjunctionDISIApproximation(this.subScorers);
    }

    @Override
    public DocIdSetIterator iterator() {
        return this.approximation;
    }

    @Override
    public float getMaxScore(int upTo) throws IOException {
        return 0.0f;
    }

    public List<Scorer> getSubMatches() throws IOException {
        return this.subScorersList;
    }

    abstract float score(List<Scorer> var1) throws IOException;

    public abstract float smoothingScore(List<Scorer> var1, int var2) throws IOException;

    @Override
    public float score() throws IOException {
        return this.score(this.getSubMatches());
    }

    @Override
    public float smoothingScore(int docId) throws IOException {
        return this.smoothingScore(this.getSubMatches(), docId);
    }

    @Override
    public int docID() {
        return this.subScorers.top().doc;
    }
}

