/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.sandbox.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.opensearch2.org.apache.lucene.sandbox.search.ProfilerCollectorResult;
import org.graylog.shaded.opensearch2.org.apache.lucene.sandbox.search.ProfilerCollectorWrapper;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.Collector;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.LeafCollector;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.ScoreMode;

public class ProfilerCollector
implements Collector {
    private final String collectorName;
    private final String reason;
    private final ProfilerCollectorWrapper collector;
    private final List<ProfilerCollector> children;

    public ProfilerCollector(Collector collector, String reason, List<ProfilerCollector> children) {
        this.collector = new ProfilerCollectorWrapper(collector);
        this.reason = reason;
        this.collectorName = this.deriveCollectorName(collector);
        this.children = children;
    }

    public long getTime() {
        return this.collector.getTime();
    }

    public String getReason() {
        return this.reason;
    }

    public String getName() {
        return this.collectorName;
    }

    private String deriveCollectorName(Collector c) {
        return c.getClass().getSimpleName();
    }

    @Override
    public LeafCollector getLeafCollector(LeafReaderContext context) throws IOException {
        return this.collector.getLeafCollector(context);
    }

    @Override
    public ScoreMode scoreMode() {
        return this.collector.scoreMode();
    }

    public ProfilerCollectorResult getProfileResult() {
        return ProfilerCollector.doGetCollectorTree(this);
    }

    private static ProfilerCollectorResult doGetCollectorTree(ProfilerCollector collector) {
        ArrayList<ProfilerCollectorResult> childResults = new ArrayList<ProfilerCollectorResult>(collector.children.size());
        for (ProfilerCollector child : collector.children) {
            ProfilerCollectorResult result = ProfilerCollector.doGetCollectorTree(child);
            childResults.add(result);
        }
        return new ProfilerCollectorResult(collector.getName(), collector.getReason(), collector.getTime(), childResults);
    }
}

