/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.misc.search;

import java.io.IOException;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.NumericDocValues;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.SortedDocValues;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.SortedNumericDocValues;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.SortedSetDocValues;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.ArrayUtil;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.BytesRef;

public abstract class DocValuesStats<T> {
    private int missing = 0;
    private int count = 0;
    protected final String field;
    protected T min;
    protected T max;

    protected DocValuesStats(String field, T initialMin, T initialMax) {
        this.field = field;
        this.min = initialMin;
        this.max = initialMax;
    }

    protected abstract void doAccumulate(int var1) throws IOException;

    protected abstract boolean init(LeafReaderContext var1) throws IOException;

    protected abstract boolean hasValue(int var1) throws IOException;

    final void accumulate(int doc) throws IOException {
        if (this.hasValue(doc)) {
            ++this.count;
            this.doAccumulate(this.count);
        } else {
            ++this.missing;
        }
    }

    final void addMissing() {
        ++this.missing;
    }

    public final String field() {
        return this.field;
    }

    public final int count() {
        return this.count;
    }

    public final int missing() {
        return this.missing;
    }

    public final T min() {
        return this.min;
    }

    public final T max() {
        return this.max;
    }

    private static BytesRef copyFrom(BytesRef src, BytesRef dest) {
        if (dest == null) {
            return BytesRef.deepCopyOf(src);
        }
        dest.bytes = ArrayUtil.grow(dest.bytes, src.length);
        System.arraycopy(src.bytes, src.offset, dest.bytes, 0, src.length);
        dest.offset = 0;
        dest.length = src.length;
        return dest;
    }

    public static class SortedSetDocValuesStats
    extends DocValuesStats<BytesRef> {
        protected SortedSetDocValues ssdv;

        protected SortedSetDocValuesStats(String field) {
            super(field, null, null);
        }

        @Override
        protected final boolean init(LeafReaderContext context) throws IOException {
            this.ssdv = context.reader().getSortedSetDocValues(this.field);
            return this.ssdv != null;
        }

        @Override
        protected final boolean hasValue(int doc) throws IOException {
            return this.ssdv.advanceExact(doc);
        }

        @Override
        protected void doAccumulate(int count) throws IOException {
            long ord;
            while ((ord = this.ssdv.nextOrd()) != -1L) {
                BytesRef val = this.ssdv.lookupOrd(ord);
                if (this.max == null || val.compareTo((BytesRef)this.max) > 0) {
                    this.max = DocValuesStats.copyFrom(val, (BytesRef)this.max);
                }
                if (this.min != null && val.compareTo((BytesRef)this.min) >= 0) continue;
                this.min = DocValuesStats.copyFrom(val, (BytesRef)this.min);
            }
        }
    }

    public static class SortedDocValuesStats
    extends DocValuesStats<BytesRef> {
        protected SortedDocValues sdv;

        protected SortedDocValuesStats(String field) {
            super(field, null, null);
        }

        @Override
        protected final boolean init(LeafReaderContext context) throws IOException {
            this.sdv = context.reader().getSortedDocValues(this.field);
            return this.sdv != null;
        }

        @Override
        protected final boolean hasValue(int doc) throws IOException {
            return this.sdv.advanceExact(doc);
        }

        @Override
        protected void doAccumulate(int count) throws IOException {
            BytesRef val = this.sdv.lookupOrd(this.sdv.ordValue());
            if (this.max == null || val.compareTo((BytesRef)this.max) > 0) {
                this.max = DocValuesStats.copyFrom(val, (BytesRef)this.max);
            }
            if (this.min == null || val.compareTo((BytesRef)this.min) < 0) {
                this.min = DocValuesStats.copyFrom(val, (BytesRef)this.min);
            }
        }
    }

    public static final class SortedDoubleDocValuesStats
    extends SortedNumericDocValuesStats<Double> {
        private double sum = 0.0;

        public SortedDoubleDocValuesStats(String field) {
            super(field, Double.MAX_VALUE, Double.MIN_VALUE);
        }

        @Override
        protected void doAccumulate(int count) throws IOException {
            int numValues = this.sndv.docValueCount();
            while (numValues-- > 0) {
                double val = Double.longBitsToDouble(this.sndv.nextValue());
                if (Double.compare(val, (Double)this.max) > 0) {
                    this.max = val;
                }
                if (Double.compare(val, (Double)this.min) < 0) {
                    this.min = val;
                }
                this.sum += val;
                double oldMean = this.mean;
                ++this.valuesCount;
                this.mean += (val - this.mean) / (double)this.valuesCount;
                this.variance += (val - this.mean) * (val - oldMean);
            }
        }

        @Override
        public Double sum() {
            return this.sum;
        }
    }

    public static final class SortedLongDocValuesStats
    extends SortedNumericDocValuesStats<Long> {
        private long sum = 0L;

        public SortedLongDocValuesStats(String field) {
            super(field, Long.MAX_VALUE, Long.MIN_VALUE);
        }

        @Override
        protected void doAccumulate(int count) throws IOException {
            int numValues = this.sndv.docValueCount();
            while (numValues-- > 0) {
                long val = this.sndv.nextValue();
                if (val > (Long)this.max) {
                    this.max = val;
                }
                if (val < (Long)this.min) {
                    this.min = val;
                }
                this.sum += val;
                double oldMean = this.mean;
                ++this.valuesCount;
                this.mean += ((double)val - this.mean) / (double)this.valuesCount;
                this.variance += ((double)val - this.mean) * ((double)val - oldMean);
            }
        }

        @Override
        public Long sum() {
            return this.sum;
        }
    }

    public static abstract class SortedNumericDocValuesStats<T extends Number>
    extends DocValuesStats<T> {
        protected long valuesCount = 0L;
        protected double mean = 0.0;
        protected double variance = 0.0;
        protected SortedNumericDocValues sndv;

        protected SortedNumericDocValuesStats(String field, T initialMin, T initialMax) {
            super(field, initialMin, initialMax);
        }

        @Override
        protected final boolean init(LeafReaderContext context) throws IOException {
            this.sndv = context.reader().getSortedNumericDocValues(this.field);
            return this.sndv != null;
        }

        @Override
        protected final boolean hasValue(int doc) throws IOException {
            return this.sndv.advanceExact(doc);
        }

        public final double mean() {
            return this.mean;
        }

        public final double variance() {
            int count = this.count();
            return count > 0 ? this.variance / (double)count : 0.0;
        }

        public final double stdev() {
            return Math.sqrt(this.variance());
        }

        public final long valuesCount() {
            return this.valuesCount;
        }

        public abstract T sum();
    }

    public static final class DoubleDocValuesStats
    extends NumericDocValuesStats<Double> {
        private double sum = 0.0;

        public DoubleDocValuesStats(String field) {
            super(field, Double.MAX_VALUE, Double.MIN_VALUE);
        }

        @Override
        protected void doAccumulate(int count) throws IOException {
            double val = Double.longBitsToDouble(this.ndv.longValue());
            if (Double.compare(val, (Double)this.max) > 0) {
                this.max = val;
            }
            if (Double.compare(val, (Double)this.min) < 0) {
                this.min = val;
            }
            this.sum += val;
            double oldMean = this.mean;
            this.mean += (val - this.mean) / (double)count;
            this.variance += (val - this.mean) * (val - oldMean);
        }

        @Override
        public Double sum() {
            return this.sum;
        }
    }

    public static final class LongDocValuesStats
    extends NumericDocValuesStats<Long> {
        private long sum = 0L;

        public LongDocValuesStats(String field) {
            super(field, Long.MAX_VALUE, Long.MIN_VALUE);
        }

        @Override
        protected void doAccumulate(int count) throws IOException {
            long val = this.ndv.longValue();
            if (val > (Long)this.max) {
                this.max = val;
            }
            if (val < (Long)this.min) {
                this.min = val;
            }
            this.sum += val;
            double oldMean = this.mean;
            this.mean += ((double)val - this.mean) / (double)count;
            this.variance += ((double)val - this.mean) * ((double)val - oldMean);
        }

        @Override
        public Long sum() {
            return this.sum;
        }
    }

    public static abstract class NumericDocValuesStats<T extends Number>
    extends DocValuesStats<T> {
        protected double mean = 0.0;
        protected double variance = 0.0;
        protected NumericDocValues ndv;

        protected NumericDocValuesStats(String field, T initialMin, T initialMax) {
            super(field, initialMin, initialMax);
        }

        @Override
        protected final boolean init(LeafReaderContext context) throws IOException {
            this.ndv = context.reader().getNumericDocValues(this.field);
            return this.ndv != null;
        }

        @Override
        protected final boolean hasValue(int doc) throws IOException {
            return this.ndv.advanceExact(doc);
        }

        public final double mean() {
            return this.mean;
        }

        public final double variance() {
            int count = this.count();
            return count > 0 ? this.variance / (double)count : 0.0;
        }

        public final double stdev() {
            return Math.sqrt(this.variance());
        }

        public abstract T sum();
    }
}

