/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.index;

import java.io.IOException;
import java.io.UncheckedIOException;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.IndexReader;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.DocIdSetIterator;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.ArrayUtil;

public abstract class PointValues {
    public static final int MAX_NUM_BYTES = 16;
    public static final int MAX_DIMENSIONS = 16;
    public static final int MAX_INDEX_DIMENSIONS = 8;

    public static long size(IndexReader reader, String field) throws IOException {
        long size = 0L;
        for (LeafReaderContext ctx : reader.leaves()) {
            PointValues values = ctx.reader().getPointValues(field);
            if (values == null) continue;
            size += values.size();
        }
        return size;
    }

    public static int getDocCount(IndexReader reader, String field) throws IOException {
        int count = 0;
        for (LeafReaderContext ctx : reader.leaves()) {
            PointValues values = ctx.reader().getPointValues(field);
            if (values == null) continue;
            count += values.getDocCount();
        }
        return count;
    }

    public static byte[] getMinPackedValue(IndexReader reader, String field) throws IOException {
        byte[] minValue = null;
        for (LeafReaderContext ctx : reader.leaves()) {
            byte[] leafMinValue;
            PointValues values = ctx.reader().getPointValues(field);
            if (values == null || (leafMinValue = values.getMinPackedValue()) == null) continue;
            if (minValue == null) {
                minValue = (byte[])leafMinValue.clone();
                continue;
            }
            int numDimensions = values.getNumIndexDimensions();
            int numBytesPerDimension = values.getBytesPerDimension();
            ArrayUtil.ByteArrayComparator comparator = ArrayUtil.getUnsignedComparator(numBytesPerDimension);
            for (int i = 0; i < numDimensions; ++i) {
                int offset = i * numBytesPerDimension;
                if (comparator.compare(leafMinValue, offset, minValue, offset) >= 0) continue;
                System.arraycopy(leafMinValue, offset, minValue, offset, numBytesPerDimension);
            }
        }
        return minValue;
    }

    public static byte[] getMaxPackedValue(IndexReader reader, String field) throws IOException {
        byte[] maxValue = null;
        for (LeafReaderContext ctx : reader.leaves()) {
            byte[] leafMaxValue;
            PointValues values = ctx.reader().getPointValues(field);
            if (values == null || (leafMaxValue = values.getMaxPackedValue()) == null) continue;
            if (maxValue == null) {
                maxValue = (byte[])leafMaxValue.clone();
                continue;
            }
            int numDimensions = values.getNumIndexDimensions();
            int numBytesPerDimension = values.getBytesPerDimension();
            ArrayUtil.ByteArrayComparator comparator = ArrayUtil.getUnsignedComparator(numBytesPerDimension);
            for (int i = 0; i < numDimensions; ++i) {
                int offset = i * numBytesPerDimension;
                if (comparator.compare(leafMaxValue, offset, maxValue, offset) <= 0) continue;
                System.arraycopy(leafMaxValue, offset, maxValue, offset, numBytesPerDimension);
            }
        }
        return maxValue;
    }

    protected PointValues() {
    }

    public abstract PointTree getPointTree() throws IOException;

    public final void intersect(IntersectVisitor visitor) throws IOException {
        PointTree pointTree = this.getPointTree();
        this.intersect(visitor, pointTree);
        assert (!pointTree.moveToParent());
    }

    private void intersect(IntersectVisitor visitor, PointTree pointTree) throws IOException {
        Relation r = visitor.compare(pointTree.getMinPackedValue(), pointTree.getMaxPackedValue());
        switch (r) {
            case CELL_OUTSIDE_QUERY: {
                break;
            }
            case CELL_INSIDE_QUERY: {
                pointTree.visitDocIDs(visitor);
                break;
            }
            case CELL_CROSSES_QUERY: {
                if (pointTree.moveToChild()) {
                    do {
                        this.intersect(visitor, pointTree);
                    } while (pointTree.moveToSibling());
                    pointTree.moveToParent();
                    break;
                }
                pointTree.visitDocValues(visitor);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unreachable code");
            }
        }
    }

    public final long estimatePointCount(IntersectVisitor visitor) {
        try {
            PointTree pointTree = this.getPointTree();
            long count = this.estimatePointCount(visitor, pointTree);
            assert (!pointTree.moveToParent());
            return count;
        }
        catch (IOException ioe) {
            throw new UncheckedIOException(ioe);
        }
    }

    private long estimatePointCount(IntersectVisitor visitor, PointTree pointTree) throws IOException {
        Relation r = visitor.compare(pointTree.getMinPackedValue(), pointTree.getMaxPackedValue());
        switch (r) {
            case CELL_OUTSIDE_QUERY: {
                return 0L;
            }
            case CELL_INSIDE_QUERY: {
                return pointTree.size();
            }
            case CELL_CROSSES_QUERY: {
                if (pointTree.moveToChild()) {
                    long cost = 0L;
                    do {
                        cost += this.estimatePointCount(visitor, pointTree);
                    } while (pointTree.moveToSibling());
                    pointTree.moveToParent();
                    return cost;
                }
                return (pointTree.size() + 1L) / 2L;
            }
        }
        throw new IllegalArgumentException("Unreachable code");
    }

    public final long estimateDocCount(IntersectVisitor visitor) {
        long estimatedPointCount = this.estimatePointCount(visitor);
        int docCount = this.getDocCount();
        double size = this.size();
        if ((double)estimatedPointCount >= size) {
            return docCount;
        }
        if (size == (double)docCount || estimatedPointCount == 0L) {
            return estimatedPointCount;
        }
        long docEstimate = (long)((double)docCount * (1.0 - Math.pow((size - (double)estimatedPointCount) / size, size / (double)docCount)));
        return docEstimate == 0L ? 1L : docEstimate;
    }

    public abstract byte[] getMinPackedValue() throws IOException;

    public abstract byte[] getMaxPackedValue() throws IOException;

    public abstract int getNumDimensions() throws IOException;

    public abstract int getNumIndexDimensions() throws IOException;

    public abstract int getBytesPerDimension() throws IOException;

    public abstract long size();

    public abstract int getDocCount();

    public static interface IntersectVisitor {
        public void visit(int var1) throws IOException;

        default public void visit(DocIdSetIterator iterator) throws IOException {
            int docID;
            while ((docID = iterator.nextDoc()) != Integer.MAX_VALUE) {
                this.visit(docID);
            }
        }

        public void visit(int var1, byte[] var2) throws IOException;

        default public void visit(DocIdSetIterator iterator, byte[] packedValue) throws IOException {
            int docID;
            while ((docID = iterator.nextDoc()) != Integer.MAX_VALUE) {
                this.visit(docID, packedValue);
            }
        }

        public Relation compare(byte[] var1, byte[] var2);

        default public void grow(int count) {
        }
    }

    public static interface PointTree
    extends Cloneable {
        public PointTree clone();

        public boolean moveToChild() throws IOException;

        public boolean moveToSibling() throws IOException;

        public boolean moveToParent() throws IOException;

        public byte[] getMinPackedValue();

        public byte[] getMaxPackedValue();

        public long size();

        public void visitDocIDs(IntersectVisitor var1) throws IOException;

        public void visitDocValues(IntersectVisitor var1) throws IOException;
    }

    public static enum Relation {
        CELL_INSIDE_QUERY,
        CELL_OUTSIDE_QUERY,
        CELL_CROSSES_QUERY;

    }
}

