/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.index;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.ApproximatePriorityQueue;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.DocumentsWriterPerThread;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.AlreadyClosedException;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.ThreadInterruptedException;

final class DocumentsWriterPerThreadPool
implements Iterable<DocumentsWriterPerThread>,
Closeable {
    private final Set<DocumentsWriterPerThread> dwpts = Collections.newSetFromMap(new IdentityHashMap());
    private final ApproximatePriorityQueue<DocumentsWriterPerThread> freeList = new ApproximatePriorityQueue();
    private final Supplier<DocumentsWriterPerThread> dwptFactory;
    private int takenWriterPermits = 0;
    private boolean closed;

    DocumentsWriterPerThreadPool(Supplier<DocumentsWriterPerThread> dwptFactory) {
        this.dwptFactory = dwptFactory;
    }

    synchronized int size() {
        return this.dwpts.size();
    }

    synchronized void lockNewWriters() {
        assert (this.takenWriterPermits >= 0);
        ++this.takenWriterPermits;
    }

    synchronized void unlockNewWriters() {
        assert (this.takenWriterPermits > 0);
        --this.takenWriterPermits;
        if (this.takenWriterPermits == 0) {
            this.notifyAll();
        }
    }

    private synchronized DocumentsWriterPerThread newWriter() {
        assert (this.takenWriterPermits >= 0);
        while (this.takenWriterPermits > 0) {
            try {
                this.wait();
            }
            catch (InterruptedException ie) {
                throw new ThreadInterruptedException(ie);
            }
        }
        this.ensureOpen();
        DocumentsWriterPerThread dwpt = this.dwptFactory.get();
        dwpt.lock();
        this.dwpts.add(dwpt);
        return dwpt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DocumentsWriterPerThread getAndLock() {
        DocumentsWriterPerThreadPool documentsWriterPerThreadPool = this;
        synchronized (documentsWriterPerThreadPool) {
            this.ensureOpen();
            DocumentsWriterPerThread dwpt = this.freeList.poll(DocumentsWriterPerThread::tryLock);
            if (dwpt == null) {
                dwpt = this.newWriter();
            }
            return dwpt;
        }
    }

    private void ensureOpen() {
        if (this.closed) {
            throw new AlreadyClosedException("DWPTPool is already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void marksAsFreeAndUnlock(DocumentsWriterPerThread state) {
        long ramBytesUsed = state.ramBytesUsed();
        DocumentsWriterPerThreadPool documentsWriterPerThreadPool = this;
        synchronized (documentsWriterPerThreadPool) {
            assert (this.dwpts.contains(state)) : "we tried to add a DWPT back to the pool but the pool doesn't know aobut this DWPT";
            this.freeList.add(state, ramBytesUsed);
        }
        state.unlock();
    }

    @Override
    public synchronized Iterator<DocumentsWriterPerThread> iterator() {
        return List.copyOf(this.dwpts).iterator();
    }

    List<DocumentsWriterPerThread> filterAndLock(Predicate<DocumentsWriterPerThread> predicate) {
        ArrayList<DocumentsWriterPerThread> list = new ArrayList<DocumentsWriterPerThread>();
        for (DocumentsWriterPerThread perThread : this) {
            if (!predicate.test(perThread)) continue;
            perThread.lock();
            if (this.isRegistered(perThread)) {
                list.add(perThread);
                continue;
            }
            perThread.unlock();
        }
        return Collections.unmodifiableList(list);
    }

    synchronized boolean checkout(DocumentsWriterPerThread perThread) {
        assert (perThread.isHeldByCurrentThread());
        if (!this.dwpts.remove(perThread)) {
            assert (!this.freeList.contains(perThread));
            return false;
        }
        this.freeList.remove(perThread);
        return true;
    }

    synchronized boolean isRegistered(DocumentsWriterPerThread perThread) {
        return this.dwpts.contains(perThread);
    }

    @Override
    public synchronized void close() {
        this.closed = true;
    }
}

