/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.geo;

import java.util.Arrays;
import org.graylog.shaded.opensearch2.org.apache.lucene.geo.Component2D;
import org.graylog.shaded.opensearch2.org.apache.lucene.geo.GeoUtils;
import org.graylog.shaded.opensearch2.org.apache.lucene.geo.Polygon2D;
import org.graylog.shaded.opensearch2.org.apache.lucene.geo.XYEncodingUtils;
import org.graylog.shaded.opensearch2.org.apache.lucene.geo.XYGeometry;

public final class XYPolygon
extends XYGeometry {
    private final float[] x;
    private final float[] y;
    private final XYPolygon[] holes;
    public final float minX;
    public final float maxX;
    public final float minY;
    public final float maxY;
    private final GeoUtils.WindingOrder windingOrder;

    public XYPolygon(float[] x, float[] y, XYPolygon ... holes) {
        if (x == null) {
            throw new IllegalArgumentException("x must not be null");
        }
        if (y == null) {
            throw new IllegalArgumentException("y must not be null");
        }
        if (holes == null) {
            throw new IllegalArgumentException("holes must not be null");
        }
        if (x.length != y.length) {
            throw new IllegalArgumentException("x and y must be equal length");
        }
        if (x.length < 4) {
            throw new IllegalArgumentException("at least 4 polygon points required");
        }
        if (x[0] != x[x.length - 1]) {
            throw new IllegalArgumentException("first and last points of the polygon must be the same (it must close itself): x[0]=" + x[0] + " x[" + (x.length - 1) + "]=" + x[x.length - 1]);
        }
        if (y[0] != y[y.length - 1]) {
            throw new IllegalArgumentException("first and last points of the polygon must be the same (it must close itself): y[0]=" + y[0] + " y[" + (y.length - 1) + "]=" + y[y.length - 1]);
        }
        for (int i = 0; i < holes.length; ++i) {
            XYPolygon inner = holes[i];
            if (inner.holes.length <= 0) continue;
            throw new IllegalArgumentException("holes may not contain holes: polygons may not nest.");
        }
        this.x = (float[])x.clone();
        this.y = (float[])y.clone();
        this.holes = (XYPolygon[])holes.clone();
        float minX = XYEncodingUtils.checkVal(x[0]);
        float maxX = x[0];
        float minY = XYEncodingUtils.checkVal(y[0]);
        float maxY = y[0];
        double windingSum = 0.0;
        int numPts = x.length - 1;
        int i = 1;
        int j = 0;
        while (i < numPts) {
            minX = Math.min(XYEncodingUtils.checkVal(x[i]), minX);
            maxX = Math.max(x[i], maxX);
            minY = Math.min(XYEncodingUtils.checkVal(y[i]), minY);
            maxY = Math.max(y[i], maxY);
            windingSum += (double)((x[j] - x[numPts]) * (y[i] - y[numPts]) - (y[j] - y[numPts]) * (x[i] - x[numPts]));
            j = i++;
        }
        this.minX = minX;
        this.maxX = maxX;
        this.minY = minY;
        this.maxY = maxY;
        this.windingOrder = windingSum < 0.0 ? GeoUtils.WindingOrder.CCW : GeoUtils.WindingOrder.CW;
    }

    public int numPoints() {
        return this.x.length;
    }

    public float[] getPolyX() {
        return (float[])this.x.clone();
    }

    public float getPolyX(int vertex) {
        return this.x[vertex];
    }

    public float[] getPolyY() {
        return (float[])this.y.clone();
    }

    public float getPolyY(int vertex) {
        return this.y[vertex];
    }

    public XYPolygon[] getHoles() {
        return (XYPolygon[])this.holes.clone();
    }

    XYPolygon getHole(int i) {
        return this.holes[i];
    }

    public GeoUtils.WindingOrder getWindingOrder() {
        return this.windingOrder;
    }

    public int numHoles() {
        return this.holes.length;
    }

    @Override
    protected Component2D toComponent2D() {
        return Polygon2D.create(this);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.holes);
        result = 31 * result + Arrays.hashCode(this.x);
        result = 31 * result + Arrays.hashCode(this.y);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        XYPolygon other = (XYPolygon)obj;
        if (!Arrays.equals(this.holes, other.holes)) {
            return false;
        }
        if (!Arrays.equals(this.x, other.x)) {
            return false;
        }
        return Arrays.equals(this.y, other.y);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.x.length; ++i) {
            sb.append("[").append(this.x[i]).append(", ").append(this.y[i]).append("] ");
        }
        if (this.holes.length > 0) {
            sb.append(", holes=");
            sb.append(Arrays.toString(this.holes));
        }
        return sb.toString();
    }
}

