/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.codecs.lucene90.compressing;

import java.io.IOException;
import org.graylog.shaded.opensearch2.org.apache.lucene.codecs.StoredFieldsFormat;
import org.graylog.shaded.opensearch2.org.apache.lucene.codecs.StoredFieldsReader;
import org.graylog.shaded.opensearch2.org.apache.lucene.codecs.StoredFieldsWriter;
import org.graylog.shaded.opensearch2.org.apache.lucene.codecs.compressing.CompressionMode;
import org.graylog.shaded.opensearch2.org.apache.lucene.codecs.lucene90.compressing.Lucene90CompressingStoredFieldsReader;
import org.graylog.shaded.opensearch2.org.apache.lucene.codecs.lucene90.compressing.Lucene90CompressingStoredFieldsWriter;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.FieldInfos;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.SegmentInfo;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.Directory;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.IOContext;

public class Lucene90CompressingStoredFieldsFormat
extends StoredFieldsFormat {
    private final String formatName;
    private final String segmentSuffix;
    private final CompressionMode compressionMode;
    private final int chunkSize;
    private final int maxDocsPerChunk;
    private final int blockShift;

    public Lucene90CompressingStoredFieldsFormat(String formatName, CompressionMode compressionMode, int chunkSize, int maxDocsPerChunk, int blockShift) {
        this(formatName, "", compressionMode, chunkSize, maxDocsPerChunk, blockShift);
    }

    public Lucene90CompressingStoredFieldsFormat(String formatName, String segmentSuffix, CompressionMode compressionMode, int chunkSize, int maxDocsPerChunk, int blockShift) {
        this.formatName = formatName;
        this.segmentSuffix = segmentSuffix;
        this.compressionMode = compressionMode;
        if (chunkSize < 1) {
            throw new IllegalArgumentException("chunkSize must be >= 1");
        }
        this.chunkSize = chunkSize;
        if (maxDocsPerChunk < 1) {
            throw new IllegalArgumentException("maxDocsPerChunk must be >= 1");
        }
        this.maxDocsPerChunk = maxDocsPerChunk;
        if (blockShift < 2 || blockShift > 22) {
            throw new IllegalArgumentException("blockSize must be in 2-22, got " + blockShift);
        }
        this.blockShift = blockShift;
    }

    @Override
    public StoredFieldsReader fieldsReader(Directory directory, SegmentInfo si, FieldInfos fn, IOContext context) throws IOException {
        return new Lucene90CompressingStoredFieldsReader(directory, si, this.segmentSuffix, fn, context, this.formatName, this.compressionMode);
    }

    @Override
    public StoredFieldsWriter fieldsWriter(Directory directory, SegmentInfo si, IOContext context) throws IOException {
        return new Lucene90CompressingStoredFieldsWriter(directory, si, this.segmentSuffix, context, this.formatName, this.compressionMode, this.chunkSize, this.maxDocsPerChunk, this.blockShift);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(compressionMode=" + this.compressionMode + ", chunkSize=" + this.chunkSize + ", maxDocsPerChunk=" + this.maxDocsPerChunk + ", blockShift=" + this.blockShift + ")";
    }
}

