/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.codecs.lucene90;

import java.io.IOException;
import java.util.Arrays;
import org.graylog.shaded.opensearch2.org.apache.lucene.codecs.BlockTermState;
import org.graylog.shaded.opensearch2.org.apache.lucene.codecs.CodecUtil;
import org.graylog.shaded.opensearch2.org.apache.lucene.codecs.PostingsReaderBase;
import org.graylog.shaded.opensearch2.org.apache.lucene.codecs.lucene90.ForUtil;
import org.graylog.shaded.opensearch2.org.apache.lucene.codecs.lucene90.Lucene90PostingsFormat;
import org.graylog.shaded.opensearch2.org.apache.lucene.codecs.lucene90.Lucene90ScoreSkipReader;
import org.graylog.shaded.opensearch2.org.apache.lucene.codecs.lucene90.Lucene90SkipReader;
import org.graylog.shaded.opensearch2.org.apache.lucene.codecs.lucene90.PForUtil;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.FieldInfo;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.Impacts;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.ImpactsEnum;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.IndexFileNames;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.IndexOptions;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.PostingsEnum;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.SegmentReadState;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.SlowImpactsEnum;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.DataInput;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.IndexInput;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.ArrayUtil;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.BitUtil;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.BytesRef;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.IOUtils;

public final class Lucene90PostingsReader
extends PostingsReaderBase {
    private final IndexInput docIn;
    private final IndexInput posIn;
    private final IndexInput payIn;
    private final int version;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Lucene90PostingsReader(SegmentReadState state) throws IOException {
        boolean success = false;
        IndexInput docIn = null;
        IndexInput posIn = null;
        IndexInput payIn = null;
        String docName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, "doc");
        try {
            docIn = state.directory.openInput(docName, state.context);
            this.version = CodecUtil.checkIndexHeader(docIn, "Lucene90PostingsWriterDoc", 0, 0, state.segmentInfo.getId(), state.segmentSuffix);
            CodecUtil.retrieveChecksum(docIn);
            if (state.fieldInfos.hasProx()) {
                String proxName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, "pos");
                posIn = state.directory.openInput(proxName, state.context);
                CodecUtil.checkIndexHeader(posIn, "Lucene90PostingsWriterPos", this.version, this.version, state.segmentInfo.getId(), state.segmentSuffix);
                CodecUtil.retrieveChecksum(posIn);
                if (state.fieldInfos.hasPayloads() || state.fieldInfos.hasOffsets()) {
                    String payName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, "pay");
                    payIn = state.directory.openInput(payName, state.context);
                    CodecUtil.checkIndexHeader(payIn, "Lucene90PostingsWriterPay", this.version, this.version, state.segmentInfo.getId(), state.segmentSuffix);
                    CodecUtil.retrieveChecksum(payIn);
                }
            }
            this.docIn = docIn;
            this.posIn = posIn;
            this.payIn = payIn;
            success = true;
            if (success) return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException(docIn, posIn, payIn);
            throw throwable;
        }
        IOUtils.closeWhileHandlingException(docIn, posIn, payIn);
    }

    @Override
    public void init(IndexInput termsIn, SegmentReadState state) throws IOException {
        CodecUtil.checkIndexHeader(termsIn, "Lucene90PostingsWriterTerms", 0, 0, state.segmentInfo.getId(), state.segmentSuffix);
        int indexBlockSize = termsIn.readVInt();
        if (indexBlockSize != 128) {
            throw new IllegalStateException("index-time BLOCK_SIZE (" + indexBlockSize + ") != read-time BLOCK_SIZE (128)");
        }
    }

    static void readVIntBlock(IndexInput docIn, long[] docBuffer, long[] freqBuffer, int num, boolean indexHasFreq) throws IOException {
        if (indexHasFreq) {
            for (int i = 0; i < num; ++i) {
                int code = docIn.readVInt();
                docBuffer[i] = code >>> 1;
                freqBuffer[i] = (code & 1) != 0 ? 1L : (long)docIn.readVInt();
            }
        } else {
            for (int i = 0; i < num; ++i) {
                docBuffer[i] = docIn.readVInt();
            }
        }
    }

    static void prefixSum(long[] buffer, int count, long base) {
        buffer[0] = buffer[0] + base;
        for (int i = 1; i < count; ++i) {
            int n = i;
            buffer[n] = buffer[n] + buffer[i - 1];
        }
    }

    static int findFirstGreater(long[] buffer, int target, int from) {
        for (int i = from; i < 128; ++i) {
            if (buffer[i] < (long)target) continue;
            return i;
        }
        return 128;
    }

    @Override
    public BlockTermState newTermState() {
        return new Lucene90PostingsFormat.IntBlockTermState();
    }

    @Override
    public void close() throws IOException {
        IOUtils.close(this.docIn, this.posIn, this.payIn);
    }

    @Override
    public void decodeTerm(DataInput in, FieldInfo fieldInfo, BlockTermState _termState, boolean absolute) throws IOException {
        long l;
        Lucene90PostingsFormat.IntBlockTermState termState = (Lucene90PostingsFormat.IntBlockTermState)_termState;
        boolean fieldHasPositions = fieldInfo.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0;
        boolean fieldHasOffsets = fieldInfo.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) >= 0;
        boolean fieldHasPayloads = fieldInfo.hasPayloads();
        if (absolute) {
            termState.docStartFP = 0L;
            termState.posStartFP = 0L;
            termState.payStartFP = 0L;
        }
        if (((l = in.readVLong()) & 1L) == 0L) {
            termState.docStartFP += l >>> 1;
            termState.singletonDocID = termState.docFreq == 1 ? in.readVInt() : -1;
        } else {
            assert (!absolute);
            assert (termState.singletonDocID != -1);
            termState.singletonDocID = (int)((long)termState.singletonDocID + BitUtil.zigZagDecode(l >>> 1));
        }
        if (fieldHasPositions) {
            termState.posStartFP += in.readVLong();
            if (fieldHasOffsets || fieldHasPayloads) {
                termState.payStartFP += in.readVLong();
            }
            termState.lastPosBlockOffset = termState.totalTermFreq > 128L ? in.readVLong() : -1L;
        }
        termState.skipOffset = termState.docFreq > 128 ? in.readVLong() : -1L;
    }

    @Override
    public PostingsEnum postings(FieldInfo fieldInfo, BlockTermState termState, PostingsEnum reuse, int flags) throws IOException {
        EverythingEnum everythingEnum;
        boolean indexHasPositions;
        boolean bl = indexHasPositions = fieldInfo.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0;
        if (!indexHasPositions || !PostingsEnum.featureRequested(flags, (short)24)) {
            BlockDocsEnum docsEnum;
            if (reuse instanceof BlockDocsEnum) {
                docsEnum = (BlockDocsEnum)reuse;
                if (!docsEnum.canReuse(this.docIn, fieldInfo)) {
                    docsEnum = new BlockDocsEnum(fieldInfo);
                }
            } else {
                docsEnum = new BlockDocsEnum(fieldInfo);
            }
            return docsEnum.reset((Lucene90PostingsFormat.IntBlockTermState)termState, flags);
        }
        if (reuse instanceof EverythingEnum) {
            everythingEnum = (EverythingEnum)reuse;
            if (!everythingEnum.canReuse(this.docIn, fieldInfo)) {
                everythingEnum = new EverythingEnum(fieldInfo);
            }
        } else {
            everythingEnum = new EverythingEnum(fieldInfo);
        }
        return everythingEnum.reset((Lucene90PostingsFormat.IntBlockTermState)termState, flags);
    }

    @Override
    public ImpactsEnum impacts(FieldInfo fieldInfo, BlockTermState state, int flags) throws IOException {
        if (state.docFreq <= 128) {
            return new SlowImpactsEnum(this.postings(fieldInfo, state, null, flags));
        }
        boolean indexHasPositions = fieldInfo.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0;
        boolean indexHasOffsets = fieldInfo.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) >= 0;
        boolean indexHasPayloads = fieldInfo.hasPayloads();
        if (!indexHasPositions || !PostingsEnum.featureRequested(flags, (short)24)) {
            return new BlockImpactsDocsEnum(fieldInfo, (Lucene90PostingsFormat.IntBlockTermState)state);
        }
        if (!(!indexHasPositions || !PostingsEnum.featureRequested(flags, (short)24) || indexHasOffsets && PostingsEnum.featureRequested(flags, (short)56) || indexHasPayloads && PostingsEnum.featureRequested(flags, (short)88))) {
            return new BlockImpactsPostingsEnum(fieldInfo, (Lucene90PostingsFormat.IntBlockTermState)state);
        }
        return new BlockImpactsEverythingEnum(fieldInfo, (Lucene90PostingsFormat.IntBlockTermState)state, flags);
    }

    @Override
    public void checkIntegrity() throws IOException {
        if (this.docIn != null) {
            CodecUtil.checksumEntireFile(this.docIn);
        }
        if (this.posIn != null) {
            CodecUtil.checksumEntireFile(this.posIn);
        }
        if (this.payIn != null) {
            CodecUtil.checksumEntireFile(this.payIn);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(positions=" + (this.posIn != null) + ",payloads=" + (this.payIn != null) + ")";
    }

    final class BlockImpactsEverythingEnum
    extends ImpactsEnum {
        final PForUtil pforUtil = new PForUtil(new ForUtil());
        private final long[] docBuffer = new long[128];
        private final long[] freqBuffer = new long[128];
        private final long[] posDeltaBuffer = new long[128];
        private final long[] payloadLengthBuffer;
        private final long[] offsetStartDeltaBuffer;
        private final long[] offsetLengthBuffer;
        private byte[] payloadBytes;
        private int payloadByteUpto;
        private int payloadLength;
        private int lastStartOffset;
        private int startOffset = -1;
        private int endOffset = -1;
        private int docBufferUpto;
        private int posBufferUpto;
        private final Lucene90ScoreSkipReader skipper;
        final IndexInput docIn;
        final IndexInput posIn;
        final IndexInput payIn;
        final BytesRef payload;
        final boolean indexHasFreq;
        final boolean indexHasPos;
        final boolean indexHasOffsets;
        final boolean indexHasPayloads;
        private int docFreq;
        private long totalTermFreq;
        private int docUpto;
        private int posDocUpTo;
        private int doc;
        private long accum;
        private int position;
        private int posPendingCount;
        private long posPendingFP;
        private long payPendingFP;
        private long docTermStartFP;
        private long posTermStartFP;
        private long payTermStartFP;
        private long lastPosBlockFP;
        private int nextSkipDoc = -1;
        private final boolean needsPositions;
        private final boolean needsOffsets;
        private final boolean needsPayloads;
        private boolean isFreqsRead;
        private long seekTo = -1L;

        public BlockImpactsEverythingEnum(FieldInfo fieldInfo, Lucene90PostingsFormat.IntBlockTermState termState, int flags) throws IOException {
            this.indexHasFreq = fieldInfo.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS) >= 0;
            this.indexHasPos = fieldInfo.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0;
            this.indexHasOffsets = fieldInfo.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) >= 0;
            this.indexHasPayloads = fieldInfo.hasPayloads();
            this.needsPositions = PostingsEnum.featureRequested(flags, (short)24);
            this.needsOffsets = PostingsEnum.featureRequested(flags, (short)56);
            this.needsPayloads = PostingsEnum.featureRequested(flags, (short)88);
            this.docIn = Lucene90PostingsReader.this.docIn.clone();
            this.posIn = this.indexHasPos && this.needsPositions ? Lucene90PostingsReader.this.posIn.clone() : null;
            this.payIn = this.indexHasOffsets && this.needsOffsets || this.indexHasPayloads && this.needsPayloads ? Lucene90PostingsReader.this.payIn.clone() : null;
            if (this.indexHasOffsets) {
                this.offsetStartDeltaBuffer = new long[128];
                this.offsetLengthBuffer = new long[128];
            } else {
                this.offsetStartDeltaBuffer = null;
                this.offsetLengthBuffer = null;
                this.startOffset = -1;
                this.endOffset = -1;
            }
            if (this.indexHasPayloads) {
                this.payloadLengthBuffer = new long[128];
                this.payloadBytes = new byte[128];
                this.payload = new BytesRef();
            } else {
                this.payloadLengthBuffer = null;
                this.payloadBytes = null;
                this.payload = null;
            }
            this.docFreq = termState.docFreq;
            this.docTermStartFP = termState.docStartFP;
            this.posTermStartFP = termState.posStartFP;
            this.payTermStartFP = termState.payStartFP;
            this.totalTermFreq = termState.totalTermFreq;
            this.docIn.seek(this.docTermStartFP);
            this.posPendingFP = this.posTermStartFP;
            this.payPendingFP = this.payTermStartFP;
            this.posPendingCount = 0;
            this.lastPosBlockFP = termState.totalTermFreq < 128L ? this.posTermStartFP : (termState.totalTermFreq == 128L ? -1L : this.posTermStartFP + termState.lastPosBlockOffset);
            this.doc = -1;
            this.accum = 0L;
            this.docUpto = 0;
            this.posDocUpTo = 0;
            this.isFreqsRead = true;
            this.docBufferUpto = 128;
            this.skipper = new Lucene90ScoreSkipReader(this.docIn.clone(), 10, this.indexHasPos, this.indexHasOffsets, this.indexHasPayloads);
            this.skipper.init(this.docTermStartFP + termState.skipOffset, this.docTermStartFP, this.posTermStartFP, this.payTermStartFP, this.docFreq);
            if (!this.indexHasFreq) {
                for (int i = 0; i < 128; ++i) {
                    this.freqBuffer[i] = 1L;
                }
            }
        }

        @Override
        public int freq() throws IOException {
            if (this.indexHasFreq && !this.isFreqsRead) {
                this.pforUtil.decode(this.docIn, this.freqBuffer);
                this.isFreqsRead = true;
            }
            return (int)this.freqBuffer[this.docBufferUpto - 1];
        }

        @Override
        public int docID() {
            return this.doc;
        }

        private void refillDocs() throws IOException {
            if (this.indexHasFreq) {
                if (!this.isFreqsRead) {
                    if (this.indexHasPos && this.needsPositions && this.posDocUpTo < this.docUpto) {
                        this.pforUtil.decode(this.docIn, this.freqBuffer);
                    } else {
                        this.pforUtil.skip(this.docIn);
                    }
                    this.isFreqsRead = true;
                }
                if (this.indexHasPos && this.needsPositions) {
                    while (this.posDocUpTo < this.docUpto) {
                        this.posPendingCount = (int)((long)this.posPendingCount + this.freqBuffer[this.docBufferUpto - (this.docUpto - this.posDocUpTo)]);
                        ++this.posDocUpTo;
                    }
                }
            }
            int left = this.docFreq - this.docUpto;
            assert (left >= 0);
            if (left >= 128) {
                this.pforUtil.decodeAndPrefixSum(this.docIn, this.accum, this.docBuffer);
                if (this.indexHasFreq) {
                    this.isFreqsRead = false;
                }
            } else {
                Lucene90PostingsReader.readVIntBlock(this.docIn, this.docBuffer, this.freqBuffer, left, this.indexHasFreq);
                Lucene90PostingsReader.prefixSum(this.docBuffer, left, this.accum);
                this.docBuffer[left] = Integer.MAX_VALUE;
            }
            this.accum = this.docBuffer[127];
            this.docBufferUpto = 0;
        }

        private void refillPositions() throws IOException {
            if (this.posIn.getFilePointer() == this.lastPosBlockFP) {
                int count = (int)(this.totalTermFreq % 128L);
                int payloadLength = 0;
                int offsetLength = 0;
                this.payloadByteUpto = 0;
                for (int i = 0; i < count; ++i) {
                    int code = this.posIn.readVInt();
                    if (this.indexHasPayloads) {
                        if ((code & 1) != 0) {
                            payloadLength = this.posIn.readVInt();
                        }
                        this.payloadLengthBuffer[i] = payloadLength;
                        this.posDeltaBuffer[i] = code >>> 1;
                        if (payloadLength != 0) {
                            if (this.payloadByteUpto + payloadLength > this.payloadBytes.length) {
                                this.payloadBytes = ArrayUtil.grow(this.payloadBytes, this.payloadByteUpto + payloadLength);
                            }
                            this.posIn.readBytes(this.payloadBytes, this.payloadByteUpto, payloadLength);
                            this.payloadByteUpto += payloadLength;
                        }
                    } else {
                        this.posDeltaBuffer[i] = code;
                    }
                    if (!this.indexHasOffsets) continue;
                    int deltaCode = this.posIn.readVInt();
                    if ((deltaCode & 1) != 0) {
                        offsetLength = this.posIn.readVInt();
                    }
                    this.offsetStartDeltaBuffer[i] = deltaCode >>> 1;
                    this.offsetLengthBuffer[i] = offsetLength;
                }
                this.payloadByteUpto = 0;
            } else {
                this.pforUtil.decode(this.posIn, this.posDeltaBuffer);
                if (this.indexHasPayloads && this.payIn != null) {
                    if (this.needsPayloads) {
                        this.pforUtil.decode(this.payIn, this.payloadLengthBuffer);
                        int numBytes = this.payIn.readVInt();
                        if (numBytes > this.payloadBytes.length) {
                            this.payloadBytes = ArrayUtil.grow(this.payloadBytes, numBytes);
                        }
                        this.payIn.readBytes(this.payloadBytes, 0, numBytes);
                    } else {
                        this.pforUtil.skip(this.payIn);
                        int numBytes = this.payIn.readVInt();
                        this.payIn.seek(this.payIn.getFilePointer() + (long)numBytes);
                    }
                    this.payloadByteUpto = 0;
                }
                if (this.indexHasOffsets && this.payIn != null) {
                    if (this.needsOffsets) {
                        this.pforUtil.decode(this.payIn, this.offsetStartDeltaBuffer);
                        this.pforUtil.decode(this.payIn, this.offsetLengthBuffer);
                    } else {
                        this.pforUtil.skip(this.payIn);
                        this.pforUtil.skip(this.payIn);
                    }
                }
            }
        }

        @Override
        public void advanceShallow(int target) throws IOException {
            if (target > this.nextSkipDoc) {
                int newDocUpto = this.skipper.skipTo(target) + 1;
                if (newDocUpto > this.docUpto) {
                    assert (newDocUpto % 128 == 0) : "got " + newDocUpto;
                    this.posDocUpTo = this.docUpto = newDocUpto;
                    this.docBufferUpto = 128;
                    this.accum = this.skipper.getDoc();
                    this.posPendingFP = this.skipper.getPosPointer();
                    this.payPendingFP = this.skipper.getPayPointer();
                    this.posPendingCount = this.skipper.getPosBufferUpto();
                    this.lastStartOffset = 0;
                    this.payloadByteUpto = this.skipper.getPayloadByteUpto();
                    this.seekTo = this.skipper.getDocPointer();
                }
                this.nextSkipDoc = this.skipper.getNextSkipDoc();
            }
            assert (this.nextSkipDoc >= target);
        }

        @Override
        public Impacts getImpacts() throws IOException {
            this.advanceShallow(this.doc);
            return this.skipper.getImpacts();
        }

        @Override
        public int nextDoc() throws IOException {
            return this.advance(this.doc + 1);
        }

        @Override
        public int advance(int target) throws IOException {
            long doc;
            block4: {
                if (target > this.nextSkipDoc) {
                    this.advanceShallow(target);
                }
                if (this.docBufferUpto == 128) {
                    if (this.seekTo >= 0L) {
                        this.docIn.seek(this.seekTo);
                        this.seekTo = -1L;
                        this.isFreqsRead = true;
                    }
                    this.refillDocs();
                }
                do {
                    doc = this.docBuffer[this.docBufferUpto];
                    ++this.docBufferUpto;
                    ++this.docUpto;
                    if (doc >= (long)target) break block4;
                } while (this.docBufferUpto != 128);
                this.doc = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }
            this.position = 0;
            this.lastStartOffset = 0;
            this.doc = (int)doc;
            return this.doc;
        }

        private void skipPositions() throws IOException {
            int toSkip = this.posPendingCount - (int)this.freqBuffer[this.docBufferUpto - 1];
            int leftInBlock = 128 - this.posBufferUpto;
            if (toSkip < leftInBlock) {
                int end = this.posBufferUpto + toSkip;
                while (this.posBufferUpto < end) {
                    if (this.indexHasPayloads) {
                        this.payloadByteUpto = (int)((long)this.payloadByteUpto + this.payloadLengthBuffer[this.posBufferUpto]);
                    }
                    ++this.posBufferUpto;
                }
            } else {
                toSkip -= leftInBlock;
                while (toSkip >= 128) {
                    assert (this.posIn.getFilePointer() != this.lastPosBlockFP);
                    this.pforUtil.skip(this.posIn);
                    if (this.indexHasPayloads && this.payIn != null) {
                        this.pforUtil.skip(this.payIn);
                        int numBytes = this.payIn.readVInt();
                        this.payIn.seek(this.payIn.getFilePointer() + (long)numBytes);
                    }
                    if (this.indexHasOffsets && this.payIn != null) {
                        this.pforUtil.skip(this.payIn);
                        this.pforUtil.skip(this.payIn);
                    }
                    toSkip -= 128;
                }
                this.refillPositions();
                this.payloadByteUpto = 0;
                this.posBufferUpto = 0;
                while (this.posBufferUpto < toSkip) {
                    if (this.indexHasPayloads) {
                        this.payloadByteUpto = (int)((long)this.payloadByteUpto + this.payloadLengthBuffer[this.posBufferUpto]);
                    }
                    ++this.posBufferUpto;
                }
            }
            this.position = 0;
            this.lastStartOffset = 0;
        }

        @Override
        public int nextPosition() throws IOException {
            if (!this.indexHasPos || !this.needsPositions) {
                return -1;
            }
            if (!this.isFreqsRead) {
                this.pforUtil.decode(this.docIn, this.freqBuffer);
                this.isFreqsRead = true;
            }
            while (this.posDocUpTo < this.docUpto) {
                this.posPendingCount = (int)((long)this.posPendingCount + this.freqBuffer[this.docBufferUpto - (this.docUpto - this.posDocUpTo)]);
                ++this.posDocUpTo;
            }
            assert (this.posPendingCount > 0);
            if (this.posPendingFP != -1L) {
                this.posIn.seek(this.posPendingFP);
                this.posPendingFP = -1L;
                if (this.payPendingFP != -1L && this.payIn != null) {
                    this.payIn.seek(this.payPendingFP);
                    this.payPendingFP = -1L;
                }
                this.posBufferUpto = 128;
            }
            if ((long)this.posPendingCount > this.freqBuffer[this.docBufferUpto - 1]) {
                this.skipPositions();
                this.posPendingCount = (int)this.freqBuffer[this.docBufferUpto - 1];
            }
            if (this.posBufferUpto == 128) {
                this.refillPositions();
                this.posBufferUpto = 0;
            }
            this.position = (int)((long)this.position + this.posDeltaBuffer[this.posBufferUpto]);
            if (this.indexHasPayloads) {
                this.payloadLength = (int)this.payloadLengthBuffer[this.posBufferUpto];
                this.payload.bytes = this.payloadBytes;
                this.payload.offset = this.payloadByteUpto;
                this.payload.length = this.payloadLength;
                this.payloadByteUpto += this.payloadLength;
            }
            if (this.indexHasOffsets && this.needsOffsets) {
                this.startOffset = this.lastStartOffset + (int)this.offsetStartDeltaBuffer[this.posBufferUpto];
                this.endOffset = this.startOffset + (int)this.offsetLengthBuffer[this.posBufferUpto];
                this.lastStartOffset = this.startOffset;
            }
            ++this.posBufferUpto;
            --this.posPendingCount;
            return this.position;
        }

        @Override
        public int startOffset() {
            return this.startOffset;
        }

        @Override
        public int endOffset() {
            return this.endOffset;
        }

        @Override
        public BytesRef getPayload() {
            if (this.payloadLength == 0) {
                return null;
            }
            return this.payload;
        }

        @Override
        public long cost() {
            return this.docFreq;
        }
    }

    final class BlockImpactsPostingsEnum
    extends ImpactsEnum {
        final PForUtil pforUtil = new PForUtil(new ForUtil());
        private final long[] docBuffer = new long[128];
        private final long[] freqBuffer = new long[128];
        private final long[] posDeltaBuffer = new long[128];
        private int docBufferUpto;
        private int posBufferUpto;
        private final Lucene90ScoreSkipReader skipper;
        final IndexInput docIn;
        final IndexInput posIn;
        final boolean indexHasOffsets;
        final boolean indexHasPayloads;
        private int docFreq;
        private long totalTermFreq;
        private int docUpto;
        private int doc;
        private long accum;
        private int freq;
        private int position;
        private int posPendingCount;
        private long posPendingFP;
        private long docTermStartFP;
        private long posTermStartFP;
        private long payTermStartFP;
        private long lastPosBlockFP;
        private int nextSkipDoc = -1;
        private long seekTo = -1L;

        public BlockImpactsPostingsEnum(FieldInfo fieldInfo, Lucene90PostingsFormat.IntBlockTermState termState) throws IOException {
            this.indexHasOffsets = fieldInfo.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) >= 0;
            this.indexHasPayloads = fieldInfo.hasPayloads();
            this.docIn = Lucene90PostingsReader.this.docIn.clone();
            this.posIn = Lucene90PostingsReader.this.posIn.clone();
            this.docFreq = termState.docFreq;
            this.docTermStartFP = termState.docStartFP;
            this.posTermStartFP = termState.posStartFP;
            this.payTermStartFP = termState.payStartFP;
            this.totalTermFreq = termState.totalTermFreq;
            this.docIn.seek(this.docTermStartFP);
            this.posPendingFP = this.posTermStartFP;
            this.posPendingCount = 0;
            this.lastPosBlockFP = termState.totalTermFreq < 128L ? this.posTermStartFP : (termState.totalTermFreq == 128L ? -1L : this.posTermStartFP + termState.lastPosBlockOffset);
            this.doc = -1;
            this.accum = 0L;
            this.docUpto = 0;
            this.docBufferUpto = 128;
            this.skipper = new Lucene90ScoreSkipReader(this.docIn.clone(), 10, true, this.indexHasOffsets, this.indexHasPayloads);
            this.skipper.init(this.docTermStartFP + termState.skipOffset, this.docTermStartFP, this.posTermStartFP, this.payTermStartFP, this.docFreq);
        }

        @Override
        public int freq() throws IOException {
            return this.freq;
        }

        @Override
        public int docID() {
            return this.doc;
        }

        private void refillDocs() throws IOException {
            int left = this.docFreq - this.docUpto;
            assert (left >= 0);
            if (left >= 128) {
                this.pforUtil.decodeAndPrefixSum(this.docIn, this.accum, this.docBuffer);
                this.pforUtil.decode(this.docIn, this.freqBuffer);
            } else {
                Lucene90PostingsReader.readVIntBlock(this.docIn, this.docBuffer, this.freqBuffer, left, true);
                Lucene90PostingsReader.prefixSum(this.docBuffer, left, this.accum);
                this.docBuffer[left] = Integer.MAX_VALUE;
            }
            this.accum = this.docBuffer[127];
            this.docBufferUpto = 0;
        }

        private void refillPositions() throws IOException {
            if (this.posIn.getFilePointer() == this.lastPosBlockFP) {
                int count = (int)(this.totalTermFreq % 128L);
                int payloadLength = 0;
                for (int i = 0; i < count; ++i) {
                    int code = this.posIn.readVInt();
                    if (this.indexHasPayloads) {
                        if ((code & 1) != 0) {
                            payloadLength = this.posIn.readVInt();
                        }
                        this.posDeltaBuffer[i] = code >>> 1;
                        if (payloadLength != 0) {
                            this.posIn.seek(this.posIn.getFilePointer() + (long)payloadLength);
                        }
                    } else {
                        this.posDeltaBuffer[i] = code;
                    }
                    if (!this.indexHasOffsets || (this.posIn.readVInt() & 1) == 0) continue;
                    this.posIn.readVInt();
                }
            } else {
                this.pforUtil.decode(this.posIn, this.posDeltaBuffer);
            }
        }

        @Override
        public void advanceShallow(int target) throws IOException {
            if (target > this.nextSkipDoc) {
                int newDocUpto = this.skipper.skipTo(target) + 1;
                if (newDocUpto > this.docUpto) {
                    assert (newDocUpto % 128 == 0) : "got " + newDocUpto;
                    this.docUpto = newDocUpto;
                    this.docBufferUpto = 128;
                    this.accum = this.skipper.getDoc();
                    this.posPendingFP = this.skipper.getPosPointer();
                    this.posPendingCount = this.skipper.getPosBufferUpto();
                    this.seekTo = this.skipper.getDocPointer();
                }
                this.nextSkipDoc = this.skipper.getNextSkipDoc();
            }
            assert (this.nextSkipDoc >= target);
        }

        @Override
        public Impacts getImpacts() throws IOException {
            this.advanceShallow(this.doc);
            return this.skipper.getImpacts();
        }

        @Override
        public int nextDoc() throws IOException {
            return this.advance(this.doc + 1);
        }

        @Override
        public int advance(int target) throws IOException {
            int next;
            if (target > this.nextSkipDoc) {
                this.advanceShallow(target);
            }
            if (this.docBufferUpto == 128) {
                if (this.seekTo >= 0L) {
                    this.docIn.seek(this.seekTo);
                    this.seekTo = -1L;
                }
                this.refillDocs();
            }
            if ((next = Lucene90PostingsReader.findFirstGreater(this.docBuffer, target, this.docBufferUpto)) == 128) {
                this.doc = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }
            this.doc = (int)this.docBuffer[next];
            this.freq = (int)this.freqBuffer[next];
            for (int i = this.docBufferUpto; i <= next; ++i) {
                this.posPendingCount = (int)((long)this.posPendingCount + this.freqBuffer[i]);
            }
            this.docUpto += next - this.docBufferUpto + 1;
            this.docBufferUpto = next + 1;
            this.position = 0;
            return this.doc;
        }

        private void skipPositions() throws IOException {
            int toSkip = this.posPendingCount - this.freq;
            int leftInBlock = 128 - this.posBufferUpto;
            if (toSkip < leftInBlock) {
                this.posBufferUpto += toSkip;
            } else {
                toSkip -= leftInBlock;
                while (toSkip >= 128) {
                    assert (this.posIn.getFilePointer() != this.lastPosBlockFP);
                    this.pforUtil.skip(this.posIn);
                    toSkip -= 128;
                }
                this.refillPositions();
                this.posBufferUpto = toSkip;
            }
            this.position = 0;
        }

        @Override
        public int nextPosition() throws IOException {
            assert (this.posPendingCount > 0);
            if (this.posPendingFP != -1L) {
                this.posIn.seek(this.posPendingFP);
                this.posPendingFP = -1L;
                this.posBufferUpto = 128;
            }
            if (this.posPendingCount > this.freq) {
                this.skipPositions();
                this.posPendingCount = this.freq;
            }
            if (this.posBufferUpto == 128) {
                this.refillPositions();
                this.posBufferUpto = 0;
            }
            this.position = (int)((long)this.position + this.posDeltaBuffer[this.posBufferUpto++]);
            --this.posPendingCount;
            return this.position;
        }

        @Override
        public int startOffset() {
            return -1;
        }

        @Override
        public int endOffset() {
            return -1;
        }

        @Override
        public BytesRef getPayload() {
            return null;
        }

        @Override
        public long cost() {
            return this.docFreq;
        }
    }

    final class BlockImpactsDocsEnum
    extends ImpactsEnum {
        final PForUtil pforUtil = new PForUtil(new ForUtil());
        private final long[] docBuffer = new long[129];
        private final long[] freqBuffer = new long[128];
        private int docBufferUpto;
        private final Lucene90ScoreSkipReader skipper;
        final IndexInput docIn;
        final boolean indexHasFreqs;
        private int docFreq;
        private int blockUpto;
        private int doc;
        private long accum;
        private int nextSkipDoc = -1;
        private long seekTo = -1L;
        private boolean isFreqsRead;

        public BlockImpactsDocsEnum(FieldInfo fieldInfo, Lucene90PostingsFormat.IntBlockTermState termState) throws IOException {
            this.indexHasFreqs = fieldInfo.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS) >= 0;
            boolean indexHasPositions = fieldInfo.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0;
            boolean indexHasOffsets = fieldInfo.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) >= 0;
            boolean indexHasPayloads = fieldInfo.hasPayloads();
            this.docIn = Lucene90PostingsReader.this.docIn.clone();
            this.docFreq = termState.docFreq;
            this.docIn.seek(termState.docStartFP);
            this.doc = -1;
            this.accum = 0L;
            this.blockUpto = 0;
            this.docBufferUpto = 128;
            this.skipper = new Lucene90ScoreSkipReader(this.docIn.clone(), 10, indexHasPositions, indexHasOffsets, indexHasPayloads);
            this.skipper.init(termState.docStartFP + termState.skipOffset, termState.docStartFP, termState.posStartFP, termState.payStartFP, this.docFreq);
            this.docBuffer[128] = Integer.MAX_VALUE;
            this.isFreqsRead = true;
            if (!this.indexHasFreqs) {
                Arrays.fill(this.freqBuffer, 1L);
            }
        }

        @Override
        public int freq() throws IOException {
            if (!this.isFreqsRead) {
                this.pforUtil.decode(this.docIn, this.freqBuffer);
                this.isFreqsRead = true;
            }
            return (int)this.freqBuffer[this.docBufferUpto - 1];
        }

        @Override
        public int docID() {
            return this.doc;
        }

        private void refillDocs() throws IOException {
            if (!this.isFreqsRead) {
                this.pforUtil.skip(this.docIn);
                this.isFreqsRead = true;
            }
            int left = this.docFreq - this.blockUpto;
            assert (left >= 0);
            if (left >= 128) {
                this.pforUtil.decodeAndPrefixSum(this.docIn, this.accum, this.docBuffer);
                if (this.indexHasFreqs) {
                    this.pforUtil.decode(this.docIn, this.freqBuffer);
                }
                this.blockUpto += 128;
            } else {
                Lucene90PostingsReader.readVIntBlock(this.docIn, this.docBuffer, this.freqBuffer, left, this.indexHasFreqs);
                Lucene90PostingsReader.prefixSum(this.docBuffer, left, this.accum);
                this.docBuffer[left] = Integer.MAX_VALUE;
                this.blockUpto += left;
            }
            this.accum = this.docBuffer[127];
            this.docBufferUpto = 0;
            assert (this.docBuffer[128] == Integer.MAX_VALUE);
        }

        @Override
        public void advanceShallow(int target) throws IOException {
            if (target > this.nextSkipDoc) {
                int newDocUpto = this.skipper.skipTo(target) + 1;
                if (newDocUpto >= this.blockUpto) {
                    assert (newDocUpto % 128 == 0) : "got " + newDocUpto;
                    this.blockUpto = newDocUpto;
                    this.docBufferUpto = 128;
                    this.accum = this.skipper.getDoc();
                    this.seekTo = this.skipper.getDocPointer();
                }
                this.nextSkipDoc = this.skipper.getNextSkipDoc();
            }
            assert (this.nextSkipDoc >= target);
        }

        @Override
        public Impacts getImpacts() throws IOException {
            this.advanceShallow(this.doc);
            return this.skipper.getImpacts();
        }

        @Override
        public int nextDoc() throws IOException {
            return this.advance(this.doc + 1);
        }

        @Override
        public int advance(int target) throws IOException {
            if (target > this.nextSkipDoc) {
                this.advanceShallow(target);
            }
            if (this.docBufferUpto == 128) {
                if (this.seekTo >= 0L) {
                    this.docIn.seek(this.seekTo);
                    this.isFreqsRead = true;
                    this.seekTo = -1L;
                }
                this.refillDocs();
            }
            int next = Lucene90PostingsReader.findFirstGreater(this.docBuffer, target, this.docBufferUpto);
            this.doc = (int)this.docBuffer[next];
            this.docBufferUpto = next + 1;
            return this.doc;
        }

        @Override
        public int nextPosition() throws IOException {
            return -1;
        }

        @Override
        public int startOffset() {
            return -1;
        }

        @Override
        public int endOffset() {
            return -1;
        }

        @Override
        public BytesRef getPayload() {
            return null;
        }

        @Override
        public long cost() {
            return this.docFreq;
        }
    }

    final class EverythingEnum
    extends PostingsEnum {
        final PForUtil pforUtil = new PForUtil(new ForUtil());
        private final long[] docBuffer = new long[129];
        private final long[] freqBuffer = new long[129];
        private final long[] posDeltaBuffer = new long[128];
        private final long[] payloadLengthBuffer;
        private final long[] offsetStartDeltaBuffer;
        private final long[] offsetLengthBuffer;
        private byte[] payloadBytes;
        private int payloadByteUpto;
        private int payloadLength;
        private int lastStartOffset;
        private int startOffset;
        private int endOffset;
        private int docBufferUpto;
        private int posBufferUpto;
        private Lucene90SkipReader skipper;
        private boolean skipped;
        final IndexInput startDocIn;
        IndexInput docIn;
        final IndexInput posIn;
        final IndexInput payIn;
        final BytesRef payload;
        final boolean indexHasOffsets;
        final boolean indexHasPayloads;
        private int docFreq;
        private long totalTermFreq;
        private int blockUpto;
        private int doc;
        private long accum;
        private int freq;
        private int position;
        private int posPendingCount;
        private long posPendingFP;
        private long payPendingFP;
        private long docTermStartFP;
        private long posTermStartFP;
        private long payTermStartFP;
        private long lastPosBlockFP;
        private long skipOffset;
        private int nextSkipDoc;
        private boolean needsOffsets;
        private boolean needsPayloads;
        private int singletonDocID;

        public EverythingEnum(FieldInfo fieldInfo) throws IOException {
            this.indexHasOffsets = fieldInfo.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) >= 0;
            this.indexHasPayloads = fieldInfo.hasPayloads();
            this.startDocIn = Lucene90PostingsReader.this.docIn;
            this.docIn = null;
            this.posIn = Lucene90PostingsReader.this.posIn.clone();
            this.payIn = this.indexHasOffsets || this.indexHasPayloads ? Lucene90PostingsReader.this.payIn.clone() : null;
            if (this.indexHasOffsets) {
                this.offsetStartDeltaBuffer = new long[128];
                this.offsetLengthBuffer = new long[128];
            } else {
                this.offsetStartDeltaBuffer = null;
                this.offsetLengthBuffer = null;
                this.startOffset = -1;
                this.endOffset = -1;
            }
            if (this.indexHasPayloads) {
                this.payloadLengthBuffer = new long[128];
                this.payloadBytes = new byte[128];
                this.payload = new BytesRef();
            } else {
                this.payloadLengthBuffer = null;
                this.payloadBytes = null;
                this.payload = null;
            }
            this.docBuffer[128] = Integer.MAX_VALUE;
        }

        public boolean canReuse(IndexInput docIn, FieldInfo fieldInfo) {
            return docIn == this.startDocIn && this.indexHasOffsets == fieldInfo.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) >= 0 && this.indexHasPayloads == fieldInfo.hasPayloads();
        }

        public EverythingEnum reset(Lucene90PostingsFormat.IntBlockTermState termState, int flags) throws IOException {
            this.docFreq = termState.docFreq;
            this.docTermStartFP = termState.docStartFP;
            this.posTermStartFP = termState.posStartFP;
            this.payTermStartFP = termState.payStartFP;
            this.skipOffset = termState.skipOffset;
            this.totalTermFreq = termState.totalTermFreq;
            this.singletonDocID = termState.singletonDocID;
            if (this.docFreq > 1) {
                if (this.docIn == null) {
                    this.docIn = this.startDocIn.clone();
                }
                this.docIn.seek(this.docTermStartFP);
            }
            this.posPendingFP = this.posTermStartFP;
            this.payPendingFP = this.payTermStartFP;
            this.posPendingCount = 0;
            this.lastPosBlockFP = termState.totalTermFreq < 128L ? this.posTermStartFP : (termState.totalTermFreq == 128L ? -1L : this.posTermStartFP + termState.lastPosBlockOffset);
            this.needsOffsets = PostingsEnum.featureRequested(flags, (short)56);
            this.needsPayloads = PostingsEnum.featureRequested(flags, (short)88);
            this.doc = -1;
            this.accum = 0L;
            this.blockUpto = 0;
            this.nextSkipDoc = this.docFreq > 128 ? 127 : Integer.MAX_VALUE;
            this.docBufferUpto = 128;
            this.skipped = false;
            return this;
        }

        @Override
        public int freq() throws IOException {
            return this.freq;
        }

        @Override
        public int docID() {
            return this.doc;
        }

        private void refillDocs() throws IOException {
            int left = this.docFreq - this.blockUpto;
            assert (left >= 0);
            if (left >= 128) {
                this.pforUtil.decodeAndPrefixSum(this.docIn, this.accum, this.docBuffer);
                this.pforUtil.decode(this.docIn, this.freqBuffer);
                this.blockUpto += 128;
            } else if (this.docFreq == 1) {
                this.docBuffer[0] = this.singletonDocID;
                this.freqBuffer[0] = this.totalTermFreq;
                this.docBuffer[1] = Integer.MAX_VALUE;
                ++this.blockUpto;
            } else {
                Lucene90PostingsReader.readVIntBlock(this.docIn, this.docBuffer, this.freqBuffer, left, true);
                Lucene90PostingsReader.prefixSum(this.docBuffer, left, this.accum);
                this.docBuffer[left] = Integer.MAX_VALUE;
                this.blockUpto += left;
            }
            this.accum = this.docBuffer[127];
            this.docBufferUpto = 0;
            assert (this.docBuffer[128] == Integer.MAX_VALUE);
        }

        private void refillPositions() throws IOException {
            if (this.posIn.getFilePointer() == this.lastPosBlockFP) {
                int count = (int)(this.totalTermFreq % 128L);
                int payloadLength = 0;
                int offsetLength = 0;
                this.payloadByteUpto = 0;
                for (int i = 0; i < count; ++i) {
                    int code = this.posIn.readVInt();
                    if (this.indexHasPayloads) {
                        if ((code & 1) != 0) {
                            payloadLength = this.posIn.readVInt();
                        }
                        this.payloadLengthBuffer[i] = payloadLength;
                        this.posDeltaBuffer[i] = code >>> 1;
                        if (payloadLength != 0) {
                            if (this.payloadByteUpto + payloadLength > this.payloadBytes.length) {
                                this.payloadBytes = ArrayUtil.grow(this.payloadBytes, this.payloadByteUpto + payloadLength);
                            }
                            this.posIn.readBytes(this.payloadBytes, this.payloadByteUpto, payloadLength);
                            this.payloadByteUpto += payloadLength;
                        }
                    } else {
                        this.posDeltaBuffer[i] = code;
                    }
                    if (!this.indexHasOffsets) continue;
                    int deltaCode = this.posIn.readVInt();
                    if ((deltaCode & 1) != 0) {
                        offsetLength = this.posIn.readVInt();
                    }
                    this.offsetStartDeltaBuffer[i] = deltaCode >>> 1;
                    this.offsetLengthBuffer[i] = offsetLength;
                }
                this.payloadByteUpto = 0;
            } else {
                this.pforUtil.decode(this.posIn, this.posDeltaBuffer);
                if (this.indexHasPayloads) {
                    if (this.needsPayloads) {
                        this.pforUtil.decode(this.payIn, this.payloadLengthBuffer);
                        int numBytes = this.payIn.readVInt();
                        if (numBytes > this.payloadBytes.length) {
                            this.payloadBytes = ArrayUtil.grow(this.payloadBytes, numBytes);
                        }
                        this.payIn.readBytes(this.payloadBytes, 0, numBytes);
                    } else {
                        this.pforUtil.skip(this.payIn);
                        int numBytes = this.payIn.readVInt();
                        this.payIn.seek(this.payIn.getFilePointer() + (long)numBytes);
                    }
                    this.payloadByteUpto = 0;
                }
                if (this.indexHasOffsets) {
                    if (this.needsOffsets) {
                        this.pforUtil.decode(this.payIn, this.offsetStartDeltaBuffer);
                        this.pforUtil.decode(this.payIn, this.offsetLengthBuffer);
                    } else {
                        this.pforUtil.skip(this.payIn);
                        this.pforUtil.skip(this.payIn);
                    }
                }
            }
        }

        @Override
        public int nextDoc() throws IOException {
            if (this.docBufferUpto == 128) {
                this.refillDocs();
            }
            this.doc = (int)this.docBuffer[this.docBufferUpto];
            this.freq = (int)this.freqBuffer[this.docBufferUpto];
            this.posPendingCount += this.freq;
            ++this.docBufferUpto;
            this.position = 0;
            this.lastStartOffset = 0;
            return this.doc;
        }

        @Override
        public int advance(int target) throws IOException {
            long doc;
            if (target > this.nextSkipDoc) {
                int newDocUpto;
                if (this.skipper == null) {
                    this.skipper = new Lucene90SkipReader(this.docIn.clone(), 10, true, this.indexHasOffsets, this.indexHasPayloads);
                }
                if (!this.skipped) {
                    assert (this.skipOffset != -1L);
                    this.skipper.init(this.docTermStartFP + this.skipOffset, this.docTermStartFP, this.posTermStartFP, this.payTermStartFP, this.docFreq);
                    this.skipped = true;
                }
                if ((newDocUpto = this.skipper.skipTo(target) + 1) > this.blockUpto - 128 + this.docBufferUpto) {
                    assert (newDocUpto % 128 == 0) : "got " + newDocUpto;
                    this.blockUpto = newDocUpto;
                    this.docBufferUpto = 128;
                    this.accum = this.skipper.getDoc();
                    this.docIn.seek(this.skipper.getDocPointer());
                    this.posPendingFP = this.skipper.getPosPointer();
                    this.payPendingFP = this.skipper.getPayPointer();
                    this.posPendingCount = this.skipper.getPosBufferUpto();
                    this.lastStartOffset = 0;
                    this.payloadByteUpto = this.skipper.getPayloadByteUpto();
                }
                this.nextSkipDoc = this.skipper.getNextSkipDoc();
            }
            if (this.docBufferUpto == 128) {
                this.refillDocs();
            }
            do {
                doc = this.docBuffer[this.docBufferUpto];
                this.freq = (int)this.freqBuffer[this.docBufferUpto];
                this.posPendingCount += this.freq;
                ++this.docBufferUpto;
            } while (doc < (long)target);
            this.position = 0;
            this.lastStartOffset = 0;
            this.doc = (int)doc;
            return this.doc;
        }

        private void skipPositions() throws IOException {
            int toSkip = this.posPendingCount - this.freq;
            int leftInBlock = 128 - this.posBufferUpto;
            if (toSkip < leftInBlock) {
                int end = this.posBufferUpto + toSkip;
                while (this.posBufferUpto < end) {
                    if (this.indexHasPayloads) {
                        this.payloadByteUpto = (int)((long)this.payloadByteUpto + this.payloadLengthBuffer[this.posBufferUpto]);
                    }
                    ++this.posBufferUpto;
                }
            } else {
                toSkip -= leftInBlock;
                while (toSkip >= 128) {
                    assert (this.posIn.getFilePointer() != this.lastPosBlockFP);
                    this.pforUtil.skip(this.posIn);
                    if (this.indexHasPayloads) {
                        this.pforUtil.skip(this.payIn);
                        int numBytes = this.payIn.readVInt();
                        this.payIn.seek(this.payIn.getFilePointer() + (long)numBytes);
                    }
                    if (this.indexHasOffsets) {
                        this.pforUtil.skip(this.payIn);
                        this.pforUtil.skip(this.payIn);
                    }
                    toSkip -= 128;
                }
                this.refillPositions();
                this.payloadByteUpto = 0;
                this.posBufferUpto = 0;
                while (this.posBufferUpto < toSkip) {
                    if (this.indexHasPayloads) {
                        this.payloadByteUpto = (int)((long)this.payloadByteUpto + this.payloadLengthBuffer[this.posBufferUpto]);
                    }
                    ++this.posBufferUpto;
                }
            }
            this.position = 0;
            this.lastStartOffset = 0;
        }

        @Override
        public int nextPosition() throws IOException {
            assert (this.posPendingCount > 0);
            if (this.posPendingFP != -1L) {
                this.posIn.seek(this.posPendingFP);
                this.posPendingFP = -1L;
                if (this.payPendingFP != -1L && this.payIn != null) {
                    this.payIn.seek(this.payPendingFP);
                    this.payPendingFP = -1L;
                }
                this.posBufferUpto = 128;
            }
            if (this.posPendingCount > this.freq) {
                this.skipPositions();
                this.posPendingCount = this.freq;
            }
            if (this.posBufferUpto == 128) {
                this.refillPositions();
                this.posBufferUpto = 0;
            }
            this.position = (int)((long)this.position + this.posDeltaBuffer[this.posBufferUpto]);
            if (this.indexHasPayloads) {
                this.payloadLength = (int)this.payloadLengthBuffer[this.posBufferUpto];
                this.payload.bytes = this.payloadBytes;
                this.payload.offset = this.payloadByteUpto;
                this.payload.length = this.payloadLength;
                this.payloadByteUpto += this.payloadLength;
            }
            if (this.indexHasOffsets) {
                this.startOffset = this.lastStartOffset + (int)this.offsetStartDeltaBuffer[this.posBufferUpto];
                this.endOffset = this.startOffset + (int)this.offsetLengthBuffer[this.posBufferUpto];
                this.lastStartOffset = this.startOffset;
            }
            ++this.posBufferUpto;
            --this.posPendingCount;
            return this.position;
        }

        @Override
        public int startOffset() {
            return this.startOffset;
        }

        @Override
        public int endOffset() {
            return this.endOffset;
        }

        @Override
        public BytesRef getPayload() {
            if (this.payloadLength == 0) {
                return null;
            }
            return this.payload;
        }

        @Override
        public long cost() {
            return this.docFreq;
        }
    }

    final class BlockDocsEnum
    extends PostingsEnum {
        final PForUtil pforUtil = new PForUtil(new ForUtil());
        private final long[] docBuffer = new long[129];
        private final long[] freqBuffer = new long[128];
        private int docBufferUpto;
        private Lucene90SkipReader skipper;
        private boolean skipped;
        final IndexInput startDocIn;
        IndexInput docIn;
        final boolean indexHasFreq;
        final boolean indexHasPos;
        final boolean indexHasOffsets;
        final boolean indexHasPayloads;
        private int docFreq;
        private long totalTermFreq;
        private int blockUpto;
        private int doc;
        private long accum;
        private long docTermStartFP;
        private long skipOffset;
        private int nextSkipDoc;
        private boolean needsFreq;
        private boolean isFreqsRead;
        private int singletonDocID;

        public BlockDocsEnum(FieldInfo fieldInfo) throws IOException {
            this.startDocIn = Lucene90PostingsReader.this.docIn;
            this.docIn = null;
            this.indexHasFreq = fieldInfo.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS) >= 0;
            this.indexHasPos = fieldInfo.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0;
            this.indexHasOffsets = fieldInfo.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) >= 0;
            this.indexHasPayloads = fieldInfo.hasPayloads();
            this.docBuffer[128] = Integer.MAX_VALUE;
        }

        public boolean canReuse(IndexInput docIn, FieldInfo fieldInfo) {
            return docIn == this.startDocIn && this.indexHasFreq == fieldInfo.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS) >= 0 && this.indexHasPos == fieldInfo.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0 && this.indexHasPayloads == fieldInfo.hasPayloads();
        }

        public PostingsEnum reset(Lucene90PostingsFormat.IntBlockTermState termState, int flags) throws IOException {
            this.docFreq = termState.docFreq;
            this.totalTermFreq = this.indexHasFreq ? termState.totalTermFreq : (long)this.docFreq;
            this.docTermStartFP = termState.docStartFP;
            this.skipOffset = termState.skipOffset;
            this.singletonDocID = termState.singletonDocID;
            if (this.docFreq > 1) {
                if (this.docIn == null) {
                    this.docIn = this.startDocIn.clone();
                }
                this.docIn.seek(this.docTermStartFP);
            }
            this.doc = -1;
            this.needsFreq = PostingsEnum.featureRequested(flags, (short)8);
            this.isFreqsRead = true;
            if (!this.indexHasFreq || !this.needsFreq) {
                for (int i = 0; i < 128; ++i) {
                    this.freqBuffer[i] = 1L;
                }
            }
            this.accum = 0L;
            this.blockUpto = 0;
            this.nextSkipDoc = 127;
            this.docBufferUpto = 128;
            this.skipped = false;
            return this;
        }

        @Override
        public int freq() throws IOException {
            if (!this.isFreqsRead) {
                this.pforUtil.decode(this.docIn, this.freqBuffer);
                this.isFreqsRead = true;
            }
            return (int)this.freqBuffer[this.docBufferUpto - 1];
        }

        @Override
        public int nextPosition() throws IOException {
            return -1;
        }

        @Override
        public int startOffset() throws IOException {
            return -1;
        }

        @Override
        public int endOffset() throws IOException {
            return -1;
        }

        @Override
        public BytesRef getPayload() throws IOException {
            return null;
        }

        @Override
        public int docID() {
            return this.doc;
        }

        private void refillDocs() throws IOException {
            if (!this.isFreqsRead) {
                this.pforUtil.skip(this.docIn);
                this.isFreqsRead = true;
            }
            int left = this.docFreq - this.blockUpto;
            assert (left >= 0);
            if (left >= 128) {
                this.pforUtil.decodeAndPrefixSum(this.docIn, this.accum, this.docBuffer);
                if (this.indexHasFreq) {
                    if (this.needsFreq) {
                        this.isFreqsRead = false;
                    } else {
                        this.pforUtil.skip(this.docIn);
                    }
                }
                this.blockUpto += 128;
            } else if (this.docFreq == 1) {
                this.docBuffer[0] = this.singletonDocID;
                this.freqBuffer[0] = this.totalTermFreq;
                this.docBuffer[1] = Integer.MAX_VALUE;
                ++this.blockUpto;
            } else {
                Lucene90PostingsReader.readVIntBlock(this.docIn, this.docBuffer, this.freqBuffer, left, this.indexHasFreq);
                Lucene90PostingsReader.prefixSum(this.docBuffer, left, this.accum);
                this.docBuffer[left] = Integer.MAX_VALUE;
                this.blockUpto += left;
            }
            this.accum = this.docBuffer[127];
            this.docBufferUpto = 0;
            assert (this.docBuffer[128] == Integer.MAX_VALUE);
        }

        @Override
        public int nextDoc() throws IOException {
            if (this.docBufferUpto == 128) {
                this.refillDocs();
            }
            this.doc = (int)this.docBuffer[this.docBufferUpto];
            ++this.docBufferUpto;
            return this.doc;
        }

        @Override
        public int advance(int target) throws IOException {
            long doc;
            if (this.docFreq > 128 && target > this.nextSkipDoc) {
                int newDocUpto;
                if (this.skipper == null) {
                    this.skipper = new Lucene90SkipReader(this.docIn.clone(), 10, this.indexHasPos, this.indexHasOffsets, this.indexHasPayloads);
                }
                if (!this.skipped) {
                    assert (this.skipOffset != -1L);
                    this.skipper.init(this.docTermStartFP + this.skipOffset, this.docTermStartFP, 0L, 0L, this.docFreq);
                    this.skipped = true;
                }
                if ((newDocUpto = this.skipper.skipTo(target) + 1) >= this.blockUpto) {
                    assert (newDocUpto % 128 == 0) : "got " + newDocUpto;
                    this.blockUpto = newDocUpto;
                    this.docBufferUpto = 128;
                    this.accum = this.skipper.getDoc();
                    this.docIn.seek(this.skipper.getDocPointer());
                    this.isFreqsRead = true;
                }
                this.nextSkipDoc = this.skipper.getNextSkipDoc();
            }
            if (this.docBufferUpto == 128) {
                this.refillDocs();
            }
            while ((doc = this.docBuffer[this.docBufferUpto]) < (long)target) {
                ++this.docBufferUpto;
            }
            ++this.docBufferUpto;
            this.doc = (int)doc;
            return this.doc;
        }

        @Override
        public long cost() {
            return this.docFreq;
        }
    }
}

