/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.codecs.lucene90;

import java.io.IOException;
import org.graylog.shaded.opensearch2.org.apache.lucene.codecs.CodecUtil;
import org.graylog.shaded.opensearch2.org.apache.lucene.codecs.CompoundDirectory;
import org.graylog.shaded.opensearch2.org.apache.lucene.codecs.CompoundFormat;
import org.graylog.shaded.opensearch2.org.apache.lucene.codecs.lucene90.Lucene90CompoundReader;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.IndexFileNames;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.SegmentInfo;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.ChecksumIndexInput;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.Directory;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.IOContext;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.IndexOutput;

public final class Lucene90CompoundFormat
extends CompoundFormat {
    static final String DATA_EXTENSION = "cfs";
    static final String ENTRIES_EXTENSION = "cfe";
    static final String DATA_CODEC = "Lucene90CompoundData";
    static final String ENTRY_CODEC = "Lucene90CompoundEntries";
    static final int VERSION_START = 0;
    static final int VERSION_CURRENT = 0;

    @Override
    public CompoundDirectory getCompoundReader(Directory dir, SegmentInfo si, IOContext context) throws IOException {
        return new Lucene90CompoundReader(dir, si, context);
    }

    @Override
    public void write(Directory dir, SegmentInfo si, IOContext context) throws IOException {
        String dataFile = IndexFileNames.segmentFileName(si.name, "", DATA_EXTENSION);
        String entriesFile = IndexFileNames.segmentFileName(si.name, "", ENTRIES_EXTENSION);
        try (IndexOutput data = dir.createOutput(dataFile, context);
             IndexOutput entries = dir.createOutput(entriesFile, context);){
            CodecUtil.writeIndexHeader(data, DATA_CODEC, 0, si.getId(), "");
            CodecUtil.writeIndexHeader(entries, ENTRY_CODEC, 0, si.getId(), "");
            this.writeCompoundFile(entries, data, dir, si);
            CodecUtil.writeFooter(data);
            CodecUtil.writeFooter(entries);
        }
    }

    private void writeCompoundFile(IndexOutput entries, IndexOutput data, Directory dir, SegmentInfo si) throws IOException {
        entries.writeVInt(si.files().size());
        for (String file : si.files()) {
            long startOffset = data.alignFilePointer(8);
            try (ChecksumIndexInput in = dir.openChecksumInput(file, IOContext.READONCE);){
                CodecUtil.verifyAndCopyIndexHeader(in, data, si.getId());
                long numBytesToCopy = in.length() - (long)CodecUtil.footerLength() - in.getFilePointer();
                data.copyBytes(in, numBytesToCopy);
                long checksum = CodecUtil.checkFooter(in);
                CodecUtil.writeBEInt(data, -1071082520);
                CodecUtil.writeBEInt(data, 0);
                CodecUtil.writeBELong(data, checksum);
            }
            long endOffset = data.getFilePointer();
            long length = endOffset - startOffset;
            entries.writeString(IndexFileNames.stripSegmentName(file));
            entries.writeLong(startOffset);
            entries.writeLong(length);
        }
    }
}

