/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.codecs;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.graylog.shaded.opensearch2.org.apache.lucene.codecs.KnnVectorsReader;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.DocIDMerger;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.FieldInfo;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.MergeState;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.VectorValues;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.TopDocs;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.Bits;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.BytesRef;

public abstract class KnnVectorsWriter
implements Closeable {
    protected KnnVectorsWriter() {
    }

    public abstract void writeField(FieldInfo var1, KnnVectorsReader var2) throws IOException;

    public abstract void finish() throws IOException;

    public void merge(final MergeState mergeState) throws IOException {
        for (int i = 0; i < mergeState.fieldInfos.length; ++i) {
            KnnVectorsReader reader = mergeState.knnVectorsReaders[i];
            assert (reader != null || !mergeState.fieldInfos[i].hasVectorValues());
            if (reader == null) continue;
            reader.checkIntegrity();
        }
        for (final FieldInfo fieldInfo : mergeState.mergeFieldInfos) {
            if (!fieldInfo.hasVectorValues()) continue;
            if (mergeState.infoStream.isEnabled("VV")) {
                mergeState.infoStream.message("VV", "merging " + mergeState.segmentInfo);
            }
            this.writeField(fieldInfo, new KnnVectorsReader(){

                @Override
                public long ramBytesUsed() {
                    return 0L;
                }

                @Override
                public void close() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void checkIntegrity() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public VectorValues getVectorValues(String field) throws IOException {
                    return MergedVectorValues.mergeVectorValues(fieldInfo, mergeState);
                }

                @Override
                public TopDocs search(String field, float[] target, int k, Bits acceptDocs, int visitedLimit) {
                    throw new UnsupportedOperationException();
                }
            });
            if (!mergeState.infoStream.isEnabled("VV")) continue;
            mergeState.infoStream.message("VV", "merge done " + mergeState.segmentInfo);
        }
        this.finish();
    }

    private static class MergedVectorValues
    extends VectorValues {
        private final List<VectorValuesSub> subs;
        private final DocIDMerger<VectorValuesSub> docIdMerger;
        private final int cost;
        private final int size;
        private int docId;
        private VectorValuesSub current;

        static MergedVectorValues mergeVectorValues(FieldInfo fieldInfo, MergeState mergeState) throws IOException {
            assert (fieldInfo != null && fieldInfo.hasVectorValues());
            ArrayList<VectorValuesSub> subs = new ArrayList<VectorValuesSub>();
            for (int i = 0; i < mergeState.knnVectorsReaders.length; ++i) {
                VectorValues values;
                KnnVectorsReader knnVectorsReader = mergeState.knnVectorsReaders[i];
                if (knnVectorsReader == null || (values = knnVectorsReader.getVectorValues(fieldInfo.name)) == null) continue;
                subs.add(new VectorValuesSub(mergeState.docMaps[i], values));
            }
            return new MergedVectorValues(subs, mergeState);
        }

        private MergedVectorValues(List<VectorValuesSub> subs, MergeState mergeState) throws IOException {
            this.subs = subs;
            this.docIdMerger = DocIDMerger.of(subs, mergeState.needsIndexSort);
            int totalCost = 0;
            int totalSize = 0;
            for (VectorValuesSub sub : subs) {
                totalCost = (int)((long)totalCost + sub.values.cost());
                totalSize += sub.values.size();
            }
            this.cost = totalCost;
            this.size = totalSize;
            this.docId = -1;
        }

        @Override
        public int docID() {
            return this.docId;
        }

        @Override
        public int nextDoc() throws IOException {
            this.current = this.docIdMerger.next();
            this.docId = this.current == null ? Integer.MAX_VALUE : this.current.mappedDocID;
            return this.docId;
        }

        @Override
        public float[] vectorValue() throws IOException {
            return this.current.values.vectorValue();
        }

        @Override
        public BytesRef binaryValue() throws IOException {
            return this.current.values.binaryValue();
        }

        @Override
        public int advance(int target) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public long cost() {
            return this.cost;
        }

        @Override
        public int dimension() {
            return this.subs.get((int)0).values.dimension();
        }
    }

    private static class VectorValuesSub
    extends DocIDMerger.Sub {
        final VectorValues values;

        VectorValuesSub(MergeState.DocMap docMap, VectorValues values) {
            super(docMap);
            this.values = values;
            assert (values.docID() == -1);
        }

        @Override
        public int nextDoc() throws IOException {
            return this.values.nextDoc();
        }
    }
}

