/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.codecs;

import java.util.Objects;
import java.util.Set;
import org.graylog.shaded.opensearch2.org.apache.lucene.codecs.CompoundFormat;
import org.graylog.shaded.opensearch2.org.apache.lucene.codecs.DocValuesFormat;
import org.graylog.shaded.opensearch2.org.apache.lucene.codecs.FieldInfosFormat;
import org.graylog.shaded.opensearch2.org.apache.lucene.codecs.KnnVectorsFormat;
import org.graylog.shaded.opensearch2.org.apache.lucene.codecs.LiveDocsFormat;
import org.graylog.shaded.opensearch2.org.apache.lucene.codecs.NormsFormat;
import org.graylog.shaded.opensearch2.org.apache.lucene.codecs.PointsFormat;
import org.graylog.shaded.opensearch2.org.apache.lucene.codecs.PostingsFormat;
import org.graylog.shaded.opensearch2.org.apache.lucene.codecs.SegmentInfoFormat;
import org.graylog.shaded.opensearch2.org.apache.lucene.codecs.StoredFieldsFormat;
import org.graylog.shaded.opensearch2.org.apache.lucene.codecs.TermVectorsFormat;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.NamedSPILoader;

public abstract class Codec
implements NamedSPILoader.NamedSPI {
    private final String name;

    protected Codec(String name) {
        NamedSPILoader.checkServiceName(name);
        this.name = name;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    public abstract PostingsFormat postingsFormat();

    public abstract DocValuesFormat docValuesFormat();

    public abstract StoredFieldsFormat storedFieldsFormat();

    public abstract TermVectorsFormat termVectorsFormat();

    public abstract FieldInfosFormat fieldInfosFormat();

    public abstract SegmentInfoFormat segmentInfoFormat();

    public abstract NormsFormat normsFormat();

    public abstract LiveDocsFormat liveDocsFormat();

    public abstract CompoundFormat compoundFormat();

    public abstract PointsFormat pointsFormat();

    public abstract KnnVectorsFormat knnVectorsFormat();

    public static Codec forName(String name) {
        return Holder.getLoader().lookup(name);
    }

    public static Set<String> availableCodecs() {
        return Holder.getLoader().availableServices();
    }

    public static void reloadCodecs(ClassLoader classloader) {
        Holder.getLoader().reload(classloader);
    }

    public static Codec getDefault() {
        if (Holder.defaultCodec == null) {
            throw new IllegalStateException("You tried to lookup the default Codec before all Codecs could be initialized. This likely happens if you try to get it from a Codec's ctor.");
        }
        return Holder.defaultCodec;
    }

    public static void setDefault(Codec codec) {
        Holder.defaultCodec = Objects.requireNonNull(codec);
    }

    public String toString() {
        return this.name;
    }

    private static final class Holder {
        private static final NamedSPILoader<Codec> LOADER = new NamedSPILoader<Codec>(Codec.class);
        static Codec defaultCodec = LOADER.lookup("Lucene91");

        private Holder() {
        }

        static NamedSPILoader<Codec> getLoader() {
            if (LOADER == null) {
                throw new IllegalStateException("You tried to lookup a Codec by name before all Codecs could be initialized. This likely happens if you call Codec#forName from a Codec's ctor.");
            }
            return LOADER;
        }
    }
}

