/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.backward_codecs.store;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.IndexInput;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.RandomAccessInput;

final class EndiannessReverserIndexInput
extends IndexInput {
    final IndexInput in;

    EndiannessReverserIndexInput(IndexInput in) {
        super("Endianness reverser Index Input wrapper");
        this.in = in;
    }

    @Override
    public byte readByte() throws IOException {
        return this.in.readByte();
    }

    @Override
    public void readBytes(byte[] b, int offset, int len) throws IOException {
        this.in.readBytes(b, offset, len);
    }

    @Override
    public void readBytes(byte[] b, int offset, int len, boolean useBuffer) throws IOException {
        this.in.readBytes(b, offset, len, useBuffer);
    }

    @Override
    public short readShort() throws IOException {
        return Short.reverseBytes(this.in.readShort());
    }

    @Override
    public int readInt() throws IOException {
        return Integer.reverseBytes(this.in.readInt());
    }

    @Override
    public int readVInt() throws IOException {
        return this.in.readVInt();
    }

    @Override
    public int readZInt() throws IOException {
        return this.in.readZInt();
    }

    @Override
    public long readLong() throws IOException {
        return Long.reverseBytes(this.in.readLong());
    }

    @Override
    public void readLongs(long[] dst, int offset, int length) throws IOException {
        this.in.readLongs(dst, offset, length);
        for (int i = 0; i < length; ++i) {
            dst[offset + i] = Long.reverseBytes(dst[offset + i]);
        }
    }

    @Override
    public void readFloats(float[] dst, int offset, int length) throws IOException {
        this.in.readFloats(dst, offset, length);
        for (int i = 0; i < length; ++i) {
            dst[offset + i] = Float.intBitsToFloat(Integer.reverseBytes(Float.floatToRawIntBits(dst[offset + i])));
        }
    }

    @Override
    public long readVLong() throws IOException {
        return this.in.readVLong();
    }

    @Override
    public long readZLong() throws IOException {
        return this.in.readZLong();
    }

    @Override
    public String readString() throws IOException {
        return this.in.readString();
    }

    @Override
    public IndexInput clone() {
        return new EndiannessReverserIndexInput(this.in.clone());
    }

    @Override
    public IndexInput slice(String sliceDescription, long offset, long length) throws IOException {
        return new EndiannessReverserIndexInput(this.in.slice(sliceDescription, offset, length));
    }

    @Override
    public Map<String, String> readMapOfStrings() throws IOException {
        return this.in.readMapOfStrings();
    }

    @Override
    public Set<String> readSetOfStrings() throws IOException {
        return this.in.readSetOfStrings();
    }

    @Override
    public void skipBytes(long numBytes) throws IOException {
        this.in.skipBytes(numBytes);
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public long getFilePointer() {
        return this.in.getFilePointer();
    }

    @Override
    public void seek(long pos) throws IOException {
        this.in.seek(pos);
    }

    @Override
    public long length() {
        return this.in.length();
    }

    @Override
    public String toString() {
        return this.in.toString();
    }

    @Override
    public RandomAccessInput randomAccessSlice(long offset, long length) throws IOException {
        return new EndiannessReverserRandomAccessInput(this.in.randomAccessSlice(offset, length));
    }

    public static class EndiannessReverserRandomAccessInput
    implements RandomAccessInput {
        private final RandomAccessInput in;

        public EndiannessReverserRandomAccessInput(RandomAccessInput in) {
            this.in = in;
        }

        @Override
        public byte readByte(long pos) throws IOException {
            return this.in.readByte(pos);
        }

        @Override
        public short readShort(long pos) throws IOException {
            return Short.reverseBytes(this.in.readShort(pos));
        }

        @Override
        public int readInt(long pos) throws IOException {
            return Integer.reverseBytes(this.in.readInt(pos));
        }

        @Override
        public long readLong(long pos) throws IOException {
            return Long.reverseBytes(this.in.readLong(pos));
        }
    }
}

