/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.backward_codecs.lucene87;

import java.util.Objects;
import org.graylog.shaded.opensearch2.org.apache.lucene.backward_codecs.lucene50.Lucene50CompoundFormat;
import org.graylog.shaded.opensearch2.org.apache.lucene.backward_codecs.lucene50.Lucene50LiveDocsFormat;
import org.graylog.shaded.opensearch2.org.apache.lucene.backward_codecs.lucene50.Lucene50TermVectorsFormat;
import org.graylog.shaded.opensearch2.org.apache.lucene.backward_codecs.lucene60.Lucene60FieldInfosFormat;
import org.graylog.shaded.opensearch2.org.apache.lucene.backward_codecs.lucene80.Lucene80DocValuesFormat;
import org.graylog.shaded.opensearch2.org.apache.lucene.backward_codecs.lucene80.Lucene80NormsFormat;
import org.graylog.shaded.opensearch2.org.apache.lucene.backward_codecs.lucene84.Lucene84PostingsFormat;
import org.graylog.shaded.opensearch2.org.apache.lucene.backward_codecs.lucene86.Lucene86PointsFormat;
import org.graylog.shaded.opensearch2.org.apache.lucene.backward_codecs.lucene86.Lucene86SegmentInfoFormat;
import org.graylog.shaded.opensearch2.org.apache.lucene.backward_codecs.lucene87.Lucene87StoredFieldsFormat;
import org.graylog.shaded.opensearch2.org.apache.lucene.codecs.Codec;
import org.graylog.shaded.opensearch2.org.apache.lucene.codecs.CompoundFormat;
import org.graylog.shaded.opensearch2.org.apache.lucene.codecs.DocValuesFormat;
import org.graylog.shaded.opensearch2.org.apache.lucene.codecs.FieldInfosFormat;
import org.graylog.shaded.opensearch2.org.apache.lucene.codecs.KnnVectorsFormat;
import org.graylog.shaded.opensearch2.org.apache.lucene.codecs.LiveDocsFormat;
import org.graylog.shaded.opensearch2.org.apache.lucene.codecs.NormsFormat;
import org.graylog.shaded.opensearch2.org.apache.lucene.codecs.PointsFormat;
import org.graylog.shaded.opensearch2.org.apache.lucene.codecs.PostingsFormat;
import org.graylog.shaded.opensearch2.org.apache.lucene.codecs.SegmentInfoFormat;
import org.graylog.shaded.opensearch2.org.apache.lucene.codecs.StoredFieldsFormat;
import org.graylog.shaded.opensearch2.org.apache.lucene.codecs.TermVectorsFormat;
import org.graylog.shaded.opensearch2.org.apache.lucene.codecs.perfield.PerFieldDocValuesFormat;
import org.graylog.shaded.opensearch2.org.apache.lucene.codecs.perfield.PerFieldPostingsFormat;

public class Lucene87Codec
extends Codec {
    private final TermVectorsFormat vectorsFormat = new Lucene50TermVectorsFormat();
    private final FieldInfosFormat fieldInfosFormat = new Lucene60FieldInfosFormat();
    private final SegmentInfoFormat segmentInfosFormat = new Lucene86SegmentInfoFormat();
    private final LiveDocsFormat liveDocsFormat = new Lucene50LiveDocsFormat();
    private final CompoundFormat compoundFormat = new Lucene50CompoundFormat();
    private final PointsFormat pointsFormat = new Lucene86PointsFormat();
    private final PostingsFormat defaultFormat;
    private final PostingsFormat postingsFormat = new PerFieldPostingsFormat(){

        @Override
        public PostingsFormat getPostingsFormatForField(String field) {
            return Lucene87Codec.this.getPostingsFormatForField(field);
        }
    };
    private final DocValuesFormat docValuesFormat = new PerFieldDocValuesFormat(){

        @Override
        public DocValuesFormat getDocValuesFormatForField(String field) {
            return Lucene87Codec.this.getDocValuesFormatForField(field);
        }
    };
    private final StoredFieldsFormat storedFieldsFormat;
    private final DocValuesFormat defaultDVFormat;
    private final NormsFormat normsFormat = new Lucene80NormsFormat();

    public Lucene87Codec() {
        this(Mode.BEST_COMPRESSION);
    }

    public Lucene87Codec(Mode mode) {
        super("Lucene87");
        this.storedFieldsFormat = new Lucene87StoredFieldsFormat(mode.storedMode);
        this.defaultFormat = new Lucene84PostingsFormat();
        this.defaultDVFormat = new Lucene80DocValuesFormat(mode.dvMode);
    }

    @Override
    public StoredFieldsFormat storedFieldsFormat() {
        return this.storedFieldsFormat;
    }

    @Override
    public TermVectorsFormat termVectorsFormat() {
        return this.vectorsFormat;
    }

    @Override
    public PostingsFormat postingsFormat() {
        return this.postingsFormat;
    }

    @Override
    public final FieldInfosFormat fieldInfosFormat() {
        return this.fieldInfosFormat;
    }

    @Override
    public SegmentInfoFormat segmentInfoFormat() {
        return this.segmentInfosFormat;
    }

    @Override
    public final LiveDocsFormat liveDocsFormat() {
        return this.liveDocsFormat;
    }

    @Override
    public CompoundFormat compoundFormat() {
        return this.compoundFormat;
    }

    @Override
    public PointsFormat pointsFormat() {
        return this.pointsFormat;
    }

    @Override
    public final KnnVectorsFormat knnVectorsFormat() {
        return KnnVectorsFormat.EMPTY;
    }

    public PostingsFormat getPostingsFormatForField(String field) {
        return this.defaultFormat;
    }

    public DocValuesFormat getDocValuesFormatForField(String field) {
        return this.defaultDVFormat;
    }

    @Override
    public final DocValuesFormat docValuesFormat() {
        return this.docValuesFormat;
    }

    @Override
    public NormsFormat normsFormat() {
        return this.normsFormat;
    }

    public static enum Mode {
        BEST_SPEED(Lucene87StoredFieldsFormat.Mode.BEST_SPEED, Lucene80DocValuesFormat.Mode.BEST_SPEED),
        BEST_COMPRESSION(Lucene87StoredFieldsFormat.Mode.BEST_COMPRESSION, Lucene80DocValuesFormat.Mode.BEST_COMPRESSION);

        protected final Lucene87StoredFieldsFormat.Mode storedMode;
        protected final Lucene80DocValuesFormat.Mode dvMode;

        private Mode(Lucene87StoredFieldsFormat.Mode storedMode, Lucene80DocValuesFormat.Mode dvMode) {
            this.storedMode = Objects.requireNonNull(storedMode);
            this.dvMode = Objects.requireNonNull(dvMode);
        }
    }
}

