/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.backward_codecs.lucene40.blocktree;

import java.io.IOException;
import org.graylog.shaded.opensearch2.org.apache.lucene.backward_codecs.store.EndiannessReverserUtil;
import org.graylog.shaded.opensearch2.org.apache.lucene.store.DataInput;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.compress.LZ4;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.compress.LowercaseAsciiCompression;

enum CompressionAlgorithm {
    NO_COMPRESSION(0){

        @Override
        void read(DataInput in, byte[] out, int len) throws IOException {
            in.readBytes(out, 0, len);
        }
    }
    ,
    LOWERCASE_ASCII(1){

        @Override
        void read(DataInput in, byte[] out, int len) throws IOException {
            LowercaseAsciiCompression.decompress(in, out, len);
        }
    }
    ,
    LZ4(2){

        @Override
        void read(DataInput in, byte[] out, int len) throws IOException {
            org.graylog.shaded.opensearch2.org.apache.lucene.util.compress.LZ4.decompress(EndiannessReverserUtil.wrapDataInput(in), len, out, 0);
        }
    };

    private static final CompressionAlgorithm[] BY_CODE;
    public final int code;

    static final CompressionAlgorithm byCode(int code) {
        if (code < 0 || code >= BY_CODE.length) {
            throw new IllegalArgumentException("Illegal code for a compression algorithm: " + code);
        }
        return BY_CODE[code];
    }

    private CompressionAlgorithm(int code) {
        this.code = code;
    }

    abstract void read(DataInput var1, byte[] var2, int var3) throws IOException;

    static {
        BY_CODE = new CompressionAlgorithm[3];
        CompressionAlgorithm[] compressionAlgorithmArray = CompressionAlgorithm.values();
        int n = compressionAlgorithmArray.length;
        for (int i = 0; i < n; ++i) {
            CompressionAlgorithm alg;
            CompressionAlgorithm.BY_CODE[alg.code] = alg = compressionAlgorithmArray[i];
        }
    }
}

