/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.analysis.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.ClasspathResourceLoader;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.ModuleResourceLoader;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.ResourceLoader;

public final class FilesystemResourceLoader
implements ResourceLoader {
    private final Path baseDirectory;
    private final ResourceLoader delegate;

    public FilesystemResourceLoader(Path baseDirectory, ClassLoader delegate) {
        this(baseDirectory, new ClasspathResourceLoader(delegate));
    }

    public FilesystemResourceLoader(Path baseDirectory, Module delegate) {
        this(baseDirectory, new ModuleResourceLoader(delegate));
    }

    public FilesystemResourceLoader(Path baseDirectory, ResourceLoader delegate) {
        if (!Files.isDirectory(Objects.requireNonNull(baseDirectory), new LinkOption[0])) {
            throw new IllegalArgumentException(baseDirectory + " is not a directory");
        }
        if (delegate == null) {
            throw new IllegalArgumentException("delegate ResourceLoader may not be null");
        }
        this.baseDirectory = baseDirectory;
        this.delegate = delegate;
    }

    @Override
    public InputStream openResource(String resource) throws IOException {
        try {
            return Files.newInputStream(this.baseDirectory.resolve(resource), new OpenOption[0]);
        }
        catch (FileNotFoundException | NoSuchFileException fnfe) {
            return this.delegate.openResource(resource);
        }
    }

    @Override
    public <T> T newInstance(String cname, Class<T> expectedType) {
        return this.delegate.newInstance(cname, expectedType);
    }

    @Override
    public <T> Class<? extends T> findClass(String cname, Class<T> expectedType) {
        return this.delegate.findClass(cname, expectedType);
    }
}

