/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.analysis.miscellaneous;

import java.io.IOException;
import java.util.ArrayList;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.FilteringTokenFilter;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.TokenFilter;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.TokenStream;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.miscellaneous.DuplicateByteSequenceSpotter;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.miscellaneous.DuplicateSequenceAttribute;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.tokenattributes.TermToBytesRefAttribute;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.AttributeSource;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.BytesRef;
import org.graylog.shaded.opensearch2.org.opensearch.common.hash.MurmurHash3;

public class DeDuplicatingTokenFilter
extends FilteringTokenFilter {
    private final DuplicateSequenceAttribute seqAtt = this.addAttribute(DuplicateSequenceAttribute.class);
    private final boolean emitDuplicates;
    static final MurmurHash3.Hash128 seed = new MurmurHash3.Hash128();

    public DeDuplicatingTokenFilter(TokenStream in, DuplicateByteSequenceSpotter byteStreamDuplicateSpotter) {
        this(in, byteStreamDuplicateSpotter, false);
    }

    public DeDuplicatingTokenFilter(TokenStream in, DuplicateByteSequenceSpotter byteStreamDuplicateSpotter, boolean emitDuplicates) {
        super(new DuplicateTaggingFilter(byteStreamDuplicateSpotter, in));
        this.emitDuplicates = emitDuplicates;
    }

    @Override
    protected boolean accept() throws IOException {
        return this.emitDuplicates || this.seqAtt.getNumPriorUsesInASequence() < 1;
    }

    private static class DuplicateTaggingFilter
    extends TokenFilter {
        private final DuplicateSequenceAttribute seqAtt = this.addAttribute(DuplicateSequenceAttribute.class);
        TermToBytesRefAttribute termBytesAtt = this.addAttribute(TermToBytesRefAttribute.class);
        private DuplicateByteSequenceSpotter byteStreamDuplicateSpotter;
        private ArrayList<AttributeSource.State> allTokens;
        int pos = 0;
        private final int windowSize;

        protected DuplicateTaggingFilter(DuplicateByteSequenceSpotter byteStreamDuplicateSpotter, TokenStream input) {
            super(input);
            this.byteStreamDuplicateSpotter = byteStreamDuplicateSpotter;
            this.windowSize = 6;
        }

        @Override
        public final boolean incrementToken() throws IOException {
            if (this.allTokens == null) {
                this.loadAllTokens();
            }
            this.clearAttributes();
            if (this.pos < this.allTokens.size()) {
                AttributeSource.State earlierToken = this.allTokens.get(this.pos);
                ++this.pos;
                this.restoreState(earlierToken);
                return true;
            }
            return false;
        }

        public void loadAllTokens() throws IOException {
            int pos;
            this.allTokens = new ArrayList(256);
            this.pos = 0;
            boolean isWrapped = false;
            AttributeSource.State[] priorStatesBuffer = new AttributeSource.State[this.windowSize];
            short[] priorMaxNumSightings = new short[this.windowSize];
            int cursor = 0;
            while (this.input.incrementToken()) {
                BytesRef bytesRef = this.termBytesAtt.getBytesRef();
                long tokenHash = MurmurHash3.hash128((byte[])bytesRef.bytes, (int)bytesRef.offset, (int)bytesRef.length, (long)0L, (MurmurHash3.Hash128)DeDuplicatingTokenFilter.seed).h1;
                byte tokenByte = (byte)(tokenHash & 0xFFL);
                short numSightings = this.byteStreamDuplicateSpotter.addByte(tokenByte);
                priorStatesBuffer[cursor] = this.captureState();
                if (numSightings >= 1) {
                    int numLengthsToRecord = this.windowSize;
                    int pos2 = cursor;
                    while (numLengthsToRecord > 0) {
                        if (pos2 < 0) {
                            pos2 = this.windowSize - 1;
                        }
                        priorMaxNumSightings[pos2] = (short)Math.max(priorMaxNumSightings[pos2], numSightings);
                        --numLengthsToRecord;
                        --pos2;
                    }
                }
                if (++cursor >= this.windowSize) {
                    cursor = 0;
                    isWrapped = true;
                }
                if (!isWrapped || priorStatesBuffer[cursor] == null) continue;
                this.recordLengthInfoState(priorMaxNumSightings, priorStatesBuffer, cursor);
            }
            int n = pos = isWrapped ? this.nextAfter(cursor) : 0;
            while (pos != cursor) {
                this.recordLengthInfoState(priorMaxNumSightings, priorStatesBuffer, pos);
                pos = this.nextAfter(pos);
            }
        }

        private int nextAfter(int pos) {
            if (++pos >= this.windowSize) {
                pos = 0;
            }
            return pos;
        }

        private void recordLengthInfoState(short[] maxNumSightings, AttributeSource.State[] tokenStates, int cursor) {
            if (maxNumSightings[cursor] > 0) {
                this.restoreState(tokenStates[cursor]);
                this.seqAtt.setNumPriorUsesInASequence(maxNumSightings[cursor]);
                maxNumSightings[cursor] = 0;
                tokenStates[cursor] = this.captureState();
            }
            this.allTokens.add(tokenStates[cursor]);
        }
    }
}

