/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.analysis.miscellaneous;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.TokenFilterFactory;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.TokenStream;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.miscellaneous.ConditionalTokenFilter;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.ResourceLoader;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.ResourceLoaderAware;

public abstract class ConditionalTokenFilterFactory
extends TokenFilterFactory
implements ResourceLoaderAware {
    public static final String NAME = "conditional";
    private List<TokenFilterFactory> innerFilters;

    protected ConditionalTokenFilterFactory(Map<String, String> args) {
        super(args);
    }

    public ConditionalTokenFilterFactory() {
        throw ConditionalTokenFilterFactory.defaultCtorException();
    }

    public void setInnerFilters(List<TokenFilterFactory> innerFilters) {
        this.innerFilters = innerFilters;
    }

    @Override
    public TokenStream create(TokenStream input) {
        if (this.innerFilters == null || this.innerFilters.size() == 0) {
            return input;
        }
        Function<TokenStream, TokenStream> innerStream = ts -> {
            for (TokenFilterFactory factory : this.innerFilters) {
                ts = factory.create((TokenStream)ts);
            }
            return ts;
        };
        return this.create(input, innerStream);
    }

    @Override
    public final void inform(ResourceLoader loader) throws IOException {
        if (this.innerFilters == null) {
            return;
        }
        for (TokenFilterFactory factory : this.innerFilters) {
            if (!(factory instanceof ResourceLoaderAware)) continue;
            ((ResourceLoaderAware)((Object)factory)).inform(loader);
        }
        this.doInform(loader);
    }

    protected void doInform(ResourceLoader loader) throws IOException {
    }

    protected abstract ConditionalTokenFilter create(TokenStream var1, Function<TokenStream, TokenStream> var2);
}

