/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.apache.lucene.analysis.charfilter;

import java.io.Reader;
import java.util.Arrays;
import org.graylog.shaded.opensearch2.org.apache.lucene.analysis.CharFilter;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.ArrayUtil;

public abstract class BaseCharFilter
extends CharFilter {
    private int[] offsets;
    private int[] diffs;
    private int size = 0;

    public BaseCharFilter(Reader in) {
        super(in);
    }

    @Override
    protected int correct(int currentOff) {
        if (this.offsets == null) {
            return currentOff;
        }
        int index = Arrays.binarySearch(this.offsets, 0, this.size, currentOff);
        if (index < -1) {
            index = -2 - index;
        }
        int diff = index < 0 ? 0 : this.diffs[index];
        return currentOff + diff;
    }

    protected int getLastCumulativeDiff() {
        return this.offsets == null ? 0 : this.diffs[this.size - 1];
    }

    protected void addOffCorrectMap(int off, int cumulativeDiff) {
        if (this.offsets == null) {
            this.offsets = new int[64];
            this.diffs = new int[64];
        } else if (this.size == this.offsets.length) {
            this.offsets = ArrayUtil.grow(this.offsets);
            this.diffs = ArrayUtil.grow(this.diffs);
        }
        assert (this.size == 0 || off >= this.offsets[this.size - 1]) : "Offset #" + this.size + "(" + off + ") is less than the last recorded offset " + this.offsets[this.size - 1] + "\n" + Arrays.toString(this.offsets) + "\n" + Arrays.toString(this.diffs);
        if (this.size == 0 || off != this.offsets[this.size - 1]) {
            this.offsets[this.size] = off;
            this.diffs[this.size++] = cumulativeDiff;
        } else {
            this.diffs[this.size - 1] = cumulativeDiff;
        }
    }
}

