/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.com.sun.jna.win32;

import java.lang.reflect.Method;
import org.graylog.shaded.opensearch2.com.sun.jna.Function;
import org.graylog.shaded.opensearch2.com.sun.jna.FunctionMapper;
import org.graylog.shaded.opensearch2.com.sun.jna.Native;
import org.graylog.shaded.opensearch2.com.sun.jna.NativeLibrary;
import org.graylog.shaded.opensearch2.com.sun.jna.NativeMapped;
import org.graylog.shaded.opensearch2.com.sun.jna.NativeMappedConverter;

public class StdCallFunctionMapper
implements FunctionMapper {
    protected int getArgumentNativeStackSize(Class<?> cls) {
        if (NativeMapped.class.isAssignableFrom(cls)) {
            cls = NativeMappedConverter.getInstance(cls).nativeType();
        }
        if (cls.isArray()) {
            return Native.POINTER_SIZE;
        }
        try {
            return Native.getNativeSize(cls);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Unknown native stack allocation size for " + cls);
        }
    }

    @Override
    public String getFunctionName(NativeLibrary library, Method method) {
        Class<?>[] argTypes;
        String name = method.getName();
        int pop = 0;
        for (Class<?> cls : argTypes = method.getParameterTypes()) {
            pop += this.getArgumentNativeStackSize(cls);
        }
        String decorated = name + "@" + pop;
        int conv = 63;
        try {
            Function func = library.getFunction(decorated, conv);
            name = func.getName();
        }
        catch (UnsatisfiedLinkError e) {
            try {
                Function func = library.getFunction("_" + decorated, conv);
                name = func.getName();
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                // empty catch block
            }
        }
        return name;
    }
}

