/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.com.github.mustachejava.reflect;

import java.io.Writer;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.graylog.shaded.opensearch2.com.github.mustachejava.Binding;
import org.graylog.shaded.opensearch2.com.github.mustachejava.Code;
import org.graylog.shaded.opensearch2.com.github.mustachejava.Iteration;
import org.graylog.shaded.opensearch2.com.github.mustachejava.ObjectHandler;
import org.graylog.shaded.opensearch2.com.github.mustachejava.TemplateContext;

public abstract class BaseObjectHandler
implements ObjectHandler {
    @Override
    public Object coerce(Object object) {
        if (object instanceof Optional) {
            Optional optional = (Optional)object;
            if (optional.isPresent()) {
                return this.coerce(optional.get());
            }
            return null;
        }
        return object;
    }

    @Override
    public Writer falsey(Iteration iteration, Writer writer, Object object, List<Object> scopes) {
        if (object != null) {
            if (object instanceof Boolean) {
                if (((Boolean)object).booleanValue()) {
                    return writer;
                }
            } else if (object instanceof String) {
                if (!object.toString().equals("")) {
                    return writer;
                }
            } else if (object instanceof List) {
                List list = (List)object;
                int length = list.size();
                if (length > 0) {
                    return writer;
                }
            } else if (object instanceof Iterable) {
                Iterable iterable = (Iterable)object;
                if (iterable.iterator().hasNext()) {
                    return writer;
                }
            } else if (object instanceof Iterator) {
                Iterator iterator = (Iterator)object;
                if (iterator.hasNext()) {
                    return writer;
                }
            } else if (object.getClass().isArray()) {
                int length = Array.getLength(object);
                if (length > 0) {
                    return writer;
                }
            } else {
                return writer;
            }
        }
        return iteration.next(writer, object, scopes);
    }

    @Override
    public abstract Binding createBinding(String var1, TemplateContext var2, Code var3);

    @Override
    public Writer iterate(Iteration iteration, Writer writer, Object object, List<Object> scopes) {
        if (object == null) {
            return writer;
        }
        if (object instanceof Boolean && !((Boolean)object).booleanValue()) {
            return writer;
        }
        if (object instanceof String && object.toString().equals("")) {
            return writer;
        }
        if (object instanceof List) {
            List list = (List)object;
            int length = list.size();
            for (int i = 0; i < length; ++i) {
                writer = iteration.next(writer, this.coerce(list.get(i)), scopes);
            }
        } else if (object instanceof Iterable) {
            for (Object next : (Iterable)object) {
                writer = iteration.next(writer, this.coerce(next), scopes);
            }
        } else if (object instanceof Iterator) {
            Iterator iterator = (Iterator)object;
            while (iterator.hasNext()) {
                writer = iteration.next(writer, this.coerce(iterator.next()), scopes);
            }
        } else if (object.getClass().isArray()) {
            int length = Array.getLength(object);
            for (int i = 0; i < length; ++i) {
                writer = iteration.next(writer, this.coerce(Array.get(object, i)), scopes);
            }
        } else {
            writer = iteration.next(writer, object, scopes);
        }
        return writer;
    }

    protected Field getField(Class aClass, String name) throws NoSuchFieldException {
        Field member;
        try {
            member = aClass.getDeclaredField(name);
        }
        catch (NoSuchFieldException nsfe) {
            Class superclass = aClass.getSuperclass();
            if (superclass != null && superclass != Object.class) {
                return this.getField(superclass, name);
            }
            throw nsfe;
        }
        this.checkField(member);
        member.setAccessible(true);
        return member;
    }

    protected Method getMethod(Class<?> aClass, String name, Class<?> ... params) throws NoSuchMethodException {
        Method member;
        try {
            member = aClass.getMethod(name, params);
            if (member.getDeclaringClass() == Object.class) {
                throw new NoSuchMethodException();
            }
        }
        catch (NoSuchMethodException nsme) {
            try {
                member = aClass.getDeclaredMethod(name, params);
            }
            catch (NoSuchMethodException nsme2) {
                Class<?> superclass = aClass.getSuperclass();
                if (superclass != null && superclass != Object.class) {
                    return this.getMethod(superclass, name, new Class[0]);
                }
                throw nsme2;
            }
        }
        this.checkMethod(member);
        member.setAccessible(true);
        return member;
    }

    protected AccessibleObject findMember(Class sClass, String name) {
        if (String.class == sClass && "value".equals(name)) {
            return null;
        }
        if (this.checkClass(sClass)) {
            AccessibleObject ao;
            for (Class<?> anInterface : sClass.getInterfaces()) {
                AccessibleObject member = this.findMember(anInterface, name);
                if (member == null) continue;
                return member;
            }
            Class superclass = sClass.getSuperclass();
            if (superclass != null && superclass != Object.class && (ao = this.findMember(superclass, name)) != null) {
                return ao;
            }
        }
        return this.findMemberOnClass(sClass, name);
    }

    private AccessibleObject findMemberOnClass(Class sClass, String name) {
        AccessibleObject ao;
        try {
            ao = this.getMethod(sClass, name, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            String propertyname = name.substring(0, 1).toUpperCase() + (name.length() > 1 ? name.substring(1) : "");
            try {
                ao = this.getMethod(sClass, "get" + propertyname, new Class[0]);
            }
            catch (NoSuchMethodException e2) {
                try {
                    ao = this.getMethod(sClass, "is" + propertyname, new Class[0]);
                }
                catch (NoSuchMethodException e3) {
                    try {
                        ao = this.getField(sClass, name);
                    }
                    catch (NoSuchFieldException e4) {
                        ao = null;
                    }
                }
            }
        }
        return ao;
    }

    protected void checkMethod(Method member) throws NoSuchMethodException {
        if ((member.getModifiers() & 2) == 2) {
            throw new NoSuchMethodException("Only public, protected and package members allowed");
        }
    }

    protected void checkField(Field member) throws NoSuchFieldException {
        if ((member.getModifiers() & 2) == 2) {
            throw new NoSuchFieldException("Only public, protected and package members allowed");
        }
    }

    protected boolean checkClass(Class sClass) {
        return (sClass.getModifiers() & 1) != 1;
    }

    @Override
    public String stringify(Object object) {
        return object.toString();
    }
}

