/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.com.carrotsearch.hppc;

import org.graylog.shaded.opensearch2.com.carrotsearch.hppc.BitMixer;
import org.graylog.shaded.opensearch2.com.carrotsearch.hppc.HashOrderMixing;
import org.graylog.shaded.opensearch2.com.carrotsearch.hppc.HashOrderMixingStrategy;
import org.graylog.shaded.opensearch2.com.carrotsearch.hppc.ObjectObjectAssociativeContainer;
import org.graylog.shaded.opensearch2.com.carrotsearch.hppc.ObjectObjectHashMap;
import org.graylog.shaded.opensearch2.com.carrotsearch.hppc.cursors.ObjectObjectCursor;

public class ObjectObjectIdentityHashMap<KType, VType>
extends ObjectObjectHashMap<KType, VType> {
    public ObjectObjectIdentityHashMap() {
        this(4);
    }

    public ObjectObjectIdentityHashMap(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public ObjectObjectIdentityHashMap(int expectedElements, double loadFactor) {
        this(expectedElements, loadFactor, HashOrderMixing.randomized());
    }

    public ObjectObjectIdentityHashMap(int expectedElements, double loadFactor, HashOrderMixingStrategy orderMixer) {
        this.orderMixer = orderMixer;
        this.loadFactor = this.verifyLoadFactor(loadFactor);
        this.ensureCapacity(expectedElements);
    }

    public ObjectObjectIdentityHashMap(ObjectObjectAssociativeContainer<? extends KType, ? extends VType> container) {
        this(container.size());
        this.putAll(container);
    }

    @Override
    public int hashKey(KType key) {
        assert (key != null);
        return BitMixer.mix(System.identityHashCode(key), this.keyMixer);
    }

    @Override
    public boolean equals(Object v1, Object v2) {
        return v1 == v2;
    }

    @Override
    protected boolean equalElements(ObjectObjectHashMap<?, ?> other) {
        if (other.size() != this.size()) {
            return false;
        }
        for (ObjectObjectCursor<?, ?> objectObjectCursor : other) {
            Object key = objectObjectCursor.key;
            if (this.containsKey(key) && this.equals(this.get(key), objectObjectCursor.value)) continue;
            return false;
        }
        return true;
    }

    public static <KType, VType> ObjectObjectIdentityHashMap<KType, VType> from(KType[] keys, VType[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        ObjectObjectIdentityHashMap<KType, VType> map = new ObjectObjectIdentityHashMap<KType, VType>(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }
}

