/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.com.carrotsearch.hppc;

import java.util.Arrays;
import java.util.Iterator;
import org.graylog.shaded.opensearch2.com.carrotsearch.hppc.AbstractIterator;
import org.graylog.shaded.opensearch2.com.carrotsearch.hppc.AbstractLongCollection;
import org.graylog.shaded.opensearch2.com.carrotsearch.hppc.ArraySizingStrategy;
import org.graylog.shaded.opensearch2.com.carrotsearch.hppc.BitMixer;
import org.graylog.shaded.opensearch2.com.carrotsearch.hppc.BoundedProportionalArraySizingStrategy;
import org.graylog.shaded.opensearch2.com.carrotsearch.hppc.BufferAllocationException;
import org.graylog.shaded.opensearch2.com.carrotsearch.hppc.LongArrayList;
import org.graylog.shaded.opensearch2.com.carrotsearch.hppc.LongContainer;
import org.graylog.shaded.opensearch2.com.carrotsearch.hppc.LongDeque;
import org.graylog.shaded.opensearch2.com.carrotsearch.hppc.Preallocable;
import org.graylog.shaded.opensearch2.com.carrotsearch.hppc.cursors.LongCursor;
import org.graylog.shaded.opensearch2.com.carrotsearch.hppc.predicates.LongPredicate;
import org.graylog.shaded.opensearch2.com.carrotsearch.hppc.procedures.LongProcedure;

public class LongArrayDeque
extends AbstractLongCollection
implements LongDeque,
Preallocable,
Cloneable {
    public long[] buffer = LongArrayList.EMPTY_ARRAY;
    public int head;
    public int tail;
    protected final ArraySizingStrategy resizer;

    public LongArrayDeque() {
        this(4);
    }

    public LongArrayDeque(int expectedElements) {
        this(expectedElements, new BoundedProportionalArraySizingStrategy());
    }

    public LongArrayDeque(int expectedElements, ArraySizingStrategy resizer) {
        assert (resizer != null);
        this.resizer = resizer;
        this.ensureCapacity(expectedElements);
    }

    public LongArrayDeque(LongContainer container) {
        this(container.size());
        this.addLast(container);
    }

    @Override
    public void addFirst(long e1) {
        int h = LongArrayDeque.oneLeft(this.head, this.buffer.length);
        if (h == this.tail) {
            this.ensureBufferSpace(1);
            h = LongArrayDeque.oneLeft(this.head, this.buffer.length);
        }
        this.head = h;
        this.buffer[this.head] = e1;
    }

    public final void addFirst(long ... elements) {
        this.ensureBufferSpace(elements.length);
        for (long k : elements) {
            this.addFirst(k);
        }
    }

    public int addFirst(LongContainer container) {
        int size = container.size();
        this.ensureBufferSpace(size);
        for (LongCursor cursor : container) {
            this.addFirst(cursor.value);
        }
        return size;
    }

    public int addFirst(Iterable<? extends LongCursor> iterable) {
        int size = 0;
        for (LongCursor longCursor : iterable) {
            this.addFirst(longCursor.value);
            ++size;
        }
        return size;
    }

    @Override
    public void addLast(long e1) {
        int t = LongArrayDeque.oneRight(this.tail, this.buffer.length);
        if (this.head == t) {
            this.ensureBufferSpace(1);
            t = LongArrayDeque.oneRight(this.tail, this.buffer.length);
        }
        this.buffer[this.tail] = e1;
        this.tail = t;
    }

    public final void addLast(long ... elements) {
        this.ensureBufferSpace(1);
        for (long k : elements) {
            this.addLast(k);
        }
    }

    public int addLast(LongContainer container) {
        int size = container.size();
        this.ensureBufferSpace(size);
        for (LongCursor cursor : container) {
            this.addLast(cursor.value);
        }
        return size;
    }

    public int addLast(Iterable<? extends LongCursor> iterable) {
        int size = 0;
        for (LongCursor longCursor : iterable) {
            this.addLast(longCursor.value);
            ++size;
        }
        return size;
    }

    @Override
    public long removeFirst() {
        assert (this.size() > 0) : "The deque is empty.";
        long result = this.buffer[this.head];
        this.buffer[this.head] = 0L;
        this.head = LongArrayDeque.oneRight(this.head, this.buffer.length);
        return result;
    }

    @Override
    public long removeLast() {
        assert (this.size() > 0) : "The deque is empty.";
        this.tail = LongArrayDeque.oneLeft(this.tail, this.buffer.length);
        long result = this.buffer[this.tail];
        this.buffer[this.tail] = 0L;
        return result;
    }

    @Override
    public long getFirst() {
        assert (this.size() > 0) : "The deque is empty.";
        return this.buffer[this.head];
    }

    @Override
    public long getLast() {
        assert (this.size() > 0) : "The deque is empty.";
        return this.buffer[LongArrayDeque.oneLeft(this.tail, this.buffer.length)];
    }

    @Override
    public int removeFirst(long e1) {
        int index = this.bufferIndexOf(e1);
        if (index >= 0) {
            this.removeAtBufferIndex(index);
        }
        return index;
    }

    public int bufferIndexOf(long e1) {
        int last = this.tail;
        int bufLen = this.buffer.length;
        int i = this.head;
        while (i != last) {
            if (this.buffer[i] == e1) {
                return i;
            }
            i = LongArrayDeque.oneRight(i, bufLen);
        }
        return -1;
    }

    @Override
    public int removeLast(long e1) {
        int index = this.lastBufferIndexOf(e1);
        if (index >= 0) {
            this.removeAtBufferIndex(index);
        }
        return index;
    }

    public int lastBufferIndexOf(long e1) {
        int bufLen = this.buffer.length;
        int last = LongArrayDeque.oneLeft(this.head, bufLen);
        int i = LongArrayDeque.oneLeft(this.tail, bufLen);
        while (i != last) {
            if (this.buffer[i] == e1) {
                return i;
            }
            i = LongArrayDeque.oneLeft(i, bufLen);
        }
        return -1;
    }

    @Override
    public int removeAll(long e1) {
        int to;
        int removed = 0;
        int last = this.tail;
        int bufLen = this.buffer.length;
        int from = to = this.head;
        while (from != last) {
            if (this.buffer[from] == e1) {
                this.buffer[from] = 0L;
                ++removed;
            } else {
                if (to != from) {
                    this.buffer[to] = this.buffer[from];
                    this.buffer[from] = 0L;
                }
                to = LongArrayDeque.oneRight(to, bufLen);
            }
            from = LongArrayDeque.oneRight(from, bufLen);
        }
        this.tail = to;
        return removed;
    }

    public void removeAtBufferIndex(int index) {
        int rightChunk;
        assert (this.head > this.tail ? index >= this.head || index < this.tail : index >= this.head && index < this.tail) : "Index out of range (head=" + this.head + ", tail=" + this.tail + ", index=" + index + ").";
        long[] buffer = this.buffer;
        int bufLen = buffer.length;
        int lastIndex = bufLen - 1;
        int head = this.head;
        int tail = this.tail;
        int leftChunk = Math.abs(index - head) % bufLen;
        if (leftChunk < (rightChunk = Math.abs(tail - index) % bufLen)) {
            if (index >= head) {
                System.arraycopy(buffer, head, buffer, head + 1, leftChunk);
            } else {
                System.arraycopy(buffer, 0, buffer, 1, index);
                buffer[0] = buffer[lastIndex];
                System.arraycopy(buffer, head, buffer, head + 1, lastIndex - head);
            }
            buffer[head] = 0L;
            this.head = LongArrayDeque.oneRight(head, bufLen);
        } else {
            if (index < tail) {
                System.arraycopy(buffer, index + 1, buffer, index, rightChunk);
            } else {
                System.arraycopy(buffer, index + 1, buffer, index, lastIndex - index);
                buffer[lastIndex] = buffer[0];
                System.arraycopy(buffer, 1, buffer, 0, tail);
            }
            buffer[tail] = 0L;
            this.tail = LongArrayDeque.oneLeft(tail, bufLen);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int size() {
        if (this.head <= this.tail) {
            return this.tail - this.head;
        }
        return this.tail - this.head + this.buffer.length;
    }

    @Override
    public void clear() {
        if (this.head < this.tail) {
            Arrays.fill(this.buffer, this.head, this.tail, 0L);
        } else {
            Arrays.fill(this.buffer, 0, this.tail, 0L);
            Arrays.fill(this.buffer, this.head, this.buffer.length, 0L);
        }
        this.tail = 0;
        this.head = 0;
    }

    @Override
    public void release() {
        this.tail = 0;
        this.head = 0;
        this.buffer = LongArrayList.EMPTY_ARRAY;
        this.ensureBufferSpace(0);
    }

    @Override
    public void ensureCapacity(int expectedElements) {
        this.ensureBufferSpace(expectedElements - this.size());
    }

    protected void ensureBufferSpace(int expectedAdditions) {
        int bufferLen = this.buffer.length;
        int elementsCount = this.size();
        if (elementsCount + expectedAdditions >= bufferLen) {
            boolean emptySlot = true;
            int newSize = this.resizer.grow(bufferLen, elementsCount + 1, expectedAdditions);
            assert (newSize >= elementsCount + expectedAdditions + 1) : "Resizer failed to return sensible new size: " + newSize + " <= " + (elementsCount + expectedAdditions);
            try {
                long[] newBuffer = new long[newSize];
                if (bufferLen > 0) {
                    this.toArray(newBuffer);
                    this.tail = elementsCount;
                    this.head = 0;
                }
                this.buffer = newBuffer;
            }
            catch (OutOfMemoryError e) {
                throw new BufferAllocationException("Not enough memory to allocate new buffers: %,d -> %,d", (Throwable)e, bufferLen, newSize);
            }
        }
    }

    @Override
    public long[] toArray() {
        int size = this.size();
        return this.toArray(new long[size]);
    }

    public long[] toArray(long[] target) {
        assert (target.length >= this.size()) : "Target array must be >= " + this.size();
        if (this.head < this.tail) {
            System.arraycopy(this.buffer, this.head, target, 0, this.size());
        } else if (this.head > this.tail) {
            int rightCount = this.buffer.length - this.head;
            System.arraycopy(this.buffer, this.head, target, 0, rightCount);
            System.arraycopy(this.buffer, 0, target, rightCount, this.tail);
        }
        return target;
    }

    public LongArrayDeque clone() {
        try {
            LongArrayDeque cloned = (LongArrayDeque)super.clone();
            cloned.buffer = (long[])this.buffer.clone();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    protected static int oneLeft(int index, int modulus) {
        if (index >= 1) {
            return index - 1;
        }
        return modulus - 1;
    }

    protected static int oneRight(int index, int modulus) {
        if (index + 1 == modulus) {
            return 0;
        }
        return index + 1;
    }

    @Override
    public Iterator<LongCursor> iterator() {
        return new ValueIterator();
    }

    @Override
    public Iterator<LongCursor> descendingIterator() {
        return new DescendingValueIterator();
    }

    @Override
    public <T extends LongProcedure> T forEach(T procedure) {
        this.forEach(procedure, this.head, this.tail);
        return procedure;
    }

    private void forEach(LongProcedure procedure, int fromIndex, int toIndex) {
        long[] buffer = this.buffer;
        int i = fromIndex;
        while (i != toIndex) {
            procedure.apply(buffer[i]);
            i = LongArrayDeque.oneRight(i, buffer.length);
        }
    }

    @Override
    public <T extends LongPredicate> T forEach(T predicate) {
        int fromIndex = this.head;
        int toIndex = this.tail;
        long[] buffer = this.buffer;
        int i = fromIndex;
        while (i != toIndex && predicate.apply(buffer[i])) {
            i = LongArrayDeque.oneRight(i, buffer.length);
        }
        return predicate;
    }

    @Override
    public <T extends LongProcedure> T descendingForEach(T procedure) {
        this.descendingForEach(procedure, this.head, this.tail);
        return procedure;
    }

    private void descendingForEach(LongProcedure procedure, int fromIndex, int toIndex) {
        if (fromIndex == toIndex) {
            return;
        }
        long[] buffer = this.buffer;
        int i = toIndex;
        do {
            i = LongArrayDeque.oneLeft(i, buffer.length);
            procedure.apply(buffer[i]);
        } while (i != fromIndex);
    }

    @Override
    public <T extends LongPredicate> T descendingForEach(T predicate) {
        this.descendingForEach(predicate, this.head, this.tail);
        return predicate;
    }

    private void descendingForEach(LongPredicate predicate, int fromIndex, int toIndex) {
        if (fromIndex == toIndex) {
            return;
        }
        long[] buffer = this.buffer;
        int i = toIndex;
        while (predicate.apply(buffer[i = LongArrayDeque.oneLeft(i, buffer.length)]) && i != fromIndex) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int removeAll(LongPredicate predicate) {
        int to;
        long[] buffer = this.buffer;
        int last = this.tail;
        int bufLen = buffer.length;
        int removed = 0;
        int from = to = this.head;
        try {
            from = to = this.head;
            while (from != last) {
                if (predicate.apply(buffer[from])) {
                    buffer[from] = 0L;
                    ++removed;
                } else {
                    if (to != from) {
                        buffer[to] = buffer[from];
                        buffer[from] = 0L;
                    }
                    to = LongArrayDeque.oneRight(to, bufLen);
                }
                from = LongArrayDeque.oneRight(from, bufLen);
            }
        }
        finally {
            while (from != last) {
                if (to != from) {
                    buffer[to] = buffer[from];
                    buffer[from] = 0L;
                }
                to = LongArrayDeque.oneRight(to, bufLen);
                from = LongArrayDeque.oneRight(from, bufLen);
            }
            this.tail = to;
        }
        return removed;
    }

    @Override
    public boolean contains(long e) {
        int fromIndex = this.head;
        int toIndex = this.tail;
        long[] buffer = this.buffer;
        int i = fromIndex;
        while (i != toIndex) {
            if (buffer[i] == e) {
                return true;
            }
            i = LongArrayDeque.oneRight(i, buffer.length);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        int fromIndex = this.head;
        int toIndex = this.tail;
        long[] buffer = this.buffer;
        int i = fromIndex;
        while (i != toIndex) {
            h = 31 * h + BitMixer.mix(this.buffer[i]);
            i = LongArrayDeque.oneRight(i, buffer.length);
        }
        return h;
    }

    public boolean equals(Object obj) {
        return obj != null && this.getClass() == obj.getClass() && this.equalElements((LongArrayDeque)this.getClass().cast(obj));
    }

    protected boolean equalElements(LongArrayDeque other) {
        int max = this.size();
        if (other.size() != max) {
            return false;
        }
        Iterator<LongCursor> i1 = this.iterator();
        Iterator<LongCursor> i2 = other.iterator();
        while (i1.hasNext() && i2.hasNext()) {
            if (i2.next().value == i1.next().value) continue;
            return false;
        }
        return !i1.hasNext() && !i2.hasNext();
    }

    public static LongArrayDeque from(long ... elements) {
        LongArrayDeque coll = new LongArrayDeque(elements.length);
        coll.addLast(elements);
        return coll;
    }

    private final class DescendingValueIterator
    extends AbstractIterator<LongCursor> {
        private final LongCursor cursor = new LongCursor();
        private int remaining;

        public DescendingValueIterator() {
            this.cursor.index = LongArrayDeque.this.tail;
            this.remaining = LongArrayDeque.this.size();
        }

        @Override
        protected LongCursor fetch() {
            if (this.remaining == 0) {
                return (LongCursor)this.done();
            }
            --this.remaining;
            this.cursor.index = LongArrayDeque.oneLeft(this.cursor.index, LongArrayDeque.this.buffer.length);
            this.cursor.value = LongArrayDeque.this.buffer[this.cursor.index];
            return this.cursor;
        }
    }

    private final class ValueIterator
    extends AbstractIterator<LongCursor> {
        private final LongCursor cursor = new LongCursor();
        private int remaining;

        public ValueIterator() {
            this.cursor.index = LongArrayDeque.oneLeft(LongArrayDeque.this.head, LongArrayDeque.this.buffer.length);
            this.remaining = LongArrayDeque.this.size();
        }

        @Override
        protected LongCursor fetch() {
            if (this.remaining == 0) {
                return (LongCursor)this.done();
            }
            --this.remaining;
            this.cursor.index = LongArrayDeque.oneRight(this.cursor.index, LongArrayDeque.this.buffer.length);
            this.cursor.value = LongArrayDeque.this.buffer[this.cursor.index];
            return this.cursor;
        }
    }
}

