/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.reactor.core.publisher;

import java.util.Objects;
import java.util.function.Function;
import org.graylog.shaded.opensearch2.org.reactivestreams.Publisher;
import org.graylog.shaded.opensearch2.reactor.core.CoreSubscriber;
import org.graylog.shaded.opensearch2.reactor.core.Scannable;
import org.graylog.shaded.opensearch2.reactor.core.publisher.Flux;
import org.graylog.shaded.opensearch2.reactor.core.publisher.FluxFromMonoOperator;
import org.graylog.shaded.opensearch2.reactor.core.publisher.FluxRepeatWhen;
import org.graylog.shaded.opensearch2.reactor.core.publisher.Mono;
import org.graylog.shaded.opensearch2.reactor.core.publisher.Operators;

final class MonoRepeatWhen<T>
extends FluxFromMonoOperator<T, T> {
    final Function<? super Flux<Long>, ? extends Publisher<?>> whenSourceFactory;

    MonoRepeatWhen(Mono<? extends T> source, Function<? super Flux<Long>, ? extends Publisher<?>> whenSourceFactory) {
        super(source);
        this.whenSourceFactory = Objects.requireNonNull(whenSourceFactory, "whenSourceFactory");
    }

    @Override
    public CoreSubscriber<? super T> subscribeOrReturn(CoreSubscriber<? super T> actual) {
        Publisher<?> p;
        FluxRepeatWhen.RepeatWhenOtherSubscriber other = new FluxRepeatWhen.RepeatWhenOtherSubscriber();
        CoreSubscriber<T> serial = Operators.serialize(actual);
        FluxRepeatWhen.RepeatWhenMainSubscriber<? super T> main = new FluxRepeatWhen.RepeatWhenMainSubscriber<T>(serial, other.completionSignal, this.source);
        other.main = main;
        serial.onSubscribe(main);
        try {
            p = Objects.requireNonNull(this.whenSourceFactory.apply(other), "The whenSourceFactory returned a null Publisher");
        }
        catch (Throwable e) {
            actual.onError(Operators.onOperatorError(e, actual.currentContext()));
            return null;
        }
        p.subscribe(other);
        if (!main.cancelled) {
            return main;
        }
        return null;
    }

    @Override
    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.RUN_STYLE) {
            return Scannable.Attr.RunStyle.SYNC;
        }
        return super.scanUnsafe(key);
    }
}

