/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.reactor.core.publisher;

import java.util.Objects;
import org.graylog.shaded.opensearch2.org.reactivestreams.Publisher;
import org.graylog.shaded.opensearch2.reactor.core.CoreSubscriber;
import org.graylog.shaded.opensearch2.reactor.core.Fuseable;
import org.graylog.shaded.opensearch2.reactor.core.Scannable;
import org.graylog.shaded.opensearch2.reactor.core.publisher.Flux;
import org.graylog.shaded.opensearch2.reactor.core.publisher.FluxHide;
import org.graylog.shaded.opensearch2.reactor.core.publisher.InternalFluxOperator;
import org.graylog.shaded.opensearch2.reactor.core.publisher.Operators;

final class FluxLiftFuseable<I, O>
extends InternalFluxOperator<I, O>
implements Fuseable {
    final Operators.LiftFunction<I, O> liftFunction;

    FluxLiftFuseable(Publisher<I> p, Operators.LiftFunction<I, O> liftFunction) {
        super(Flux.from(p));
        this.liftFunction = liftFunction;
    }

    @Override
    public String stepName() {
        if (this.source instanceof Scannable) {
            return Scannable.from(this.source).stepName();
        }
        return super.stepName();
    }

    @Override
    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.RUN_STYLE) {
            return Scannable.from(this.source).scanUnsafe(key);
        }
        if (key == Scannable.Attr.LIFTER) {
            return this.liftFunction.name;
        }
        return super.scanUnsafe(key);
    }

    @Override
    public CoreSubscriber<? super I> subscribeOrReturn(CoreSubscriber<? super O> actual) {
        CoreSubscriber input = this.liftFunction.lifter.apply(this.source, actual);
        Objects.requireNonNull(input, "Lifted subscriber MUST NOT be null");
        if (actual instanceof Fuseable.QueueSubscription && !(input instanceof Fuseable.QueueSubscription)) {
            input = new FluxHide.SuppressFuseableSubscriber(input);
        }
        return input;
    }
}

