/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.transport;

import java.io.EOFException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.BytesRef;
import org.graylog.shaded.opensearch2.org.opensearch.Version;
import org.graylog.shaded.opensearch2.org.opensearch.common.unit.TimeValue;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.concurrent.AbstractRunnable;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.concurrent.ThreadContext;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.ByteBufferStreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.NamedWriteableAwareStreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.NamedWriteableRegistry;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.transport.TransportAddress;
import org.graylog.shaded.opensearch2.org.opensearch.core.transport.TransportMessage;
import org.graylog.shaded.opensearch2.org.opensearch.core.transport.TransportResponse;
import org.graylog.shaded.opensearch2.org.opensearch.telemetry.tracing.Span;
import org.graylog.shaded.opensearch2.org.opensearch.telemetry.tracing.SpanBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.telemetry.tracing.SpanScope;
import org.graylog.shaded.opensearch2.org.opensearch.telemetry.tracing.Tracer;
import org.graylog.shaded.opensearch2.org.opensearch.telemetry.tracing.channels.TraceableTcpTransportChannel;
import org.graylog.shaded.opensearch2.org.opensearch.threadpool.ThreadPool;
import org.graylog.shaded.opensearch2.org.opensearch.transport.Header;
import org.graylog.shaded.opensearch2.org.opensearch.transport.InboundMessage;
import org.graylog.shaded.opensearch2.org.opensearch.transport.OutboundHandler;
import org.graylog.shaded.opensearch2.org.opensearch.transport.RemoteTransportException;
import org.graylog.shaded.opensearch2.org.opensearch.transport.RequestHandlerRegistry;
import org.graylog.shaded.opensearch2.org.opensearch.transport.ResponseHandlerFailureTransportException;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TcpChannel;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TcpTransportChannel;
import org.graylog.shaded.opensearch2.org.opensearch.transport.Transport;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportChannel;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportHandshaker;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportKeepAlive;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportLogger;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportMessageListener;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportRequest;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportResponseHandler;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportSerializationException;

public class InboundHandler {
    private static final Logger logger = LogManager.getLogger(InboundHandler.class);
    private final ThreadPool threadPool;
    private final OutboundHandler outboundHandler;
    private final NamedWriteableRegistry namedWriteableRegistry;
    private final TransportHandshaker handshaker;
    private final TransportKeepAlive keepAlive;
    private final Transport.ResponseHandlers responseHandlers;
    private final Transport.RequestHandlers requestHandlers;
    private volatile TransportMessageListener messageListener = TransportMessageListener.NOOP_LISTENER;
    private volatile long slowLogThresholdMs = Long.MAX_VALUE;
    private final Tracer tracer;
    private static final StreamInput EMPTY_STREAM_INPUT = new ByteBufferStreamInput(ByteBuffer.wrap(BytesRef.EMPTY_BYTES));

    InboundHandler(ThreadPool threadPool, OutboundHandler outboundHandler, NamedWriteableRegistry namedWriteableRegistry, TransportHandshaker handshaker, TransportKeepAlive keepAlive, Transport.RequestHandlers requestHandlers, Transport.ResponseHandlers responseHandlers, Tracer tracer) {
        this.threadPool = threadPool;
        this.outboundHandler = outboundHandler;
        this.namedWriteableRegistry = namedWriteableRegistry;
        this.handshaker = handshaker;
        this.keepAlive = keepAlive;
        this.requestHandlers = requestHandlers;
        this.responseHandlers = responseHandlers;
        this.tracer = tracer;
    }

    void setMessageListener(TransportMessageListener listener) {
        if (this.messageListener != TransportMessageListener.NOOP_LISTENER) {
            throw new IllegalStateException("Cannot set message listener twice");
        }
        this.messageListener = listener;
    }

    void setSlowLogThreshold(TimeValue slowLogThreshold) {
        this.slowLogThresholdMs = slowLogThreshold.getMillis();
    }

    void inboundMessage(TcpChannel channel, InboundMessage message) throws Exception {
        long startTime = this.threadPool.relativeTimeInMillis();
        channel.getChannelStats().markAccessed(startTime);
        TransportLogger.logInboundMessage(channel, message);
        if (message.isPing()) {
            this.keepAlive.receiveKeepAlive(channel);
        } else {
            this.messageReceived(channel, message, startTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void messageReceived(TcpChannel channel, InboundMessage message, long startTime) throws IOException {
        InetSocketAddress remoteAddress = channel.getRemoteAddress();
        Header header = message.getHeader();
        assert (!header.needsToReadVariableHeader());
        ThreadContext threadContext = this.threadPool.getThreadContext();
        try (ThreadContext.StoredContext existing = threadContext.stashContext();){
            threadContext.setHeaders(header.getHeaders());
            threadContext.putTransient("_remote_address", remoteAddress);
            if (header.isRequest()) {
                this.handleRequest(channel, header, message);
            } else {
                TransportResponseHandler<? extends TransportResponse> theHandler;
                assert (!message.isShortCircuit());
                long requestId = header.getRequestId();
                TransportResponseHandler<TransportResponse> handler = header.isHandshake() ? this.handshaker.removeHandlerForHandshake(requestId) : ((theHandler = this.responseHandlers.onResponseReceived(requestId, this.messageListener)) == null && header.isError() ? this.handshaker.removeHandlerForHandshake(requestId) : theHandler);
                if (handler != null) {
                    if (message.getContentLength() > 0 || !header.getVersion().equals(Version.CURRENT)) {
                        StreamInput streamInput = this.namedWriteableStream(message.openOrGetStreamInput());
                        InboundHandler.assertRemoteVersion(streamInput, header.getVersion());
                        if (header.isError()) {
                            this.handlerResponseError(requestId, streamInput, handler);
                        } else {
                            this.handleResponse(requestId, remoteAddress, streamInput, handler);
                        }
                    } else {
                        assert (!header.isError());
                        this.handleResponse(requestId, remoteAddress, EMPTY_STREAM_INPUT, handler);
                    }
                }
            }
        }
        finally {
            long took = this.threadPool.relativeTimeInMillis() - startTime;
            long logThreshold = this.slowLogThresholdMs;
            if (logThreshold > 0L && took > logThreshold) {
                logger.warn("handling inbound transport message [{}] took [{}ms] which is above the warn threshold of [{}ms]", (Object)message, (Object)took, (Object)logThreshold);
            }
        }
    }

    private Map<String, Collection<String>> extractHeaders(Map<String, String> headers) {
        return headers.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> Collections.singleton((String)e.getValue())));
    }

    private <T extends TransportRequest> void handleRequest(TcpChannel channel, Header header, InboundMessage message) throws IOException {
        block20: {
            String action = header.getActionName();
            long requestId = header.getRequestId();
            Version version = header.getVersion();
            Map<String, Collection<String>> headers = this.extractHeaders(header.getHeaders().v1());
            Span span = this.tracer.startSpan(SpanBuilder.from(action, channel), headers);
            try (SpanScope spanScope = this.tracer.withSpanInScope(span);){
                if (header.isHandshake()) {
                    this.messageListener.onRequestReceived(requestId, action);
                    assert (!message.isShortCircuit());
                    StreamInput stream = this.namedWriteableStream(message.openOrGetStreamInput());
                    InboundHandler.assertRemoteVersion(stream, header.getVersion());
                    TcpTransportChannel transportChannel = new TcpTransportChannel(this.outboundHandler, channel, action, requestId, version, header.getFeatures(), header.isCompressed(), header.isHandshake(), message.takeBreakerReleaseControl());
                    TransportChannel traceableTransportChannel = TraceableTcpTransportChannel.create(transportChannel, span, this.tracer);
                    try {
                        this.handshaker.handleHandshake(traceableTransportChannel, requestId, stream);
                    }
                    catch (Exception e) {
                        if (Version.CURRENT.isCompatible(header.getVersion())) {
                            InboundHandler.sendErrorResponse(action, traceableTransportChannel, e);
                            break block20;
                        }
                        logger.warn((Message)new ParameterizedMessage("could not send error response to handshake received on [{}] using wire format version [{}], closing channel", (Object)channel, (Object)header.getVersion()), (Throwable)e);
                        channel.close();
                    }
                    break block20;
                }
                TcpTransportChannel transportChannel = new TcpTransportChannel(this.outboundHandler, channel, action, requestId, version, header.getFeatures(), header.isCompressed(), header.isHandshake(), message.takeBreakerReleaseControl());
                TransportChannel traceableTransportChannel = TraceableTcpTransportChannel.create(transportChannel, span, this.tracer);
                try {
                    this.messageListener.onRequestReceived(requestId, action);
                    if (message.isShortCircuit()) {
                        InboundHandler.sendErrorResponse(action, traceableTransportChannel, message.getException());
                        break block20;
                    }
                    StreamInput stream = this.namedWriteableStream(message.openOrGetStreamInput());
                    InboundHandler.assertRemoteVersion(stream, header.getVersion());
                    RequestHandlerRegistry reg = this.requestHandlers.getHandler(action);
                    assert (reg != null);
                    Object request = this.newRequest(requestId, action, stream, reg);
                    ((TransportMessage)request).remoteAddress(new TransportAddress(channel.getRemoteAddress()));
                    this.checkStreamIsFullyConsumed(requestId, action, stream);
                    String executor = reg.getExecutor();
                    if ("same".equals(executor)) {
                        try {
                            reg.processMessageReceived(request, traceableTransportChannel);
                        }
                        catch (Exception e) {
                            InboundHandler.sendErrorResponse(reg.getAction(), traceableTransportChannel, e);
                        }
                        break block20;
                    }
                    this.threadPool.executor(executor).execute(new RequestHandler(reg, request, traceableTransportChannel));
                }
                catch (Exception e) {
                    InboundHandler.sendErrorResponse(action, traceableTransportChannel, e);
                }
            }
            catch (Exception e) {
                span.setError(e);
                span.endSpan();
                throw e;
            }
        }
    }

    private <T extends TransportRequest> T newRequest(long requestId, String action, StreamInput stream, RequestHandlerRegistry<T> reg) throws IOException {
        try {
            return reg.newRequest(stream);
        }
        catch (EOFException e) {
            throw new IllegalStateException("Message fully read (request) but more data is expected for requestId [" + requestId + "], action [" + action + "]; resetting", e);
        }
    }

    private void checkStreamIsFullyConsumed(long requestId, String action, StreamInput stream) throws IOException {
        int nextByte = stream.read();
        if (nextByte != -1) {
            throw new IllegalStateException("Message not fully read (request) for requestId [" + requestId + "], action [" + action + "], available [" + stream.available() + "]; resetting");
        }
    }

    private void checkStreamIsFullyConsumed(long requestId, TransportResponseHandler<?> handler, StreamInput stream, boolean error) throws IOException {
        int nextByte;
        if (stream != EMPTY_STREAM_INPUT && (nextByte = stream.read()) != -1) {
            throw new IllegalStateException("Message not fully read (response) for requestId [" + requestId + "], handler [" + String.valueOf(handler) + "], error [" + error + "]; resetting");
        }
    }

    private static void sendErrorResponse(String actionName, TransportChannel transportChannel, Exception e) {
        try {
            transportChannel.sendResponse(e);
        }
        catch (Exception inner) {
            inner.addSuppressed(e);
            logger.warn(() -> new ParameterizedMessage("Failed to send error message back to client for action [{}]", (Object)actionName), (Throwable)inner);
        }
    }

    private <T extends TransportResponse> void handleResponse(long requestId, InetSocketAddress remoteAddress, StreamInput stream, TransportResponseHandler<T> handler) {
        TransportResponse response;
        try {
            response = (TransportResponse)handler.read(stream);
            response.remoteAddress(new TransportAddress(remoteAddress));
            this.checkStreamIsFullyConsumed(requestId, handler, stream, false);
        }
        catch (Exception e) {
            TransportSerializationException serializationException = new TransportSerializationException("Failed to deserialize response from handler [" + String.valueOf(handler) + "]", e);
            logger.warn((Message)new ParameterizedMessage("Failed to deserialize response from [{}]", (Object)remoteAddress), (Throwable)serializationException);
            this.handleException(handler, serializationException);
            return;
        }
        String executor = handler.executor();
        if ("same".equals(executor)) {
            this.doHandleResponse(handler, response);
        } else {
            this.threadPool.executor(executor).execute(() -> this.doHandleResponse(handler, response));
        }
    }

    private <T extends TransportResponse> void doHandleResponse(TransportResponseHandler<T> handler, T response) {
        try {
            handler.handleResponse(response);
        }
        catch (Exception e) {
            this.handleException(handler, new ResponseHandlerFailureTransportException(e));
        }
    }

    private void handlerResponseError(long requestId, StreamInput stream, TransportResponseHandler<?> handler) {
        Object error;
        try {
            error = stream.readException();
            this.checkStreamIsFullyConsumed(requestId, handler, stream, true);
        }
        catch (Exception e) {
            error = new TransportSerializationException("Failed to deserialize exception response from stream for handler [" + String.valueOf(handler) + "]", e);
        }
        this.handleException(handler, (Throwable)error);
    }

    private void handleException(TransportResponseHandler<?> handler, Throwable error) {
        if (!(error instanceof RemoteTransportException)) {
            error = new RemoteTransportException(error.getMessage(), error);
        }
        RemoteTransportException rtx = (RemoteTransportException)error;
        this.threadPool.executor(handler.executor()).execute(() -> {
            try {
                handler.handleException(rtx);
            }
            catch (Exception e) {
                logger.error(() -> new ParameterizedMessage("failed to handle exception response [{}]", (Object)handler), (Throwable)e);
            }
        });
    }

    private StreamInput namedWriteableStream(StreamInput delegate) {
        return new NamedWriteableAwareStreamInput(delegate, this.namedWriteableRegistry);
    }

    static void assertRemoteVersion(StreamInput in, Version version) {
        assert (version.equals(in.getVersion())) : "Stream version [" + String.valueOf(in.getVersion()) + "] does not match version [" + String.valueOf(version) + "]";
    }

    private static class RequestHandler<T extends TransportRequest>
    extends AbstractRunnable {
        private final RequestHandlerRegistry<T> reg;
        private final T request;
        private final TransportChannel transportChannel;

        RequestHandler(RequestHandlerRegistry<T> reg, T request, TransportChannel transportChannel) {
            this.reg = reg;
            this.request = request;
            this.transportChannel = transportChannel;
        }

        @Override
        protected void doRun() throws Exception {
            this.reg.processMessageReceived(this.request, this.transportChannel);
        }

        @Override
        public boolean isForceExecution() {
            return this.reg.isForceExecution();
        }

        @Override
        public void onFailure(Exception e) {
            InboundHandler.sendErrorResponse(this.reg.getAction(), this.transportChannel, e);
        }
    }
}

