/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.threadpool;

import java.util.List;
import org.graylog.shaded.opensearch2.org.opensearch.common.annotation.PublicApi;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.Setting;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.Settings;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.concurrent.OpenSearchExecutors;
import org.graylog.shaded.opensearch2.org.opensearch.common.util.concurrent.ThreadContext;
import org.graylog.shaded.opensearch2.org.opensearch.threadpool.ThreadPool;

@PublicApi(since="1.0.0")
public abstract class ExecutorBuilder<U extends ExecutorSettings> {
    private final String name;

    public ExecutorBuilder(String name) {
        this.name = name;
    }

    protected String name() {
        return this.name;
    }

    protected static String settingsKey(String prefix, String key) {
        return String.join((CharSequence)".", prefix, key);
    }

    protected int applyHardSizeLimit(Settings settings, String name) {
        if (name.equals("bulk") || name.equals("write") || name.equals("system_write")) {
            return 1 + OpenSearchExecutors.allocatedProcessors(settings);
        }
        return Integer.MAX_VALUE;
    }

    public abstract List<Setting<?>> getRegisteredSettings();

    abstract U getSettings(Settings var1);

    abstract ThreadPool.ExecutorHolder build(U var1, ThreadContext var2);

    abstract String formatInfo(ThreadPool.Info var1);

    static abstract class ExecutorSettings {
        protected final String nodeName;

        ExecutorSettings(String nodeName) {
            this.nodeName = nodeName;
        }
    }
}

