/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.tasks;

import java.util.concurrent.atomic.AtomicBoolean;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.ClusterSettings;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.Setting;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.Settings;
import org.graylog.shaded.opensearch2.org.opensearch.common.unit.TimeValue;

public class TaskCancellationMonitoringSettings {
    public static final long INTERVAL_MILLIS_SETTING_DEFAULT_VALUE = 5000L;
    public static final long DURATION_MILLIS_SETTING_DEFAULT_VALUE = 10000L;
    public static final boolean IS_ENABLED_SETTING_DEFAULT_VALUE = true;
    public static final Setting<Long> INTERVAL_MILLIS_SETTING = Setting.longSetting("task_cancellation.interval_millis", 5000L, 1L, Setting.Property.NodeScope);
    public static final Setting<Long> DURATION_MILLIS_SETTING = Setting.longSetting("task_cancellation.duration_millis", 10000L, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Boolean> IS_ENABLED_SETTING = Setting.boolSetting("task_cancellation.enabled", true, Setting.Property.Dynamic, Setting.Property.NodeScope);
    private final TimeValue interval;
    private TimeValue duration;
    private final AtomicBoolean isEnabled;
    private final Settings settings;
    private final ClusterSettings clusterSettings;

    public TaskCancellationMonitoringSettings(Settings settings, ClusterSettings clusterSettings) {
        this.settings = settings;
        this.clusterSettings = clusterSettings;
        this.interval = new TimeValue(INTERVAL_MILLIS_SETTING.get(settings));
        this.duration = new TimeValue(DURATION_MILLIS_SETTING.get(settings));
        this.isEnabled = new AtomicBoolean(IS_ENABLED_SETTING.get(settings));
        clusterSettings.addSettingsUpdateConsumer(IS_ENABLED_SETTING, this::setIsEnabled);
        clusterSettings.addSettingsUpdateConsumer(DURATION_MILLIS_SETTING, this::setDurationMillis);
    }

    public TimeValue getInterval() {
        return this.interval;
    }

    public TimeValue getDuration() {
        return this.duration;
    }

    public void setDurationMillis(long durationMillis) {
        this.duration = new TimeValue(durationMillis);
    }

    public boolean isEnabled() {
        return this.isEnabled.get();
    }

    public void setIsEnabled(boolean isEnabled) {
        this.isEnabled.set(isEnabled);
    }
}

