/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.search.profile.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.Collector;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.CollectorManager;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.AggregationCollectorManager;
import org.graylog.shaded.opensearch2.org.opensearch.search.profile.query.CollectorResult;
import org.graylog.shaded.opensearch2.org.opensearch.search.profile.query.InternalProfileCollector;
import org.graylog.shaded.opensearch2.org.opensearch.search.profile.query.InternalProfileComponent;
import org.graylog.shaded.opensearch2.org.opensearch.search.profile.query.ProfileCollectorManager;
import org.graylog.shaded.opensearch2.org.opensearch.search.query.EarlyTerminatingListener;
import org.graylog.shaded.opensearch2.org.opensearch.search.query.ReduceableSearchResult;

public class InternalProfileCollectorManager
implements ProfileCollectorManager<InternalProfileCollector, ReduceableSearchResult>,
EarlyTerminatingListener {
    private final CollectorManager<? extends Collector, ReduceableSearchResult> manager;
    private final String reason;
    private final List<InternalProfileCollectorManager> children;
    private long time = 0L;
    private long reduceTime = 0L;
    private long maxSliceEndTime = Long.MIN_VALUE;
    private long minSliceStartTime = Long.MAX_VALUE;
    private long maxSliceTime = 0L;
    private long minSliceTime = Long.MAX_VALUE;
    private long avgSliceTime = 0L;
    private int sliceCount = 0;
    private String collectorManagerName;

    public InternalProfileCollectorManager(CollectorManager<? extends Collector, ReduceableSearchResult> manager, String reason, List<InternalProfileCollectorManager> children) {
        this.manager = manager;
        this.reason = reason;
        this.collectorManagerName = this.deriveCollectorManagerName(manager);
        this.children = children;
    }

    private String deriveCollectorManagerName(CollectorManager<? extends Collector, ReduceableSearchResult> manager) {
        Object name = manager.getClass().getSimpleName();
        if (((String)name).equals("")) {
            name = manager.getClass().getEnclosingClass().getSimpleName();
        }
        if (manager instanceof AggregationCollectorManager) {
            name = (String)name + ": [" + ((AggregationCollectorManager)manager).getCollectorName() + "]";
        }
        return name;
    }

    @Override
    public InternalProfileCollector newCollector() throws IOException {
        return new InternalProfileCollector(this.manager.newCollector(), this.reason, this.children);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReduceableSearchResult reduce(Collection<InternalProfileCollector> collectors) throws IOException {
        long reduceStart = System.nanoTime();
        try {
            ArrayList<Collector> subs = new ArrayList<Collector>();
            for (InternalProfileCollector collector : collectors) {
                subs.add(collector.getCollector());
                this.maxSliceEndTime = Math.max(this.maxSliceEndTime, collector.getSliceStartTime() + collector.getTime());
                this.minSliceStartTime = Math.min(this.minSliceStartTime, collector.getSliceStartTime());
                this.maxSliceTime = Math.max(this.maxSliceTime, collector.getTime());
                this.minSliceTime = Math.min(this.minSliceTime, collector.getTime());
                this.avgSliceTime += collector.getTime();
            }
            this.time = this.maxSliceEndTime - this.minSliceStartTime;
            this.sliceCount = collectors.size();
            this.avgSliceTime = this.sliceCount == 0 ? 0L : this.avgSliceTime / (long)this.sliceCount;
            ReduceableSearchResult reduceableSearchResult = this.manager.reduce(subs);
            return reduceableSearchResult;
        }
        finally {
            this.reduceTime = Math.max(1L, System.nanoTime() - reduceStart);
        }
    }

    @Override
    public String getReason() {
        return this.reason;
    }

    @Override
    public long getTime() {
        return this.time;
    }

    public long getReduceTime() {
        return this.reduceTime;
    }

    public long getMaxSliceTime() {
        return this.maxSliceTime;
    }

    public long getMinSliceTime() {
        return this.minSliceTime;
    }

    public long getAvgSliceTime() {
        return this.avgSliceTime;
    }

    public int getSliceCount() {
        return this.sliceCount;
    }

    @Override
    public Collection<? extends InternalProfileComponent> children() {
        return this.children;
    }

    @Override
    public String getName() {
        return this.collectorManagerName;
    }

    @Override
    public CollectorResult getCollectorTree() {
        return InternalProfileCollectorManager.doGetCollectorManagerTree(this);
    }

    static CollectorResult doGetCollectorManagerTree(InternalProfileCollectorManager collector) {
        ArrayList<CollectorResult> childResults = new ArrayList<CollectorResult>(collector.children().size());
        for (InternalProfileComponent internalProfileComponent : collector.children()) {
            CollectorResult result = InternalProfileCollectorManager.doGetCollectorManagerTree((InternalProfileCollectorManager)internalProfileComponent);
            childResults.add(result);
        }
        return new CollectorResult(collector.getName(), collector.getReason(), collector.getTime(), collector.getReduceTime(), collector.getMaxSliceTime(), collector.getMinSliceTime(), collector.getAvgSliceTime(), collector.getSliceCount(), childResults);
    }

    @Override
    public void onEarlyTermination(int maxCountHits, boolean forcedTermination) {
        if (this.manager instanceof EarlyTerminatingListener) {
            ((EarlyTerminatingListener)((Object)this.manager)).onEarlyTermination(maxCountHits, forcedTermination);
        }
    }
}

