/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.search.profile;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.graylog.shaded.opensearch2.org.opensearch.LegacyESVersion;
import org.graylog.shaded.opensearch2.org.opensearch.Version;
import org.graylog.shaded.opensearch2.org.opensearch.common.annotation.PublicApi;
import org.graylog.shaded.opensearch2.org.opensearch.common.unit.TimeValue;
import org.graylog.shaded.opensearch2.org.opensearch.core.ParseField;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamInput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.StreamOutput;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.io.stream.Writeable;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ConstructingObjectParser;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.InstantiatingObjectParser;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContent;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContentObject;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentParser;

@PublicApi(since="1.0.0")
public final class ProfileResult
implements Writeable,
ToXContentObject {
    static final ParseField TYPE = new ParseField("type", new String[0]);
    static final ParseField DESCRIPTION = new ParseField("description", new String[0]);
    static final ParseField BREAKDOWN = new ParseField("breakdown", new String[0]);
    static final ParseField DEBUG = new ParseField("debug", new String[0]);
    static final ParseField NODE_TIME = new ParseField("time", new String[0]);
    static final ParseField MAX_SLICE_NODE_TIME = new ParseField("max_slice_time", new String[0]);
    static final ParseField MIN_SLICE_NODE_TIME = new ParseField("min_slice_time", new String[0]);
    static final ParseField AVG_SLICE_NODE_TIME = new ParseField("avg_slice_time", new String[0]);
    static final ParseField NODE_TIME_RAW = new ParseField("time_in_nanos", new String[0]);
    static final ParseField MAX_SLICE_NODE_TIME_RAW = new ParseField("max_slice_time_in_nanos", new String[0]);
    static final ParseField MIN_SLICE_NODE_TIME_RAW = new ParseField("min_slice_time_in_nanos", new String[0]);
    static final ParseField AVG_SLICE_NODE_TIME_RAW = new ParseField("avg_slice_time_in_nanos", new String[0]);
    static final ParseField CHILDREN = new ParseField("children", new String[0]);
    private final String type;
    private final String description;
    private final Map<String, Long> breakdown;
    private final Map<String, Object> debug;
    private final long nodeTime;
    private Long maxSliceNodeTime;
    private Long minSliceNodeTime;
    private Long avgSliceNodeTime;
    private final List<ProfileResult> children;
    private static final InstantiatingObjectParser<ProfileResult, Void> PARSER;

    public ProfileResult(String type, String description, Map<String, Long> breakdown, Map<String, Object> debug, long nodeTime, List<ProfileResult> children) {
        this(type, description, breakdown, debug, nodeTime, children, null, null, null);
    }

    public ProfileResult(String type, String description, Map<String, Long> breakdown, Map<String, Object> debug, long nodeTime, List<ProfileResult> children, Long maxSliceNodeTime, Long minSliceNodeTime, Long avgSliceNodeTime) {
        this.type = type;
        this.description = description;
        this.breakdown = Objects.requireNonNull(breakdown, "required breakdown argument missing");
        this.debug = debug == null ? Map.of() : debug;
        this.children = children == null ? List.of() : children;
        this.nodeTime = nodeTime;
        this.maxSliceNodeTime = maxSliceNodeTime;
        this.minSliceNodeTime = minSliceNodeTime;
        this.avgSliceNodeTime = avgSliceNodeTime;
    }

    public ProfileResult(StreamInput in) throws IOException {
        this.type = in.readString();
        this.description = in.readString();
        this.nodeTime = in.readLong();
        this.breakdown = in.readMap(StreamInput::readString, StreamInput::readLong);
        this.debug = in.getVersion().onOrAfter(LegacyESVersion.V_7_9_0) ? in.readMap(StreamInput::readString, StreamInput::readGenericValue) : Map.of();
        this.children = in.readList(ProfileResult::new);
        if (in.getVersion().onOrAfter(Version.V_2_10_0)) {
            this.maxSliceNodeTime = in.readOptionalLong();
            this.minSliceNodeTime = in.readOptionalLong();
            this.avgSliceNodeTime = in.readOptionalLong();
        } else {
            this.maxSliceNodeTime = null;
            this.minSliceNodeTime = null;
            this.avgSliceNodeTime = null;
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.type);
        out.writeString(this.description);
        out.writeLong(this.nodeTime);
        out.writeMap(this.breakdown, StreamOutput::writeString, StreamOutput::writeLong);
        if (out.getVersion().onOrAfter(LegacyESVersion.V_7_9_0)) {
            out.writeMap(this.debug, StreamOutput::writeString, StreamOutput::writeGenericValue);
        }
        out.writeList(this.children);
        if (out.getVersion().onOrAfter(Version.V_2_10_0)) {
            out.writeOptionalLong(this.maxSliceNodeTime);
            out.writeOptionalLong(this.minSliceNodeTime);
            out.writeOptionalLong(this.avgSliceNodeTime);
        }
    }

    public String getLuceneDescription() {
        return this.description;
    }

    public String getQueryName() {
        return this.type;
    }

    public Map<String, Long> getTimeBreakdown() {
        return Collections.unmodifiableMap(this.breakdown);
    }

    public Map<String, Object> getDebugInfo() {
        return Collections.unmodifiableMap(this.debug);
    }

    public long getTime() {
        return this.nodeTime;
    }

    public Long getMaxSliceTime() {
        return this.maxSliceNodeTime;
    }

    public Long getMinSliceTime() {
        return this.minSliceNodeTime;
    }

    public Long getAvgSliceTime() {
        return this.avgSliceNodeTime;
    }

    public List<ProfileResult> getProfiledChildren() {
        return Collections.unmodifiableList(this.children);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(TYPE.getPreferredName(), this.type);
        builder.field(DESCRIPTION.getPreferredName(), this.description);
        if (builder.humanReadable()) {
            builder.field(NODE_TIME.getPreferredName(), new TimeValue(this.getTime(), TimeUnit.NANOSECONDS).toString());
            if (this.getMaxSliceTime() != null) {
                builder.field(MAX_SLICE_NODE_TIME.getPreferredName(), new TimeValue(this.getMaxSliceTime(), TimeUnit.NANOSECONDS).toString());
            }
            if (this.getMinSliceTime() != null) {
                builder.field(MIN_SLICE_NODE_TIME.getPreferredName(), new TimeValue(this.getMinSliceTime(), TimeUnit.NANOSECONDS).toString());
            }
            if (this.getAvgSliceTime() != null) {
                builder.field(AVG_SLICE_NODE_TIME.getPreferredName(), new TimeValue(this.getAvgSliceTime(), TimeUnit.NANOSECONDS).toString());
            }
        }
        builder.field(NODE_TIME_RAW.getPreferredName(), this.getTime());
        if (this.getMaxSliceTime() != null) {
            builder.field(MAX_SLICE_NODE_TIME_RAW.getPreferredName(), this.getMaxSliceTime());
        }
        if (this.getMinSliceTime() != null) {
            builder.field(MIN_SLICE_NODE_TIME_RAW.getPreferredName(), this.getMinSliceTime());
        }
        if (this.getAvgSliceTime() != null) {
            builder.field(AVG_SLICE_NODE_TIME_RAW.getPreferredName(), this.getAvgSliceTime());
        }
        this.createBreakdownView(builder);
        if (!this.debug.isEmpty()) {
            builder.field(DEBUG.getPreferredName(), this.debug);
        }
        if (!this.children.isEmpty()) {
            builder.startArray(CHILDREN.getPreferredName());
            for (ProfileResult child : this.children) {
                builder = child.toXContent(builder, params);
            }
            builder.endArray();
        }
        return builder.endObject();
    }

    private void createBreakdownView(XContentBuilder builder) throws IOException {
        LinkedHashMap<String, Long> modifiedBreakdown = new LinkedHashMap<String, Long>(this.breakdown);
        ProfileResult.removeStartTimeFields(modifiedBreakdown);
        builder.field(BREAKDOWN.getPreferredName(), modifiedBreakdown);
    }

    static void removeStartTimeFields(Map<String, Long> modifiedBreakdown) {
        Iterator<Map.Entry<String, Long>> iterator = modifiedBreakdown.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Long> entry = iterator.next();
            if (!entry.getKey().endsWith("_start_time")) continue;
            iterator.remove();
        }
    }

    public static ProfileResult fromXContent(XContentParser p) throws IOException {
        return PARSER.parse(p, null);
    }

    static {
        InstantiatingObjectParser.Builder<ProfileResult, Void> parser = InstantiatingObjectParser.builder("profile_result", true, ProfileResult.class);
        parser.declareString(ConstructingObjectParser.constructorArg(), TYPE);
        parser.declareString(ConstructingObjectParser.constructorArg(), DESCRIPTION);
        parser.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> p.map(), BREAKDOWN);
        parser.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.map(), DEBUG);
        parser.declareLong(ConstructingObjectParser.constructorArg(), NODE_TIME_RAW);
        parser.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> ProfileResult.fromXContent(p), CHILDREN);
        parser.declareLong(ConstructingObjectParser.optionalConstructorArg(), MAX_SLICE_NODE_TIME_RAW);
        parser.declareLong(ConstructingObjectParser.optionalConstructorArg(), MIN_SLICE_NODE_TIME_RAW);
        parser.declareLong(ConstructingObjectParser.optionalConstructorArg(), AVG_SLICE_NODE_TIME_RAW);
        PARSER = parser.build();
    }
}

