/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.search.internal;

import java.util.Collections;
import java.util.List;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.routing.ShardRouting;
import org.graylog.shaded.opensearch2.org.opensearch.common.SetOnce;
import org.graylog.shaded.opensearch2.org.opensearch.common.lease.Releasable;
import org.graylog.shaded.opensearch2.org.opensearch.common.lease.Releasables;
import org.graylog.shaded.opensearch2.org.opensearch.index.IndexService;
import org.graylog.shaded.opensearch2.org.opensearch.index.engine.Engine;
import org.graylog.shaded.opensearch2.org.opensearch.index.engine.Segment;
import org.graylog.shaded.opensearch2.org.opensearch.index.shard.IndexShard;
import org.graylog.shaded.opensearch2.org.opensearch.search.internal.ReaderContext;
import org.graylog.shaded.opensearch2.org.opensearch.search.internal.ShardSearchContextId;

public class PitReaderContext
extends ReaderContext {
    private final SetOnce<String> pitId = new SetOnce();
    private final SetOnce<Long> creationTime = new SetOnce();
    private final ShardRouting shardRouting;
    private final List<Segment> segments;

    public PitReaderContext(ShardSearchContextId id, IndexService indexService, IndexShard indexShard, Engine.SearcherSupplier searcherSupplier, long keepAliveInMillis, boolean singleSession) {
        super(id, indexService, indexShard, searcherSupplier, keepAliveInMillis, singleSession);
        this.shardRouting = indexShard.routingEntry();
        this.segments = indexShard.segments(true);
    }

    public String getPitId() {
        return this.pitId.get();
    }

    public void setPitId(String pitId) {
        this.pitId.set(pitId);
    }

    public Releasable updatePitIdAndKeepAlive(long keepAliveInMillis, String pitId, long createTime) {
        this.getRefCounted().incRef();
        this.tryUpdateKeepAlive(keepAliveInMillis);
        this.setPitId(pitId);
        this.setCreationTime(createTime);
        return Releasables.releaseOnce(() -> {
            this.updateLastAccessTime();
            this.getRefCounted().decRef();
        });
    }

    public long getCreationTime() {
        return this.creationTime.get() == null ? 0L : this.creationTime.get();
    }

    public void setCreationTime(long creationTime) {
        this.creationTime.set(creationTime);
    }

    public ShardRouting getShardRouting() {
        return this.shardRouting;
    }

    public List<Segment> getSegments() {
        return Collections.unmodifiableList(this.segments);
    }
}

