/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.search.fetch.subphase;

import java.io.IOException;
import org.graylog.shaded.opensearch2.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.IndexSearcher;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.ScoreMode;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.Scorer;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.ScorerSupplier;
import org.graylog.shaded.opensearch2.org.apache.lucene.search.Weight;
import org.graylog.shaded.opensearch2.org.opensearch.search.fetch.FetchContext;
import org.graylog.shaded.opensearch2.org.opensearch.search.fetch.FetchSubPhase;
import org.graylog.shaded.opensearch2.org.opensearch.search.fetch.FetchSubPhaseProcessor;
import org.graylog.shaded.opensearch2.org.opensearch.search.internal.ContextIndexSearcher;

public class FetchScorePhase
implements FetchSubPhase {
    @Override
    public FetchSubPhaseProcessor getProcessor(FetchContext context) throws IOException {
        if (!context.fetchScores()) {
            return null;
        }
        ContextIndexSearcher searcher = context.searcher();
        final Weight weight = ((IndexSearcher)searcher).createWeight(((IndexSearcher)searcher).rewrite(context.query()), ScoreMode.COMPLETE, 1.0f);
        return new FetchSubPhaseProcessor(){
            Scorer scorer;

            @Override
            public void setNextReader(LeafReaderContext readerContext) throws IOException {
                ScorerSupplier scorerSupplier = weight.scorerSupplier(readerContext);
                if (scorerSupplier == null) {
                    throw new IllegalStateException("Can't compute score on document as it doesn't match the query");
                }
                this.scorer = scorerSupplier.get(1L);
            }

            @Override
            public void process(FetchSubPhase.HitContext hitContext) throws IOException {
                if (this.scorer == null || this.scorer.iterator().advance(hitContext.docId()) != hitContext.docId()) {
                    throw new IllegalStateException("Can't compute score on document " + String.valueOf(hitContext) + " as it doesn't match the query");
                }
                hitContext.hit().score(this.scorer.score());
            }
        };
    }
}

